/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import whilepack.cid.Node;
import whilepack.cid.WhileUtils;

public class CaseCommandEntry {
    public String pattern;
    public ArrayList commands;
    public int line;

    public boolean matches(Node source) throws Exception {
        if (this.pattern.indexOf("(") == -1 && !WhileUtils.isKeyword(this.pattern)) {
            return true;
        }
        Node patternNode = WhileUtils.buildCaseTree(this.pattern);
        return this.matechesImpl(patternNode, source);
    }

    private boolean matechesImpl(Node patternNode, Node source) {
        if (patternNode == Node.NIL) {
            return source == Node.NIL;
        }
        if (patternNode.isCaseNode()) {
            return true;
        }
        if (source == Node.NIL) {
            return false;
        }
        Node patHead = patternNode.h;
        Node patTail = patternNode.t;
        Node srcHead = source.h;
        Node srcTail = source.t;
        boolean l = this.matechesImpl(patHead, srcHead);
        boolean r = this.matechesImpl(patTail, srcTail);
        return l && r;
    }

    public Map getCaseVariables(Node source) throws Exception {
        HashMap<String, Node> map = new HashMap<String, Node>();
        if (this.pattern.indexOf("(") == -1) {
            map.put(this.pattern.trim(), source);
            return map;
        }
        Node patternNode = WhileUtils.buildCaseTree(this.pattern);
        this.fill(map, patternNode, source);
        return map;
    }

    private void fill(Map map, Node patternNode, Node source) {
        if (patternNode == Node.NIL) {
            return;
        }
        if (patternNode.isCaseNode()) {
            map.put(patternNode.concreteName(), source);
            return;
        }
        Node patHead = patternNode.h;
        Node patTail = patternNode.t;
        Node srcHead = source.h;
        Node srcTail = source.t;
        this.fill(map, patHead, srcHead);
        this.fill(map, patTail, srcTail);
    }
}

