/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import whilepack.SysLog;
import whilepack.cid.CitedVarIndexNode;
import whilepack.cid.IndentationUtils;
import whilepack.cid.Node;

public class WhileUtils {
    public static File BASE_DIR = null;
    public static String BGN = "MM_";
    public static String END = "_MM";
    private static final int CASE = 0;
    private static final int ONLY_NILS = 1;
    private static final int RESERVED = 2;

    public static Node buildProgramTree(String spec) throws Exception {
        return WhileUtils.buildTree(WhileUtils.convertList(spec), 2);
    }

    public static Node buildCaseTree(String spec) throws Exception {
        return WhileUtils.routerForBuildTree(spec, 0);
    }

    public static Node buildInputTree(String spec) throws Exception {
        return WhileUtils.routerForBuildTree(spec, 2);
    }

    private static Node routerForBuildTree(String spec, int expect) throws Exception {
        Node node = WhileUtils.toNode(spec);
        if (node == null) {
            Citation cit = Citation.getCitation(spec);
            if (cit == null) {
                return WhileUtils.buildTree(WhileUtils.convertList(spec), expect);
            }
            return cit.getNode();
        }
        return node;
    }

    public static Node buildOnlyNils(String spec) throws Exception {
        return WhileUtils.buildTree(WhileUtils.convertList(spec), 1);
    }

    public static String toTree2(Node root) {
        if (root.isLeaf()) {
            return root.concreteName();
        }
        if (root == Node.NIL) {
            return Node.NIL.concreteName();
        }
        return "(" + WhileUtils.toTree2(root.h) + "." + WhileUtils.toTree2(root.t) + ")";
    }

    public static String toCaseTree(Node root) {
        if (root.isCaseNode()) {
            return root.concreteName();
        }
        if (root == Node.NIL) {
            return Node.NIL.concreteName();
        }
        return "(" + WhileUtils.toCaseTree(root.h) + "." + WhileUtils.toCaseTree(root.t) + ")";
    }

    public static int count(Node list) {
        int count = 0;
        while (list != Node.NIL) {
            ++count;
            list = list.t;
        }
        return count;
    }

    private static boolean isVarIndex(Node aNode) {
        if (aNode instanceof CitedVarIndexNode) {
            return true;
        }
        return WhileUtils.unaryValue(aNode) >= 0;
    }

    private static int unaryValue(Node list) {
        int count = 0;
        while (list != Node.NIL) {
            if (list.h != Node.NIL) {
                return -1;
            }
            ++count;
            list = list.t;
        }
        return count;
    }

    public static boolean isKeyword(String kw) {
        SysLog.out.println("kw=" + kw + "<");
        kw = kw.toUpperCase();
        if (kw.equals("VAR")) {
            return true;
        }
        if (kw.equals("CONS")) {
            return true;
        }
        if (kw.equals(";")) {
            return true;
        }
        if (kw.equals(":=")) {
            return true;
        }
        if (kw.equals("WHILE")) {
            return true;
        }
        if (kw.equals("IF")) {
            return true;
        }
        if (kw.equals("QUOTE")) {
            return true;
        }
        if (kw.equals("TL")) {
            return true;
        }
        if (kw.equals("HD")) {
            return true;
        }
        return kw.equals("NIL");
    }

    public static Node toNode(String _s) {
        String s = _s.trim().toUpperCase();
        if (s.equals("VAR")) {
            return Node.VAR;
        }
        if (s.equals("CONS")) {
            return Node.CONS;
        }
        if (s.equals(";")) {
            return Node.CONCAT;
        }
        if (s.equals(":=")) {
            return Node.ASSIGN;
        }
        if (s.equals("WHILE")) {
            return Node.WHILE;
        }
        if (s.equals("IF")) {
            return Node.IF;
        }
        if (s.equals("QUOTE")) {
            return Node.QUOTE;
        }
        if (s.equals("TL")) {
            return Node.TL;
        }
        if (s.equals("HD")) {
            return Node.HD;
        }
        if (s.equals("NIL")) {
            return Node.NIL;
        }
        if (WhileUtils.isNumber(s)) {
            return Node.unaryTree(Integer.parseInt(s));
        }
        return null;
    }

    private static boolean isNumber(String n) {
        try {
            return Integer.parseInt(n) >= 0;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static ArrayList convertList(String listStr) throws Exception {
        listStr = listStr.trim().replace('\n', ' ').replace('\t', ' ').replace('\r', ' ');
        StringTokenizer tok = new StringTokenizer(listStr, " '(.)", true);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (t.equals(" ")) continue;
            if (t.equals("(")) break;
            throw new Exception("Expression must start with '('");
        }
        if (!tok.hasMoreTokens()) {
            throw new Exception("Expression must start with '('");
        }
        ArrayList list = WhileUtils.convertList_impl(tok);
        if (tok.hasMoreTokens()) {
            throw new Exception("Expression is not terminated properly");
        }
        return list;
    }

    private static ArrayList convertList_impl(StringTokenizer tok) throws Exception {
        ArrayList<Object> items = new ArrayList<Object>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals(")")) {
                return items;
            }
            if (token.equals("'")) {
                String citation = "";
                boolean terminated = false;
                while (tok.hasMoreTokens()) {
                    String aToken = tok.nextToken();
                    if (aToken.equals("'")) {
                        terminated = true;
                        break;
                    }
                    citation = citation + aToken;
                }
                if (!terminated) {
                    throw new Exception("Citation doesn't end properly");
                }
                items.add(new Citation(citation));
                continue;
            }
            if (token.equals(" ")) continue;
            if (token.equals("(")) {
                items.add(WhileUtils.convertList_impl(tok));
                continue;
            }
            items.add(token);
        }
        throw new Exception("Expression is not terminated properly");
    }

    private static Node buildTree(ArrayList items, int expect) throws Exception {
        int dotIndex = items.indexOf(".");
        if (dotIndex != -1) {
            if (items.size() != 3) {
                throw new Exception("Invalid Tree Format");
            }
            if (dotIndex != 1) {
                throw new Exception("Invalid Tree Format");
            }
            Node h = WhileUtils.buildNode(items.get(0), expect);
            Node t = WhileUtils.buildNode(items.get(2), expect);
            return new Node(h, t);
        }
        Node anchor = Node.NIL;
        for (int i = items.size() - 1; i >= 0; --i) {
            Object o = items.get(i);
            anchor = new Node(WhileUtils.buildNode(o, expect), anchor);
        }
        return anchor;
    }

    private static Node buildNode(Object o, int expect) throws Exception {
        if (o instanceof String) {
            String constant = o.toString();
            Node node = WhileUtils.toNode(constant);
            if (node != Node.NIL && expect == 1) {
                throw new Exception("Non NIL node: " + constant);
            }
            if (node != null) {
                return node;
            }
            if (expect == 2) {
                throw new Exception("Unknown Node: " + constant);
            }
            if (expect == 0) {
                return Node.createCaseNode(constant);
            }
        } else {
            if (o instanceof Citation) {
                return ((Citation)o).getNode();
            }
            if (o instanceof ArrayList) {
                return WhileUtils.buildTree((ArrayList)o, expect);
            }
        }
        throw new Exception("Critical Error: Illegal ArrayList input");
    }

    public static String readFile(File file) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        String code = "";
        while ((line = in.readLine()) != null) {
            code = code + "\n" + line;
        }
        in.close();
        return code.substring(1);
    }

    public static void main(String[] args) throws Exception {
        String x = WhileUtils.readFile(new File("Study/AddNumbers.wcl"));
        x = "((while nil) (; nil var (nil) nil)nil(nil nil nil) nil))";
        Node node = WhileUtils.buildProgramTree(x);
        SysLog.out.println(WhileUtils.toList(node));
    }

    public static String toList(Node root) {
        if (root.isLeaf()) {
            return root.concreteName();
        }
        StringBuffer sb = new StringBuffer();
        WhileUtils.toList(root, sb, 0);
        return sb.toString();
    }

    private static Node toList(Node root, StringBuffer sb, int mind) {
        boolean lastTokenWasVar = false;
        Node firstListNodeType = null;
        int itemCount = 0;
        sb.append("(");
        while (root != Node.NIL) {
            Node head = root.h;
            ++itemCount;
            String leafName = "";
            if (lastTokenWasVar && WhileUtils.isVarIndex(head)) {
                if (head instanceof CitedVarIndexNode) {
                    CitedVarIndexNode citedVarIndexNode = (CitedVarIndexNode)head;
                    leafName = citedVarIndexNode.toString();
                } else {
                    int unaryValue = WhileUtils.unaryValue(head);
                    leafName = unaryValue + "";
                }
                sb.append(leafName);
            } else if (head.isLeaf()) {
                leafName = head.concreteName();
                if (itemCount == 1) {
                    firstListNodeType = head;
                }
                sb.append(leafName);
            } else {
                if (firstListNodeType == Node.WHILE && itemCount == 3 || firstListNodeType == Node.CONCAT && itemCount == 3 || firstListNodeType == Node.IF && itemCount >= 3) {
                    sb.append("\n");
                    sb.append(IndentationUtils.in(mind + 1));
                }
                int currentPosition = sb.length();
                int newMind = firstListNodeType == Node.CONCAT ? mind : mind + 1;
                Node firstNodeOfInnerList = WhileUtils.toList(head, sb, newMind);
                if (firstListNodeType == Node.CONCAT && itemCount == 3 && firstNodeOfInnerList != Node.CONCAT) {
                    sb.insert(currentPosition, IndentationUtils.spaces(3));
                    sb.append("\n");
                    sb.append(IndentationUtils.in(mind));
                }
            }
            boolean bl = lastTokenWasVar = head == Node.VAR;
            root = root.t;
            if (root == Node.NIL) continue;
            sb.append(" ");
        }
        sb.append(")");
        return firstListNodeType;
    }

    private static class Citation {
        String citation = "";

        Citation(String citation) {
            this.citation = citation;
        }

        String getCode() throws Exception {
            File file = new File(BASE_DIR, this.citation);
            if (!file.exists()) {
                throw new Exception("Citation Error: Cannot citate " + file.getAbsolutePath() + " (File not found)");
            }
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String line = null;
                String code = "";
                while ((line = in.readLine()) != null) {
                    if (line.startsWith(" ")) {
                        line = " " + line.trim();
                    } else if (line.endsWith(" ")) {
                        line = line.trim();
                    }
                    code = code + line + " ";
                }
                in.close();
                return code;
            }
            catch (IOException exp) {
                throw new Exception("Citation Error : Cannot citate " + file + " (" + exp.getMessage() + ")");
            }
        }

        Node getNode() throws Exception {
            String node = this.getCode();
            try {
                return WhileUtils.buildInputTree(node);
            }
            catch (Exception exp) {
                throw new Exception("Citation Error: Cannot citate " + this.citation + " (" + exp.getMessage() + ")");
            }
        }

        static Citation getCitation(String str) {
            str = str.trim();
            int start = str.indexOf("'");
            int end = str.indexOf("'", start + 1);
            if (start == -1 || end == -1) {
                return null;
            }
            if (end < str.length() - 1) {
                return null;
            }
            return new Citation(str.substring(start + 1, end).trim());
        }
    }
}

