/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.util.HashMap;
import whilepack.SysLog;
import whilepack.cid.Node;
import whilepack.cid.WhileUtils;

public class WhileTest {
    private Integer m_invar = null;
    private Integer m_outvar = null;
    private HashMap m_data = new HashMap();
    private boolean breakExecution = false;
    private int ii = 0;
    static String prog22 = "((VAR 0) (;     (:= (VAR 1) (HD (VAR 0)))     (:= (VAR 2) (TL (VAR 0)))     (:= (VAR 3) (HD (VAR 1)))     (:= (VAR 4) (HD (TL (VAR 1))))     (:= (VAR 5) (HD (TL (TL (VAR 1))))) ) (VAR 2)) ";

    private Node getData(Integer index) {
        if (!this.m_data.containsKey(index)) {
            this.m_data.put(index, Node.NIL);
        }
        return (Node)this.m_data.get(index);
    }

    private void setData(Integer index, Node value) {
        this.m_data.put(index, value);
    }

    public WhileTest(String program, Node input) throws Exception {
        this(WhileUtils.buildProgramTree(program), input);
    }

    public WhileTest(String program, String input) throws Exception {
        this(WhileUtils.buildProgramTree(program), WhileUtils.buildInputTree(input));
    }

    public WhileTest() {
    }

    private WhileTest(Node p, Node d) throws Exception {
        this.interpret(p, d);
    }

    public void interpret(Node p, Node d) throws Exception {
        Node invar = p.h;
        Node commands = p.t.h;
        Node outvar = p.t.t.h;
        this.m_invar = new Integer(WhileUtils.count(invar.t.h));
        this.m_outvar = new Integer(WhileUtils.count(outvar.t.h));
        SysLog.out.println(this.m_invar + "       " + this.m_outvar);
        this.setData(this.m_invar, d);
        this.breakExecution = false;
        this.executeCommand(commands);
    }

    public void breakInterpretation() {
        this.breakExecution = true;
    }

    public boolean wasInterpretationCanceled() {
        return this.breakExecution;
    }

    public Node getResult() {
        Node y = this.getData(this.m_outvar);
        return y;
    }

    private void executeCommand(Node command) throws Exception {
        if (this.breakExecution) {
            return;
        }
        Node commandType = command.h;
        if (commandType == Node.CONCAT) {
            Node commands = command.t;
            while (commands != Node.NIL) {
                if (this.breakExecution) {
                    return;
                }
                Node cmd = commands.h;
                this.executeCommand(cmd);
                commands = commands.t;
            }
        } else if (commandType == Node.ASSIGN) {
            Node varNode = command.t.h;
            Node expNode = command.t.t.h;
            Integer var = new Integer(WhileUtils.count(varNode.t.h));
            Node expression = this.computeExpression(expNode);
            this.setData(var, expression);
            try {
                Thread.sleep(1L);
            }
            catch (Exception sExp) {
                // empty catch block
            }
            SysLog.out.println(this.ii++);
        } else if (commandType == Node.WHILE) {
            Node exp = command.t.h;
            Node cmd = command.t.t.h;
            Node result = this.computeExpression(exp);
            while (result != Node.NIL) {
                if (this.breakExecution) {
                    return;
                }
                SysLog.out.println("in WHILE");
                try {
                    Thread.sleep(1L);
                }
                catch (Exception sExp) {
                    // empty catch block
                }
                this.executeCommand(cmd);
                result = this.computeExpression(exp);
            }
        } else if (commandType == Node.IF) {
            Node exp = command.t.h;
            Node cmd1 = command.t.t.h;
            Node cmd2 = command.t.t.t;
            Node result = this.computeExpression(exp);
            if (result != Node.NIL) {
                this.executeCommand(cmd1);
            } else if (cmd2 != Node.NIL) {
                this.executeCommand(cmd2.h);
            }
        } else {
            throw new Exception("Illegal Command Type " + commandType);
        }
    }

    private Node computeExpression(Node exp) throws Exception {
        if (this.breakExecution) {
            return Node.NIL;
        }
        Node expType = exp.h;
        if (expType == Node.VAR) {
            Node varNumber = exp.t.h;
            Integer varNumber2 = new Integer(WhileUtils.count(varNumber));
            return this.getData(varNumber2);
        }
        if (expType == Node.CONS) {
            Node exp1 = exp.t.h;
            Node exp2 = exp.t.t.h;
            Node val1 = this.computeExpression(exp1);
            Node val2 = this.computeExpression(exp2);
            Node aNode = new Node(val1, val2);
            return aNode;
        }
        if (expType == Node.TL) {
            Node exp1 = exp.t.h;
            Node val1 = this.computeExpression(exp1);
            if (val1 == Node.NIL) {
                return Node.NIL;
            }
            return val1.t;
        }
        if (expType == Node.HD) {
            Node exp1 = exp.t.h;
            Node val1 = this.computeExpression(exp1);
            if (val1 == Node.NIL) {
                return Node.NIL;
            }
            return val1.h;
        }
        if (expType == Node.QUOTE) {
            Node exp1 = exp.t.h;
            return exp1;
        }
        throw new Exception("Illegal Expression Type " + expType);
    }

    public static void main(String[] args) throws Exception {
    }
}

