/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import whilepack.SysLog;
import whilepack.cid.DebugMediator;
import whilepack.cid.Node;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileTest;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.CaseCommand;
import whilepack.cid.commands.CaseCommandEntry;
import whilepack.cid.commands.Command;
import whilepack.cid.commands.IFCommand;
import whilepack.cid.commands.WhileCommand;
import whilepack.cid.debugger.WatchVariableListener;

public class WhileDebugger {
    private String m_invar = null;
    private String m_outvar = null;
    private HashMap m_data = new HashMap();
    private boolean breakExecution = false;
    private DebugMediator debugMediator;
    private boolean isWaitingEachStep = false;
    private List listeners = new ArrayList();

    public WhileDebugger(DebugMediator debugMediator) {
        this.debugMediator = debugMediator;
    }

    private Node getData(String var) {
        if (!this.m_data.containsKey(var)) {
            this.m_data.put(var, Node.NIL);
            this.fireVariableAdded(var, Node.NIL);
        }
        return (Node)this.m_data.get(var);
    }

    private void setData(String var, Node value) {
        if (!this.m_data.containsKey(var)) {
            this.fireVariableAdded(var, value);
        } else {
            this.fireVariableUpdated(var, value);
        }
        this.m_data.put(var, value);
    }

    private void setData(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            this.setData(o.toString(), (Node)map.get(o));
        }
    }

    public void breakInterpretation() {
        this.breakExecution = true;
    }

    public boolean wasInterpretationCanceled() {
        return this.breakExecution;
    }

    public void interpret(ArrayList commands, Node d) throws Exception {
        int invarLine = Integer.parseInt(commands.remove(0).toString());
        if (this.checkWait(invarLine)) {
            return;
        }
        this.m_invar = commands.remove(0).toString();
        this.m_outvar = commands.remove(commands.size() - 1).toString();
        int outVarLine = Integer.parseInt(commands.remove(commands.size() - 1).toString());
        this.setData(this.m_invar, d);
        this.executeCommands(commands);
        if (this.breakExecution) {
            return;
        }
        this.checkWait(outVarLine);
    }

    public Node getResult() {
        Node y = this.getData(this.m_outvar);
        return y;
    }

    private void executeCommands(ArrayList commands) throws Error, Exception {
        for (int i = 0; i < commands.size(); ++i) {
            Command command = (Command)commands.get(i);
            this.executeCommand(command);
            if (!this.breakExecution) continue;
            return;
        }
    }

    private void executeCommand(Command command) throws Error, Exception {
        block10: {
            block13: {
                block12: {
                    block11: {
                        int line = command.line;
                        if (this.checkWait(line)) {
                            return;
                        }
                        if (!(command instanceof AssignCommand)) break block11;
                        AssignCommand assign = (AssignCommand)command;
                        if (assign.isInvokeCommand()) {
                            Node expression = this.invokeProgram(assign.invoke);
                            this.setData(assign.var, expression);
                        } else {
                            SysLog.out.println(">>> " + assign.exp);
                            Node expression = this.buildExpression(assign.exp);
                            expression = this.computeExpression(expression);
                            this.setData(assign.var, expression);
                        }
                        break block10;
                    }
                    if (!(command instanceof WhileCommand)) break block12;
                    WhileCommand o = (WhileCommand)command;
                    Node exp = this.buildExpression(o.exp);
                    Node result = this.computeExpression(exp);
                    int loop = 0;
                    while (result != Node.NIL) {
                        SysLog.out.println(loop++);
                        if (this.breakExecution) {
                            return;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception sExp) {
                            // empty catch block
                        }
                        this.executeCommands(o.commands);
                        result = this.computeExpression(exp);
                    }
                    break block10;
                }
                if (!(command instanceof IFCommand)) break block13;
                IFCommand ifCommand = (IFCommand)command;
                Node exp = this.buildExpression(ifCommand.exp);
                Node result = this.computeExpression(exp);
                if (result != Node.NIL) {
                    this.executeCommands(ifCommand.thenCommands);
                } else {
                    this.executeCommands(ifCommand.elseCommands);
                }
                break block10;
            }
            if (!(command instanceof CaseCommand)) break block10;
            CaseCommand caseCommand = (CaseCommand)command;
            Node exp = this.buildExpression(caseCommand.exp);
            Node result = this.computeExpression(exp);
            CaseCommandEntry[] entries = caseCommand.entries;
            for (int i = 0; i < entries.length; ++i) {
                CaseCommandEntry entry = entries[i];
                if (!entry.matches(result)) continue;
                Map map = entry.getCaseVariables(result);
                this.setData(map);
                this.executeCommands(entry.commands);
                break;
            }
        }
    }

    private boolean checkWait(int line) {
        if (this.isWaitingEachStep() || this.debugMediator.isBreakPoint(line)) {
            this.debugMediator.waitOnLine(line);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.breakExecution;
    }

    private Node invokeProgram(AssignCommand.InvokeInfo invoke) throws Exception {
        String program = WhileUtils.readFile(invoke.file);
        Node expression = this.buildExpression(invoke.data);
        expression = this.computeExpression(expression);
        WhileTest x = new WhileTest(program, expression);
        return x.getResult();
    }

    private Node buildExpression(String x) throws Exception {
        if (x.indexOf("(") == -1) {
            return Node.createCaseNode(x);
        }
        return WhileUtils.buildCaseTree(x);
    }

    private Node computeExpression(Node exp) throws Error, Exception {
        if (this.breakExecution) {
            return Node.NIL;
        }
        if (exp.isCaseNode()) {
            return this.getData(exp.concreteName());
        }
        Node expType = exp.h;
        if (expType == Node.VAR) {
            Node varNumber = exp.t.h;
            Integer varNumber2 = new Integer(WhileUtils.count(varNumber));
            return this.getData("(var " + varNumber2 + ")");
        }
        if (expType == Node.CONS) {
            Node exp1 = exp.t.h;
            Node exp2 = exp.t.t.h;
            Node val1 = this.computeExpression(exp1);
            Node val2 = this.computeExpression(exp2);
            Node aNode = new Node(val1, val2);
            return aNode;
        }
        if (expType == Node.TL) {
            Node exp1 = exp.t.h;
            Node val1 = this.computeExpression(exp1);
            if (val1 == Node.NIL) {
                return Node.NIL;
            }
            return val1.t;
        }
        if (expType == Node.HD) {
            Node exp1 = exp.t.h;
            Node val1 = this.computeExpression(exp1);
            if (val1 == Node.NIL) {
                return Node.NIL;
            }
            return val1.h;
        }
        if (expType == Node.QUOTE) {
            Node exp1 = exp.t.h;
            return exp1;
        }
        throw new Exception("Illegal Expression Type " + expType);
    }

    public boolean isWaitingEachStep() {
        return this.isWaitingEachStep;
    }

    public void setWaitingEachStep(boolean waitingEachStep) {
        this.isWaitingEachStep = waitingEachStep;
    }

    public void addWatchVariableListener(WatchVariableListener l) {
        this.listeners.add(l);
    }

    private void fireVariableAdded(String name, Node value) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WatchVariableListener watchVariableListener = (WatchVariableListener)iterator.next();
            watchVariableListener.variableAdded(name, value);
        }
    }

    private void fireVariableUpdated(String name, Node newValue) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WatchVariableListener watchVariableListener = (WatchVariableListener)iterator.next();
            watchVariableListener.variableUpdated(name, newValue);
        }
    }

    public static void main(String[] args) throws Exception {
        WhileCompiler3 x = new WhileCompiler3(new File("build/Study/564.while"));
        x.setBaseDirectory(new File("build/"));
        x.setCompilerForDebug(true);
        x.compile();
        WhileDebugger deb = new WhileDebugger(new DebugMediator(){

            public boolean isBreakPoint(int line) {
                return false;
            }

            public void waitOnLine(int line) {
            }
        });
        Node node = WhileUtils.buildOnlyNils("( ((nil.nil).(nil.nil)).nil)");
        deb.interpret(x.getDebuggerCommands(), node);
        Node result = deb.getResult();
        SysLog.out.println(WhileUtils.toList(result));
    }
}

