/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import whilepack.SysLog;
import whilepack.cid.CompileWarning;
import whilepack.cid.IWhileCompiler;
import whilepack.cid.Node;
import whilepack.cid.WCCException;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.IFCommand;
import whilepack.cid.commands.WhileCommand;

public class WhileConcreteCompiler2
implements IWhileCompiler {
    private ArrayList debugCommands = null;
    private boolean debug = false;
    private BufferedReader in;
    private String originalSource = "";
    private String m_abstract = "";
    Node p;
    private int line = 1;
    private int pos = 1;
    private int lastVarLine = -1;
    private StringTokenizer tok;
    private int id = 0;
    String[] indents = null;

    public WhileConcreteCompiler2(File file) throws WCCException {
        try {
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            WCCException exp = new WCCException("Cannot initilize compiler", e);
            exp.line = 0;
            exp.col = 0;
            throw exp;
        }
    }

    public WhileConcreteCompiler2(String code) throws WCCException {
        this.in = new BufferedReader(new StringReader(code));
    }

    private boolean waitForNewLine() {
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            if (!token.equals("\n")) continue;
            return true;
        }
        return false;
    }

    private String waitForText(String text) throws WCCException {
        int startLine = this.line;
        int startPos = this.pos;
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            this.pos += token.length();
            if (token.equals("/")) {
                boolean notEOF = this.waitForNewLine();
                if (!notEOF) break;
                this.pos = 1;
                ++this.line;
                continue;
            }
            if (token.equals(text)) {
                return text;
            }
            if (token.equals(" ")) continue;
            if (token.equals("\n")) {
                this.pos = 1;
                ++this.line;
                continue;
            }
            throw new WCCException("'" + text + "'" + " expected ", this.line, this.pos - token.length());
        }
        throw new WCCException("'" + text + "'" + " expected (EOF)", startLine, startPos);
    }

    private String waitForClose() throws WCCException {
        String t = "";
        int open = 1;
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            this.pos += token.length();
            if (token.equals("/")) {
                boolean notEOF = this.waitForNewLine();
                if (!notEOF) break;
                this.pos = 1;
                ++this.line;
                continue;
            }
            if (token.equals(")")) {
                if (--open == 0) {
                    return t;
                }
                t = t + token;
                continue;
            }
            if (token.equals("(")) {
                t = t + token;
                ++open;
                continue;
            }
            if (token.equals(" ")) {
                t = t + token;
                continue;
            }
            if (token.equals("\n")) {
                t = t + " ";
                this.pos = 1;
                ++this.line;
                continue;
            }
            t = t + token;
        }
        throw new WCCException("List doesnt end well ", this.line, this.pos);
    }

    private int waitForVar() throws WCCException {
        this.waitForText("(");
        this.lastVarLine = this.line;
        this.waitForText("var");
        return this.getVarIndexFromString();
    }

    private int getVarIndexFromString() throws WCCException {
        int index = -1;
        int startLine = this.line;
        int startPos = this.pos;
        String indexAsString = this.waitForClose().trim();
        try {
            Node indexAsNode = WhileUtils.buildProgramTree(indexAsString);
            int indexAsInt = WhileConcreteCompiler2.toInt(indexAsNode);
            if (indexAsInt == -1) {
                throw new Exception();
            }
            index = indexAsInt;
        }
        catch (Exception exp) {
            if (WhileUtils.toNode(indexAsString) == Node.NIL) {
                index = 0;
            }
            if (WhileConcreteCompiler2.isNumber(indexAsString)) {
                index = Integer.parseInt(indexAsString);
            }
            throw new WCCException("Cannot retrieve var index", startLine, startPos);
        }
        return index;
    }

    private String waitForCommand() throws WCCException {
        int startLine = this.line;
        int startPos = this.pos;
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            this.pos += token.length();
            if (token.equals("/")) {
                boolean notEOF = this.waitForNewLine();
                if (!notEOF) break;
                this.pos = 1;
                ++this.line;
                continue;
            }
            if (token.equals(";") || token.equals(":=") || token.equals("if") || token.equals("while")) {
                return token;
            }
            if (token.equals(" ")) continue;
            if (token.equals("\n")) {
                this.pos = 1;
                ++this.line;
                continue;
            }
            throw new WCCException("Command expected", startLine, startPos);
        }
        throw new WCCException("Command expected ", startLine, startPos);
    }

    private String waitForExpression() throws WCCException {
        int startLine = this.line;
        int startPos = this.pos;
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            this.pos += token.length();
            if (token.equals("/")) {
                boolean notEOF = this.waitForNewLine();
                if (!notEOF) break;
                this.pos = 1;
                ++this.line;
                continue;
            }
            if (token.equals("hd") || token.equals("tl") || token.equals("var") || token.equals("cons") || token.equals("quote")) {
                return token;
            }
            if (token.equals(" ")) continue;
            if (token.equals("\n")) {
                this.pos = 1;
                ++this.line;
                continue;
            }
            throw new WCCException("Expression expected", startLine, startPos);
        }
        throw new WCCException("Expression expected", startLine, startPos);
    }

    public void compile() throws WCCException, Exception {
        this.originalSource = "";
        String aLine = null;
        while ((aLine = this.in.readLine()) != null) {
            aLine = aLine.replace('\t', ' ');
            this.originalSource = this.originalSource + aLine + "\n";
        }
        this.tok = new StringTokenizer(this.originalSource, " '(.)/\n", true);
        this.id = 4;
        this.debugCommands = new ArrayList();
        this.waitForText("(");
        int inVar = this.waitForVar();
        int inVarLine = this.lastVarLine;
        String code = this.procCommand(this.debugCommands);
        int outVar = this.waitForVar();
        int outVarLine = this.lastVarLine;
        this.waitForText(")");
        while (this.tok.hasMoreTokens()) {
            String token = this.tok.nextToken();
            if (token.equals("\n") || token.equals(" ")) continue;
            throw new WCCException("EOF Expected", this.line, this.pos);
        }
        StringBuffer out = new StringBuffer();
        out.append("read var" + inVar).append("\n");
        out.append(code).append("\n");
        out.append("write var" + outVar);
        this.debugCommands.add(0, "(var " + inVar + ")");
        this.debugCommands.add(0, new Integer(inVarLine));
        this.debugCommands.add(new Integer(outVarLine));
        this.debugCommands.add("(var " + outVar + ")");
        this.m_abstract = out.toString();
    }

    private String procCommand(ArrayList debugCommands) throws WCCException {
        StringBuffer out = new StringBuffer();
        this.waitForText("(");
        String token = this.waitForCommand();
        int commandLine = this.line;
        if (token.equals(":=")) {
            int index = this.waitForVar();
            String exp = this.procExpression();
            this.waitForText(")");
            out.append(this.id()).append("var" + index + " := " + exp);
            debugCommands.add(new AssignCommand("(var " + index + ")", exp, commandLine));
            return out.toString();
        }
        if (token.equals("while")) {
            ArrayList doCommmands = new ArrayList();
            String exp = this.procExpression();
            this.id += 4;
            String doCommand = this.procCommand(doCommmands);
            this.id -= 4;
            debugCommands.add(new WhileCommand(exp, doCommmands, commandLine));
            this.waitForText(")");
            out.append(this.id()).append("while " + exp + " do").append("\n");
            out.append(doCommand);
            return out.toString();
        }
        if (token.equals("if")) {
            ArrayList thenCommands = new ArrayList();
            ArrayList elseCommands = new ArrayList();
            String exp = this.procExpression();
            this.id += 4;
            String thenCommand = this.procCommand(thenCommands);
            String elseCommand = this.procCommand(elseCommands);
            this.id -= 4;
            debugCommands.add(new IFCommand(exp, thenCommands, elseCommands, commandLine));
            this.waitForText(")");
            out.append(this.id()).append("if " + exp + " then").append("\n");
            out.append(thenCommand).append("\n");
            out.append(this.id()).append("else").append("\n");
            out.append(elseCommand);
            return out.toString();
        }
        if (token.equals(";")) {
            ArrayList commands1 = new ArrayList();
            ArrayList commands2 = new ArrayList();
            String command1 = this.procCommand(commands1);
            String command2 = this.procCommand(commands2);
            debugCommands.addAll(commands1);
            debugCommands.addAll(commands2);
            this.waitForText(")");
            out.append(command1).append(";\n");
            out.append(command2);
            return out.toString();
        }
        return "CMD";
    }

    private String procExpression() throws WCCException {
        this.waitForText("(");
        String token = this.waitForExpression();
        if (token.equals("var")) {
            int number = this.getVarIndexFromString();
            if (this.debug) {
                return "(var " + number + ")";
            }
            return "var" + number;
        }
        if (token.equals("quote")) {
            String quote = this.waitForClose().trim();
            if (this.debug) {
                return "(quote " + quote + ")";
            }
            return "\"" + quote + "\"";
        }
        if (token.equals("hd")) {
            String exp = this.procExpression();
            this.waitForText(")");
            if (this.debug) {
                return "(hd " + exp + ")";
            }
            return "hd " + exp;
        }
        if (token.equals("tl")) {
            String exp = this.procExpression();
            this.waitForText(")");
            if (this.debug) {
                return "(tl " + exp + ")";
            }
            return "tl " + exp;
        }
        if (token.equals("cons")) {
            String exp1 = this.procExpression();
            String exp2 = this.procExpression();
            this.waitForText(")");
            if (this.debug) {
                return "(cons " + exp1 + " " + exp2 + ")";
            }
            return "cons " + exp1 + " " + exp2;
        }
        return "--EXP--";
    }

    private static boolean isNumber(String n) {
        try {
            Integer.parseInt(n);
            return true;
        }
        catch (Exception exp) {
            return false;
        }
    }

    private static int toInt(Node num) {
        if (num == Node.NIL) {
            return 0;
        }
        int value = 1;
        while (num.t != Node.NIL) {
            if (num.h != Node.NIL) {
                return -1;
            }
            num = num.t;
            ++value;
        }
        return value;
    }

    private String id() {
        return WhileConcreteCompiler2.spaceMe(this.id);
    }

    private static String spaceMe(int n) {
        char[] value = new char[n];
        Arrays.fill(value, ' ');
        return new String(value);
    }

    public int getWarningCount() {
        return 0;
    }

    public CompileWarning[] getWarnings() {
        return null;
    }

    public String getConcreteCode() {
        return this.m_abstract;
    }

    public void setCompilerForDebug(boolean debug) {
        this.debug = debug;
    }

    public ArrayList getDebuggerCommands() {
        return this.debugCommands;
    }

    public File getOutputFile(File sourceFile) {
        String sourceFileName = sourceFile.getName();
        int index = sourceFileName.lastIndexOf(".");
        sourceFileName = index != -1 ? sourceFileName.substring(0, index) + "_decompiled.while" : sourceFileName + "_decompiled.while";
        return new File(sourceFile.getParentFile(), sourceFileName);
    }

    public static void main(String[] args) throws WCCException, Exception {
        WhileConcreteCompiler2 x = null;
        try {
            x = new WhileConcreteCompiler2(new File("Study/564.wcl"));
            x.compile();
            SysLog.out.println(x.getConcreteCode());
            PrintWriter writer = new PrintWriter(new FileOutputStream(new File("Study/564_dec.wcl")));
            writer.println(x.getConcreteCode());
            writer.close();
        }
        catch (WCCException exp) {
            SysLog.out.println("(" + exp.line + "," + exp.col + "): " + exp.getMessage());
            SysLog.out.println("\n\n");
            exp.printStackTrace();
        }
    }

    public String getOriginalSource() {
        return this.originalSource;
    }
}

