/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import whilepack.SysLog;
import whilepack.cid.CASEHandler;
import whilepack.cid.CaseHandleUtils;
import whilepack.cid.CompileWarning;
import whilepack.cid.CompileWarningEqualVariables;
import whilepack.cid.CompilerUtils;
import whilepack.cid.ExpressionUtils;
import whilepack.cid.IWhileCompiler;
import whilepack.cid.InvocationUtils;
import whilepack.cid.MyTokenizer;
import whilepack.cid.WCCException;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.CaseCommand;
import whilepack.cid.commands.CaseCommandEntry;
import whilepack.cid.commands.Command;
import whilepack.cid.commands.IFCommand;
import whilepack.cid.commands.WhileCommand;
import whilepack.general.SugarHandler;
import widex.utils.Utils;

public class WhileCompiler3
implements IWhileCompiler {
    final String FALSE = "(QUOTE NIL)";
    final String TRUE = "(QUOTE (NIL))";
    private static final String ENDS_TOO_SOON = "File ends too soon";
    private static final String SHOULD_NOT_END_WITH_SEMICOLON = "Command should not end with ';'";
    private static final String STATMENT_BEGINS_ILLEGAL_POS = "Statment begins at illegal position";
    private HashMap m_vars = new HashMap();
    private String m_concreteCode = "";
    private CompileWarning[] m_warnings;
    ExpressionUtils expressionUtils;
    private InvocationUtils invocationUtils;
    private CaseHandleUtils caseHandleUtils;
    private boolean debug = false;
    int ll = 0;
    File rootDirectory = null;
    private BufferedReader in;
    File file = null;
    private MyTokenizer tokenizer;
    private String m_inVar;
    private String m_outVar;
    private ArrayList m_debugCommands;
    private File baseDir;
    private boolean shouldCheck = false;
    private boolean lastEnded = false;
    private int lastLine = -1;
    int varIndex = 0;

    public WhileCompiler3(File file) throws WCCException {
        try {
            this.init(file.getParentFile(), new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        }
        catch (IOException exp) {
            throw new WCCException(exp);
        }
    }

    public WhileCompiler3(String code) throws WCCException {
        this.init(null, new BufferedReader(new StringReader(code)));
    }

    public WhileCompiler3(File rootDirectory, BufferedReader in) throws WCCException {
        this.init(rootDirectory, in);
    }

    private void init(File _rootDirectory, BufferedReader in) {
        this.rootDirectory = _rootDirectory;
        if (this.rootDirectory == null) {
            this.rootDirectory = new File(System.getProperty("user.dir"));
        }
        this.in = in;
    }

    private String waitForNewLine() throws WCCException {
        StringBuffer buffer = new StringBuffer();
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if (token.equals("\n")) {
                return buffer.toString();
            }
            buffer.append(token);
        }
        throw new WCCException(ENDS_TOO_SOON);
    }

    private String waitForTextNow(String text) throws WCCException {
        if (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if (token.equals(text)) {
                return text;
            }
            this.tokenizer.returnToken(token);
        }
        throw new WCCException("'" + text + "' expected", this.ll);
    }

    private int waitForIndent() throws WCCException {
        return this.waitForIndent(true, null);
    }

    private int waitForIndent(boolean allowNewLine, String errMsg) throws WCCException {
        int indent = 0;
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if (token.equals(" ")) {
                ++indent;
                continue;
            }
            if (token.equals("\t")) {
                indent += 4;
                continue;
            }
            if (token.equals("\n")) {
                if (allowNewLine) {
                    indent = 0;
                    continue;
                }
                throw new WCCException(errMsg, this.ll);
            }
            this.tokenizer.returnToken(token);
            return indent;
        }
        throw new WCCException(ENDS_TOO_SOON);
    }

    private int waitForLargerIndent(int currentIndent, String errMsg) throws WCCException {
        int indent = this.waitForIndent();
        if (indent > currentIndent) {
            return indent;
        }
        throw new WCCException(errMsg, this.ll + 1);
    }

    private String waitForNext() throws WCCException {
        if (this.tokenizer.hasMoreTokens()) {
            String next = this.tokenizer.nextToken();
            return next;
        }
        throw new WCCException(ENDS_TOO_SOON);
    }

    private String accumulateUntil(String token, boolean newLineAllowed, boolean includeToken) throws WCCException {
        StringBuffer buffer = new StringBuffer();
        while (this.tokenizer.hasMoreTokens()) {
            String next = this.tokenizer.nextToken();
            if (next.indexOf(token) != -1) {
                int pos = next.indexOf(token);
                String beforeToken = next.substring(0, pos);
                String afterToken = next.substring(pos + token.length());
                buffer.append(beforeToken);
                this.tokenizer.returnToken(afterToken);
                if (includeToken) {
                    buffer.append(token);
                }
                return buffer.toString();
            }
            if (next.equals("\n") && !newLineAllowed) {
                throw new WCCException("'" + token + "' expected", this.ll);
            }
            buffer.append(next);
        }
        throw new WCCException(ENDS_TOO_SOON);
    }

    private void waitForEOF() throws WCCException {
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if (token.equals("\n") || token.equals(" ") || token.equals("\t")) continue;
            throw new WCCException("Unexpected token at end of file", this.ll);
        }
    }

    public void compile() throws WCCException {
        String input = "";
        String line = null;
        try {
            while ((line = this.in.readLine()) != null) {
                int pos;
                if (line.indexOf("//") != -1) {
                    line = line.substring(0, line.indexOf("//"));
                }
                if ((pos = this.findNonWhiteSpace(line)) != -1) {
                    String before = line.substring(0, pos);
                    String after = line.substring(pos).replace('\t', ' ');
                    line = before + after;
                }
                input = input + line + "\n";
            }
            input = input + "\n";
        }
        catch (Exception exp) {
            throw new WCCException(exp);
        }
        this.tokenizer = new MyTokenizer(input, " \t\n", true);
        this.tokenizer.compiler = this;
        this.expressionUtils = new ExpressionUtils(this);
        this.invocationUtils = new InvocationUtils(this);
        int readInVarLine = -1;
        int writeOutVarLine = -1;
        this.ll = 0;
        int indent = this.waitForIndent();
        if (indent > 0) {
            throw new WCCException("read statement expected at column 1", this.ll);
        }
        this.waitForTextNow("read");
        this.m_inVar = this.waitForNewLine().trim();
        this.checkLegalVarName(this.m_inVar);
        this.addVar(this.m_inVar);
        if (this.debug) {
            readInVarLine = this.ll;
        }
        ArrayList body = this.compileText(0);
        if (this.shouldCheck && this.lastEnded) {
            throw new WCCException(SHOULD_NOT_END_WITH_SEMICOLON, this.lastLine);
        }
        indent = this.waitForIndent();
        if (indent > 0) {
            throw new WCCException(STATMENT_BEGINS_ILLEGAL_POS, this.ll + 1);
        }
        this.waitForTextNow("write");
        this.m_outVar = this.waitForNewLine().trim();
        this.checkLegalVarName(this.m_inVar);
        this.addVar(this.m_outVar);
        if (this.debug) {
            writeOutVarLine = this.ll;
        }
        this.waitForEOF();
        if (this.debug) {
            body.add(0, this.m_inVar);
            body.add(0, new Integer(readInVarLine));
            body.add(new Integer(writeOutVarLine));
            body.add(this.m_outVar);
            this.m_debugCommands = body;
        } else {
            this.m_concreteCode = this.formatCode(body).toLowerCase();
        }
        this.m_warnings = this.buildWarnnings();
    }

    private ArrayList compileText(int callerIndent) throws WCCException {
        return this.compileText(callerIndent, true);
    }

    private ArrayList compileText(int callerIndent, boolean lookForHigherIndent) throws WCCException {
        String line;
        ArrayList<Command> commands = new ArrayList<Command>();
        int currentIndent = lookForHigherIndent ? this.waitForLargerIndent(callerIndent, STATMENT_BEGINS_ILLEGAL_POS) : callerIndent;
        int indent = -9;
        while (true) {
            String exp;
            if ((indent = indent == -9 ? currentIndent : this.waitForIndent()) < currentIndent) {
                this.tokenizer.returnIndent(indent);
                return commands;
            }
            if (indent > currentIndent) {
                throw new WCCException(STATMENT_BEGINS_ILLEGAL_POS, this.ll + 1);
            }
            line = this.waitForNewLine().trim();
            if (this.shouldCheck && !this.lastEnded) {
                throw new WCCException("Command must end with ';'", this.lastLine);
            }
            if (line.indexOf(":=") != -1) {
                AssignCommand assign;
                if (line.endsWith(";")) {
                    line = line.substring(0, line.length() - 1);
                    this.lastEnded = true;
                    this.lastLine = this.ll;
                } else {
                    this.lastEnded = false;
                    this.lastLine = this.ll;
                }
                this.shouldCheck = true;
                int pos = line.indexOf(":=");
                String var = line.substring(0, pos).trim();
                String exp2 = line.substring(pos + 2);
                this.checkLegalVarName(var);
                if (SugarHandler.isBooleansSugarActive()) {
                    this.checkNotBoolean(var);
                }
                String assignVar = this.getVar(var);
                if (exp2.trim().startsWith("<")) {
                    try {
                        if (this.debug) {
                            assign = this.invocationUtils.handleDebugInvocation(assignVar, exp2);
                            assign.line = this.ll;
                            commands.add(assign);
                        }
                        ArrayList invocationCommands = this.invocationUtils.handleInvocation(assignVar, exp2);
                        commands.addAll(invocationCommands);
                    }
                    catch (Exception exception) {
                        throw new WCCException(exception.getMessage(), (Throwable)exception, this.ll, 0);
                    }
                }
                assign = new AssignCommand();
                assign.var = assignVar;
                assign.exp = this.expressionUtils.getExpression(exp2);
                assign.comment = line;
                assign.line = this.ll;
                commands.add(assign);
                continue;
            }
            if (line.startsWith("while ")) {
                if (!line.endsWith(" do")) {
                    throw new WCCException("'do' expected at end of line", this.ll);
                }
                String expstr = line.substring(5, line.length() - 3).trim();
                exp = this.expressionUtils.getExpression(expstr);
                WhileCommand whileCommand = new WhileCommand();
                whileCommand.line = this.ll;
                whileCommand.exp = exp;
                whileCommand.commands = this.compileText(currentIndent);
                commands.add(whileCommand);
                continue;
            }
            if (line.startsWith("if ")) {
                if (!line.endsWith(" then")) {
                    throw new WCCException("Line " + this.ll + ": 'then' expected at end of line", this.ll);
                }
                String expstr = line.substring(2, line.length() - 5).trim();
                exp = this.expressionUtils.getExpression(expstr);
                IFCommand ifCommand = new IFCommand();
                ifCommand.line = this.ll;
                ifCommand.exp = exp;
                ifCommand.thenCommands = this.compileText(currentIndent);
                boolean elseFound = this.waitForElse(currentIndent);
                if (elseFound) {
                    if (this.lastEnded) {
                        throw new WCCException(SHOULD_NOT_END_WITH_SEMICOLON, this.lastLine);
                    }
                    this.shouldCheck = false;
                    ifCommand.elseCommands = this.compileText(currentIndent);
                } else {
                    if (!SugarHandler.isElseSugarActive()) {
                        throw new WCCException("'else' expected", this.lastLine + 1);
                    }
                    this.shouldCheck = true;
                    ifCommand.elseCommands = this.getSugarElse();
                }
                commands.add(ifCommand);
                continue;
            }
            if (!line.startsWith("case ") || !SugarHandler.isCaseSugarActive()) break;
            if (!line.endsWith(" of")) {
                throw new WCCException("'of' expected at end of line", this.ll);
            }
            String expstr = line.substring(4, line.length() - 3).trim();
            exp = this.expressionUtils.getExpression(expstr);
            if (this.debug) {
                int caseLine = this.ll;
                ArrayList caseEntries = this.handleCaseStatements(exp, currentIndent);
                CaseCommand caseCommand = new CaseCommand();
                caseCommand.exp = exp;
                caseCommand.line = caseLine;
                caseCommand.entries = caseEntries.toArray(new CaseCommandEntry[0]);
                commands.add(caseCommand);
                continue;
            }
            ArrayList caseEntries = this.handleCaseStatements(exp, currentIndent);
            ArrayList caseCommand = this.caseHandleUtils.wrapCaseEntries(exp, caseEntries);
            commands.addAll(caseCommand);
        }
        throw new WCCException("Cannot resolve command from text: " + line, this.ll);
    }

    private void checkNotBoolean(String var) throws WCCException {
        if (var.equalsIgnoreCase("true") || var.equalsIgnoreCase("false")) {
            throw new WCCException("Variable expected", this.ll);
        }
    }

    private ArrayList handleCaseStatements(String exp, int callerIndent) throws WCCException {
        ArrayList<Object> caseEntries = new ArrayList<Object>();
        int currentIndent = this.waitForLargerIndent(callerIndent, STATMENT_BEGINS_ILLEGAL_POS);
        int indent = -770;
        while (true) {
            if ((indent = indent == -770 ? currentIndent : this.waitForIndent()) < currentIndent) {
                this.tokenizer.returnIndent(indent);
                return caseEntries;
            }
            if (indent > currentIndent) {
                throw new WCCException(STATMENT_BEGINS_ILLEGAL_POS, this.ll + 1);
            }
            String pattern = this.accumulateUntil("=>", false, false);
            int inLineIndent = this.waitForIndent(false, "Command expected after '=>'");
            int newCallerInentindent = indent + pattern.length() + 2 + inLineIndent;
            if (this.caseHandleUtils == null) {
                this.caseHandleUtils = new CaseHandleUtils(this);
            }
            CASEHandler caseHandler = this.caseHandleUtils.getCaseHandler();
            CASEHandler.IFCommand2 patternMatcher = caseHandler.compilePattern(pattern);
            if (this.debug) {
                CaseCommandEntry caseCommandEntry = new CaseCommandEntry();
                caseCommandEntry.pattern = pattern.trim();
                caseCommandEntry.line = this.ll;
                caseCommandEntry.commands = this.compileText(newCallerInentindent, false);
                caseEntries.add(caseCommandEntry);
                continue;
            }
            AssignCommand[] pattenVarsInits = caseHandler.getPatternAssignments();
            for (int i = 0; i < pattenVarsInits.length; ++i) {
                pattenVarsInits[i].var = this.getVar(pattenVarsInits[i].var);
            }
            ArrayList patternCommands = this.compileText(newCallerInentindent, false);
            ArrayList caseEntry = this.caseHandleUtils.joinPatternCheckAndCommands(patternMatcher, pattenVarsInits, patternCommands);
            caseEntries.add(caseEntry);
        }
    }

    public ArrayList getSugarElse() {
        return CompilerUtils.getSugarElse(this.getVar(this.m_inVar));
    }

    private CompileWarning[] buildWarnnings() {
        ArrayList<CompileWarningEqualVariables> warnings = new ArrayList<CompileWarningEqualVariables>();
        String[] vars = this.m_vars.keySet().toArray(new String[0]);
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            ArrayList<String> equalIC = new ArrayList<String>();
            for (int j = 0; j < vars.length; ++j) {
                if (i == j || vars[j] == null || !vars[i].equalsIgnoreCase(vars[j])) continue;
                equalIC.add(vars[j]);
                vars[j] = null;
            }
            if (equalIC.size() <= 0) continue;
            equalIC.add(0, vars[i]);
            String[] vs = equalIC.toArray(new String[0]);
            warnings.add(new CompileWarningEqualVariables(vs));
        }
        return warnings.toArray(new CompileWarning[0]);
    }

    public int getWarningCount() {
        return this.m_warnings.length;
    }

    public CompileWarning[] getWarnings() {
        return this.m_warnings;
    }

    private boolean waitForElse(int currentIndent) throws WCCException {
        int indent = this.waitForIndent();
        String text = this.waitForNext();
        if (indent == currentIndent && text.equals("else")) {
            ArrayList<String> tokens = new ArrayList<String>();
            while (this.tokenizer.hasMoreTokens()) {
                String token = this.tokenizer.nextToken();
                tokens.add(token);
                if (token.equals(" ")) continue;
                if (token.equals("\n")) {
                    return true;
                }
                this.tokenizer.returnTokens(tokens);
                this.tokenizer.returnToken(text);
                this.tokenizer.returnIndent(indent);
                return false;
            }
            throw new WCCException(ENDS_TOO_SOON);
        }
        this.tokenizer.returnToken(text);
        this.tokenizer.returnIndent(indent);
        return false;
    }

    private String formatCode(ArrayList body) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("(" + this.getVar(this.m_inVar));
        WhileCompiler3.convertToConcrete(body, 0, pw);
        pw.println(this.getVar(this.m_outVar) + ")");
        String code = sw.getBuffer().toString();
        int pos = code.indexOf(WhileUtils.BGN);
        SysLog.out.println(code);
        while (pos != -1) {
            int end = code.indexOf(WhileUtils.END, pos + 1) + WhileUtils.END.length();
            String wierdVarName = code.substring(pos, end);
            code = Utils.replace((String)code, (String)wierdVarName, (String)("" + this.varIndex));
            ++this.varIndex;
            pos = code.indexOf(WhileUtils.BGN);
        }
        return code;
    }

    private static void processCommand(Object o, int id, boolean m, PrintWriter pw) {
        pw.print(WhileCompiler3.spaceMe(id));
        if (m) {
            pw.print("(; ");
            id += 3;
        } else {
            pw.print("   ");
            id += 3;
        }
        if (o instanceof AssignCommand) {
            AssignCommand assign = (AssignCommand)o;
            String str = "(:= " + assign.var + " " + assign.exp + ")" + WhileCompiler3.comment(assign);
            pw.println(WhileCompiler3.spaceMe(0 * id) + str);
        } else if (o instanceof WhileCommand) {
            WhileCommand whileCommand = (WhileCommand)o;
            pw.println(WhileCompiler3.spaceMe(0 * id) + "(while " + whileCommand.exp + WhileCompiler3.comment(whileCommand));
            WhileCompiler3.convertToConcrete(whileCommand.commands, id + 4, pw);
            pw.println(WhileCompiler3.spaceMe(id) + ")");
        } else if (o instanceof IFCommand) {
            IFCommand ifCommand = (IFCommand)o;
            pw.println(WhileCompiler3.spaceMe(0 * id) + "(if " + ifCommand.exp + WhileCompiler3.comment(ifCommand));
            WhileCompiler3.convertToConcrete(ifCommand.thenCommands, id + 4, pw);
            pw.println(WhileCompiler3.spaceMe(id));
            WhileCompiler3.convertToConcrete(ifCommand.elseCommands, id + 4, pw);
            pw.println(WhileCompiler3.spaceMe(id) + ")");
        }
    }

    static void convertToConcrete(ArrayList list, int id, PrintWriter pw) {
        int i;
        if (list.size() == 1) {
            WhileCompiler3.processCommand(list.get(0), id, false, pw);
            return;
        }
        for (i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            boolean isLast = i == list.size() - 1;
            WhileCompiler3.processCommand(o, id, !isLast, pw);
        }
        pw.print(WhileCompiler3.spaceMe(id));
        for (i = 0; i < list.size() - 1; ++i) {
            pw.print(")");
        }
        pw.println();
    }

    private static String spaceMe(int n) {
        char[] value = new char[n];
        Arrays.fill(value, ' ');
        return new String(value);
    }

    private static String comment(Command command) {
        if (command.comment == null) {
            return "";
        }
        return "";
    }

    String getVar(String var) {
        if (!this.m_vars.containsKey(var = var.trim())) {
            this.addVar(var);
        }
        Integer index = (Integer)this.m_vars.get(var);
        return this.debug ? var : "(VAR " + index + ")";
    }

    private void addVar(String var) {
        if (this.m_vars.containsKey(var = var.trim())) {
            return;
        }
        this.m_vars.put(var, new Integer(this.varIndex));
        ++this.varIndex;
    }

    public boolean checkLegalVarName(String name) throws WCCException {
        if (!CompilerUtils.isLegalVarName(name)) {
            throw new WCCException("Illegal Var Name: " + name, this.ll);
        }
        return true;
    }

    public void setCompilerForDebug(boolean debug) {
        this.debug = debug;
    }

    public ArrayList getDebuggerCommands() {
        return this.m_debugCommands;
    }

    public File getOutputFile(File sourceFile) {
        String sourceFileName = sourceFile.getName();
        int index = sourceFileName.lastIndexOf(".");
        sourceFileName = index != -1 ? sourceFileName.substring(0, index) + ".wcl" : sourceFileName + ".wcl";
        return new File(sourceFile.getParentFile(), sourceFileName);
    }

    public String getConcreteCode() {
        return this.m_concreteCode;
    }

    public void setBaseDirectory(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDirectory() {
        if (this.baseDir == null) {
            this.baseDir = new File(System.getProperty("user.dir"));
        }
        return this.baseDir;
    }

    private int findNonWhiteSpace(String curLine) {
        for (int i = 0; i < curLine.length(); ++i) {
            char c = curLine.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return curLine.length();
    }

    public static void main(String[] args) throws Exception {
        try {
            WhileCompiler3 WhileCompiler32 = new WhileCompiler3(new File("Study/564.while"));
            WhileCompiler32.compile();
            PrintWriter writer = new PrintWriter(new FileOutputStream(new File("Study/564.wcl")));
            writer.println(WhileCompiler32.getConcreteCode());
            SysLog.out.println(WhileCompiler32.getConcreteCode());
            writer.close();
        }
        catch (WCCException exp) {
            SysLog.out.println("Line " + exp.line + ": " + exp.getMessage());
            exp.printStackTrace();
        }
    }
}

