/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import whilepack.SysLog;
import whilepack.cid.Node;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.IFCommand;
import whilepack.cid.commands.WhileCommand;

public class ProgramTreeToString {
    private static String toProgramList(Node root) {
        StringWriter x = new StringWriter();
        PrintWriter pw = new PrintWriter(x);
        pw.println("(" + WhileUtils.toList(root.h));
        ArrayList commandsArray = new ArrayList();
        ProgramTreeToString.processCommand(root.t.h, commandsArray);
        pw.println();
        WhileCompiler3.convertToConcrete(commandsArray, 0, pw);
        pw.println(WhileUtils.toList(root.t.t.h) + ")");
        return x.getBuffer().toString();
    }

    private static void processCommand(Node o, ArrayList commands) {
        if (o.h == Node.CONCAT) {
            ProgramTreeToString.processCommand(o.t.h, commands);
            ProgramTreeToString.processCommand(o.t.t.h, commands);
        } else if (o.h == Node.ASSIGN) {
            AssignCommand c = new AssignCommand();
            c.var = WhileUtils.toList(o.t.h);
            c.exp = WhileUtils.toList(o.t.t.h);
            commands.add(c);
        } else if (o.h == Node.WHILE) {
            WhileCommand c = new WhileCommand();
            c.exp = WhileUtils.toList(o.t.h);
            Node command = o.t.t.h;
            c.commands = new ArrayList();
            ProgramTreeToString.processCommand(command, c.commands);
            commands.add(c);
        } else if (o.h == Node.IF) {
            IFCommand c = new IFCommand();
            c.exp = WhileUtils.toList(o.t.h);
            Node thenCommand = o.t.t.h;
            Node elseCommand = o.t.t.t.h;
            c.thenCommands = new ArrayList();
            c.elseCommands = new ArrayList();
            ProgramTreeToString.processCommand(thenCommand, c.thenCommands);
            ProgramTreeToString.processCommand(elseCommand, c.elseCommands);
            commands.add(c);
        }
    }

    public static void main(String[] args) throws Exception {
        String x = "";
        x = WhileUtils.readFile(new File("Study/AddNumbers.wcl"));
        Node node = WhileUtils.buildProgramTree(x);
        SysLog.out.println(ProgramTreeToString.toProgramList(node));
    }
}

