/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

public class Node {
    private String concreteName = null;
    public Node h = null;
    public Node t = null;
    public static final Node NIL = new Node(-1, "nil");
    public static final Node VAR = new Node(4, "var");
    public static final Node CONS = new Node(5, "cons");
    public static final Node CONCAT = new Node(6, ";");
    public static final Node ASSIGN = new Node(7, ":=");
    public static final Node WHILE = new Node(8, "while");
    public static final Node IF = new Node(9, "if");
    public static final Node QUOTE = new Node(10, "quote");
    public static final Node TL = new Node(2, "tl");
    public static final Node HD = new Node(3, "hd");
    private boolean isCaseNode = false;

    public static Node unaryTree(int n) {
        Node anchor = NIL;
        for (int i = 0; i < n; ++i) {
            anchor = new Node(NIL, anchor);
        }
        return anchor;
    }

    public Node(Node h, Node t) {
        this.h = h;
        this.t = t;
    }

    private Node(int id, String concreteName) {
        this.t = NIL;
        this.h = NIL;
        this.concreteName = concreteName.trim();
        if (id != -1) {
            this.t = Node.unaryTree((int)id).t;
        }
    }

    public boolean isLeaf() {
        return this.concreteName != null;
    }

    public String concreteName() {
        return this.concreteName;
    }

    public String toString() {
        if (this.h == VAR) {
            return "<VAR " + this.t.h + ">";
        }
        return super.toString();
    }

    public static Node createCaseNode(String caseNode) {
        Node x = new Node(-1, caseNode);
        x.isCaseNode = true;
        return x;
    }

    public boolean isCaseNode() {
        return this.isCaseNode;
    }
}

