/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import whilepack.SysLog;
import whilepack.cid.CitedVarIndexNode;
import whilepack.cid.InvocationReciter;
import whilepack.cid.Node;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileConcreteCompiler2;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.IFCommand;
import whilepack.cid.commands.WhileCommand;

public class InvocationUtils {
    private WhileCompiler3 compiler;
    private int invocationReciter_UniqueID = 0;

    public InvocationUtils(WhileCompiler3 compiler) {
        this.compiler = compiler;
    }

    public ArrayList handleInvocation(String assignVar, String invc) throws Exception {
        Object[] o = this.getFileAndExpression(invc);
        File file = (File)o[0];
        String data = (String)o[1];
        ++this.invocationReciter_UniqueID;
        Node p = WhileUtils.buildProgramTree(InvocationUtils.readFile(file));
        Node inVar = p.h;
        Node body = p.t.h;
        Node outVar = p.t.t.h;
        int inVarIndex = InvocationReciter.toInt(inVar.t.h);
        int outVarIndex = InvocationReciter.toInt(outVar.t.h);
        inVar.t.h = new CitedVarIndexNode(inVarIndex, this.invocationReciter_UniqueID);
        outVar.t.h = new CitedVarIndexNode(outVarIndex, this.invocationReciter_UniqueID);
        TreeSet<Integer> varsToInit = new TreeSet<Integer>();
        varsToInit.add(new Integer(inVarIndex));
        varsToInit.add(new Integer(outVarIndex));
        InvocationReciter.embedInvokationIdInVars(varsToInit, body, this.invocationReciter_UniqueID);
        ArrayList citedProgram = new ArrayList();
        this.fillArrayListWithCommands(citedProgram, body);
        SysLog.out.println(varsToInit + " ... " + inVarIndex);
        ArrayList initilizeVarsWithNilCommandBlock = this.createInitilizeVarsCommandBlock(varsToInit, inVarIndex, data, this.invocationReciter_UniqueID);
        AssignCommand assignOutputVarToCitedVar = new AssignCommand();
        assignOutputVarToCitedVar.var = assignVar;
        assignOutputVarToCitedVar.exp = WhileUtils.toList(outVar);
        ArrayList al = new ArrayList();
        al.addAll(initilizeVarsWithNilCommandBlock);
        al.addAll(citedProgram);
        al.add(assignOutputVarToCitedVar);
        return al;
    }

    private ArrayList createInitilizeVarsCommandBlock(TreeSet vars, int inVarIndex, String data, int invokationId) {
        ArrayList<AssignCommand> initilizeVarsWithNilCommandBlock = new ArrayList<AssignCommand>();
        Iterator it = vars.iterator();
        while (it.hasNext()) {
            AssignCommand assign = new AssignCommand();
            int varIndex = (Integer)it.next();
            CitedVarIndexNode citedVarIndexNode = new CitedVarIndexNode(varIndex, invokationId);
            Node aVAR = new Node(Node.VAR, new Node(citedVarIndexNode, Node.NIL));
            assign.var = WhileUtils.toList(aVAR);
            assign.exp = inVarIndex == varIndex ? data : "(QUOTE NIL)";
            if (inVarIndex == varIndex) {
                initilizeVarsWithNilCommandBlock.add(0, assign);
                continue;
            }
            initilizeVarsWithNilCommandBlock.add(assign);
        }
        return initilizeVarsWithNilCommandBlock;
    }

    public AssignCommand handleDebugInvocation(String assignVar, String invc) throws Exception {
        Object[] o = this.getFileAndExpression(invc);
        File file = (File)o[0];
        String data = (String)o[1];
        AssignCommand x = new AssignCommand();
        x.var = assignVar;
        x.invoke = new AssignCommand.InvokeInfo();
        x.invoke.file = file;
        x.invoke.data = data;
        return x;
    }

    private static String readFile(File file) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        String code = "";
        while ((line = in.readLine()) != null) {
            code = code + line + "\n";
        }
        in.close();
        return code;
    }

    private void fillArrayListWithCommands(ArrayList commands, Node programBody) {
        if (programBody.h == Node.CONCAT) {
            this.fillArrayListWithCommands(commands, programBody.t.h);
            this.fillArrayListWithCommands(commands, programBody.t.t.h);
        }
        if (programBody.h == Node.ASSIGN) {
            AssignCommand c = new AssignCommand();
            c.var = WhileUtils.toList(programBody.t.h);
            c.exp = WhileUtils.toList(programBody.t.t.h);
            commands.add(c);
        } else if (programBody.h == Node.WHILE) {
            WhileCommand c = new WhileCommand();
            c.exp = WhileUtils.toList(programBody.t.h);
            c.commands = new ArrayList();
            this.fillArrayListWithCommands(c.commands, programBody.t.t.h);
            commands.add(c);
        } else if (programBody.h == Node.IF) {
            IFCommand c = new IFCommand();
            c.exp = WhileUtils.toList(programBody.t.h);
            c.thenCommands = new ArrayList();
            c.elseCommands = new ArrayList();
            this.fillArrayListWithCommands(c.thenCommands, programBody.t.t.h);
            this.fillArrayListWithCommands(c.elseCommands, programBody.t.t.t.h);
            commands.add(c);
        }
    }

    private Object[] getFileAndExpression(String invc) throws Exception {
        invc = invc.trim();
        int b = invc.indexOf("<");
        int e = invc.indexOf(">");
        Exception excep = new Exception("Errors in invocation statement");
        if (b == -1) {
            throw excep;
        }
        if (e == -1) {
            throw excep;
        }
        if (e == invc.length() - 1) {
            throw excep;
        }
        String fileName = invc.substring(b + 1, e).trim();
        String dataExp = invc.substring(e + 1).trim();
        File file = new File(this.compiler.rootDirectory, fileName);
        if (!file.exists()) {
            String x = "-err-";
            try {
                x = file.getCanonicalPath();
            }
            catch (Exception exp) {
                x = file.getName();
            }
            throw new Exception("Errors in invocation statement >> The file: " + x + " was not found");
        }
        String data = this.compiler.expressionUtils.getExpression(dataExp);
        try {
            WhileConcreteCompiler2 wcc = new WhileConcreteCompiler2(file);
            wcc.compile();
        }
        catch (Exception Exception2) {
            throw new Exception("Erros in invocation statement >> " + file.getName() + " is not a legal .wcl program");
        }
        return new Object[]{file, data};
    }
}

