/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import whilepack.cid.WCCException;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileUtils;
import whilepack.general.SugarHandler;

public class ExpressionUtils {
    private WhileCompiler3 compiler;

    public ExpressionUtils(WhileCompiler3 compiler) {
        this.compiler = compiler;
    }

    public String getExpression(String exp) throws WCCException {
        try {
            StringTokenizer tok = new StringTokenizer(exp, " ()'\"", true);
            String finalExp = this.getExpression(tok, false);
            if (tok.hasMoreTokens()) {
                while (tok.hasMoreTokens()) {
                    if (tok.nextToken().equals(" ")) continue;
                    throw new NoSuchElementException();
                }
            }
            return finalExp;
        }
        catch (NoSuchElementException expc) {
            throw new WCCException("Erros in expression", this.compiler.ll);
        }
    }

    private String getExpression(StringTokenizer tok, boolean parsingList) throws WCCException {
        String expType = tok.nextToken();
        while (expType.equals(" ")) {
            expType = tok.nextToken();
        }
        if (expType.equals("cons")) {
            String exp1 = this.getExpression(tok, parsingList);
            String exp2 = this.getExpression(tok, parsingList);
            return "(CONS " + exp1 + " " + exp2 + ")";
        }
        if (expType.equals("tl")) {
            String exp1 = this.getExpression(tok, parsingList);
            return "(TL " + exp1 + ")";
        }
        if (expType.equals("hd")) {
            String exp1 = this.getExpression(tok, parsingList);
            return "(HD " + exp1 + ")";
        }
        if (expType.equals("true") && SugarHandler.isBooleansSugarActive()) {
            return "(QUOTE (NIL))";
        }
        if (expType.equals("false") && SugarHandler.isBooleansSugarActive()) {
            return "(QUOTE NIL)";
        }
        if (expType.equals("'")) {
            String exp1 = this.handleCitation(tok);
            return "(QUOTE " + exp1 + ")";
        }
        if (expType.equals("\"") || expType.equals("nil")) {
            String exp1 = null;
            exp1 = expType.equals("\"") ? this.handleConstant(tok) : "NIL";
            return "(QUOTE " + exp1 + ")";
        }
        if (expType.equals("(") && SugarHandler.isListSuagrActive()) {
            expType = tok.nextToken();
            while (expType.equals(" ")) {
                expType = tok.nextToken();
            }
            if (expType.equals("list")) {
                ArrayList<String> expressions = new ArrayList<String>();
                String exp = this.getExpression(tok, true);
                while (exp != null) {
                    expressions.add(exp);
                    exp = this.getExpression(tok, true);
                }
                String result = "(QUOTE NIL)";
                for (int i = expressions.size() - 1; i >= 0; --i) {
                    String str = expressions.get(i).toString();
                    result = "(CONS " + str + " " + result + ")";
                }
                return result;
            }
            throw new WCCException("'list' keyword expected after '('", this.compiler.ll);
        }
        if (expType.equals(")") && parsingList) {
            return null;
        }
        if (this.compiler.checkLegalVarName(expType)) {
            String exp1 = this.compiler.getVar(expType);
            return exp1;
        }
        throw new WCCException("Unexpected Error (ExpressionUtils #1)", this.compiler.ll);
    }

    private String handleCitation(StringTokenizer tok) throws WCCException {
        String citation = "";
        boolean teminated = false;
        String token = tok.nextToken();
        while (true) {
            if (token.equals("'")) {
                teminated = true;
                break;
            }
            if (token.equals("\n")) break;
            citation = citation + token;
            token = tok.nextToken();
        }
        if (!teminated) {
            throw new WCCException("Citation not properly terminated", this.compiler.ll);
        }
        File file = new File(this.compiler.rootDirectory, citation.trim());
        if (!file.exists()) {
            throw new WCCException("Cannot citate >> The file: " + file + " was not found", this.compiler.ll);
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = null;
            String code = "";
            while ((line = in.readLine()) != null) {
                if (line.startsWith(" ")) {
                    line = " " + line.trim();
                } else if (line.endsWith(" ")) {
                    line = line.trim();
                }
                code = code + line + " ";
            }
            in.close();
            return code;
        }
        catch (IOException exp) {
            throw new WCCException("Cannot citate file: " + file + " (" + exp.getMessage() + ")", this.compiler.ll);
        }
    }

    private String handleConstant(StringTokenizer tok) throws WCCException {
        String constant = "";
        boolean teminated = false;
        String token = tok.nextToken();
        while (true) {
            if (token.equals("\"")) {
                teminated = true;
                break;
            }
            if (token.equals("\n")) break;
            constant = constant + token;
            token = tok.nextToken();
        }
        if (!teminated) {
            throw new WCCException("String constant not properly terminated", this.compiler.ll);
        }
        try {
            return WhileUtils.toTree2(WhileUtils.buildInputTree(constant));
        }
        catch (Exception exp) {
            throw new WCCException("Invalid constant: " + constant + " >> " + exp.getMessage(), this.compiler.ll);
        }
    }
}

