/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.util.ArrayList;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.Command;
import whilepack.general.SugarHandler;

class CompilerUtils {
    CompilerUtils() {
    }

    public static AssignCommand getAssignBoolean(String varName, boolean value) {
        AssignCommand assign = new AssignCommand();
        assign.var = varName;
        assign.exp = value ? "(QUOTE NIL)" : "(QUOTE (NIL))";
        return assign;
    }

    String comment(Command command) {
        if (command.comment == null) {
            return "";
        }
        return "";
    }

    public static boolean isLegalVarName(String _name) {
        String name = _name.trim().toUpperCase();
        if (name.matches("\\p{Alpha}[\\p{Alpha}\\p{Digit}\\_]*")) {
            boolean kw = false;
            if (name.equals("IF")) {
                kw = true;
            } else if (name.equals("THEN")) {
                kw = true;
            } else if (name.equals("ELSE")) {
                kw = true;
            } else if (name.equals("WHILE")) {
                kw = true;
            } else if (name.equals("DO")) {
                kw = true;
            } else if (name.equals("CONS")) {
                kw = true;
            } else if (name.equals("HD")) {
                kw = true;
            } else if (name.equals("TL")) {
                kw = true;
            } else if (name.equals("NIL")) {
                kw = true;
            } else if (name.equals("READ")) {
                kw = true;
            } else if (name.equals("WRITE")) {
                kw = true;
            } else if (name.equals("CASE") && SugarHandler.isCaseSugarActive()) {
                kw = true;
            } else if (name.equals("OF") && SugarHandler.isCaseSugarActive()) {
                kw = true;
            } else if (name.equals("LIST") && SugarHandler.isListSuagrActive()) {
                kw = true;
            }
            if (!kw) {
                return true;
            }
        }
        return false;
    }

    public static ArrayList getSugarElse(String var) {
        AssignCommand assign = new AssignCommand();
        assign.var = var;
        assign.exp = var;
        ArrayList<AssignCommand> x = new ArrayList<AssignCommand>();
        x.add(assign);
        return x;
    }
}

