/*
 * Decompiled with CFR 0.152.
 */
package whilepack.cid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import whilepack.SysLog;
import whilepack.cid.CompilerUtils;
import whilepack.cid.Node;
import whilepack.cid.WCCException;
import whilepack.cid.WhileUtils;
import whilepack.cid.commands.AssignCommand;
import whilepack.cid.commands.Command;
import whilepack.cid.commands.IFCommand;

public class CASEHandler {
    private AssignCommand badAssign;
    private AssignCommand goodAssign;
    private ArrayList badCommand;
    private String caseExp;
    private String caseOK;
    private Set patternSet;
    private ArrayList patternAssignments;

    public CASEHandler(String caseExp, String caseOK, String trueExp, String falseExp) {
        this.caseExp = caseExp;
        this.caseOK = caseOK;
        this.badAssign = new AssignCommand();
        this.badAssign.var = caseOK;
        this.badAssign.exp = falseExp;
        this.badCommand = new ArrayList();
        this.badCommand.add(this.badAssign);
        this.goodAssign = new AssignCommand();
        this.goodAssign.var = caseOK;
        this.goodAssign.exp = trueExp;
        this.patternAssignments = new ArrayList();
        this.patternSet = new HashSet();
    }

    private IFCommand2 compile(String pattern) throws WCCException {
        this.patternAssignments = new ArrayList();
        Node node = WhileUtils.toNode(pattern);
        if (node != null) {
            try {
                Node root = WhileUtils.buildCaseTree(pattern);
                if (root == Node.NIL) {
                    return this.buildCheck("nil", "", null);
                }
                ArrayList patternAL = WhileUtils.convertList(WhileUtils.toCaseTree(root));
                return this.buildCheck(patternAL, "", null);
            }
            catch (Exception exp) {
                throw new WCCException(exp);
            }
        }
        if (pattern.indexOf("(") == -1) {
            if (CompilerUtils.isLegalVarName(pattern)) {
                return this.buildCheck(pattern, "", null);
            }
            throw new WCCException("Illegal Pattern Variable: " + pattern);
        }
        try {
            String patternTree = WhileUtils.toCaseTree(WhileUtils.buildCaseTree(pattern));
            ArrayList patternAL = WhileUtils.convertList(patternTree);
            return this.buildCheck(patternAL, "", null);
        }
        catch (Exception exp) {
            throw new WCCException(exp);
        }
    }

    public IFCommand2 compilePattern(String pattern) throws WCCException {
        IFCommand2 x = this.compile(pattern);
        x.setNextCheck(this.goodAssign);
        return x;
    }

    private IFCommand2 buildCheck(Object object, String prefix, IFCommand2 caller) throws WCCException {
        if (object instanceof String) {
            String objName = object.toString().trim();
            if (objName.toUpperCase().equals("NIL")) {
                IFCommand2 x = new IFCommand2();
                x.exp = this.formulate(prefix, this.caseExp);
                x.thenCommands = this.badCommand;
                x.elseCommands = new ArrayList();
                return x;
            }
            if (!CompilerUtils.isLegalVarName(objName)) {
                throw new WCCException("Illegal Pattern Variable: " + objName);
            }
            if (this.patternSet.contains(objName)) {
                throw new WCCException("Duplicate declaration of Pattern Variable: " + objName);
            }
            this.patternSet.add(objName);
            this.patternAssignments.add(new AssignCommand(objName, this.formulate(prefix, this.caseExp)));
            IFCommand2 x = new IFCommand2();
            x.exp = "(QUOTE (NIL.NIL))";
            x.thenCommands = new ArrayList();
            x.elseCommands = this.badCommand;
            return x;
        }
        IFCommand2 wrap = new IFCommand2();
        ArrayList subtree = (ArrayList)object;
        IFCommand2 left = this.buildCheck(subtree.get(0), "hd " + prefix, wrap);
        IFCommand2 right = this.buildCheck(subtree.get(2), "tl " + prefix, wrap);
        left.setNextCheck(right);
        wrap.exp = this.formulate(prefix, this.caseExp);
        wrap.thenCommands = new ArrayList<Object>(Arrays.asList(left));
        wrap.elseCommands = this.badCommand;
        wrap.nextCheck = right.getNextCheck();
        return wrap;
    }

    public AssignCommand[] getPatternAssignments() {
        return this.patternAssignments.toArray(new AssignCommand[0]);
    }

    private String formulate(String exp, String var) {
        if ((exp = exp.trim().toUpperCase()).length() == 0) {
            return var;
        }
        exp = " " + exp;
        exp = exp.replaceAll(" ", " (");
        exp = exp.trim();
        int count = 0;
        int pos = exp.indexOf("(");
        while (pos != -1) {
            ++count;
            pos = exp.indexOf("(", pos + 1);
        }
        exp = exp + " " + var;
        for (int i = 0; i < count; ++i) {
            exp = exp + ")";
        }
        return exp;
    }

    private void printIT(Command check, StringBuffer sb, int indent) {
        if (check instanceof IFCommand2) {
            IFCommand2 IFCommand22 = (IFCommand2)check;
            sb.append(CASEHandler.spaceMe(indent)).append("if " + IFCommand22.exp + " then").append("\n");
            this.printIT((Command)IFCommand22.thenCommands.get(0), sb, indent + 4);
            sb.append(CASEHandler.spaceMe(indent)).append("else").append("\n");
            this.printIT((Command)IFCommand22.elseCommands.get(0), sb, indent + 4);
        } else if (check instanceof AssignCommand) {
            AssignCommand assignCommand = (AssignCommand)check;
            sb.append(CASEHandler.spaceMe(indent)).append(assignCommand.var + " := " + assignCommand.exp).append("\n");
        }
    }

    private static String spaceMe(int n) {
        char[] value = new char[n];
        Arrays.fill(value, ' ');
        return new String(value);
    }

    public static void main(String[] args) throws WCCException {
        String patternStr = "(TL.A)";
        CASEHandler ch = new CASEHandler("v", "ok", "true", "false");
        IFCommand2 check = ch.compile(patternStr);
        check.setNextCheck(ch.goodAssign);
        StringBuffer sb = new StringBuffer();
        ch.printIT(check, sb, 4);
        SysLog.out.println(sb.toString());
        AssignCommand[] ac = ch.getPatternAssignments();
        for (int i = 0; i < ac.length; i += 2) {
            SysLog.out.println(ac[i].var + " := " + ac[i].exp);
        }
    }

    static class IFCommand2
    extends IFCommand {
        ArrayList nextCheck = null;

        IFCommand2() {
        }

        public void setNextCheck(Command nextCommand) {
            if (this.nextCheck != null) {
                this.nextCheck.add(nextCommand);
            } else if (this.thenCommands.size() == 0) {
                this.thenCommands.add(nextCommand);
            } else if (this.elseCommands.size() == 0) {
                this.elseCommands.add(nextCommand);
            } else {
                throw new RuntimeException("Critical Error, Case Handler (#1)");
            }
        }

        public ArrayList getNextCheck() {
            if (this.nextCheck != null) {
                return this.nextCheck;
            }
            if (this.thenCommands.size() == 0) {
                return this.thenCommands;
            }
            if (this.elseCommands.size() == 0) {
                return this.elseCommands;
            }
            throw new RuntimeException("Critical Error, Case Handler (#2)");
        }
    }
}

