/*
 * realloc.c -- Implementation of ansi_realloc
 *
 * (C) m.b (Matthias Blume); HUB; Nov 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: realloc.c,v 2.4 1994/11/12 22:25:35 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: realloc.c,v 2.4 1994/11/12 22:25:35 blume Exp $")

# ifdef REALLOC
# undef REALLOC
# endif

# ifdef REALLOC_H_
# undef REALLOC_H_
# endif

# include "realloc.h"

/*
 * Normally ``realloc'' should behave just like ``ansi_realloc'' below.
 * However, on some systems the C library comes with a broken ``realloc'',
 * so I provide my own -- just in case...
 * Note, that ``realloc (ptr, 0)'' should work like ``free (ptr)'', but I
 * don't care, because I don't use that feature.
 */
void *ansi_realloc (void *orig, size_t s)
{
  return (orig == NULL) ? malloc (s) : realloc (orig, s);
}
