(define (varset-functor lgi-mod set-functor)

  (use lgi-mod lgi-sig)
  (use scheme-sig)

  (let ((set-mod
	 (set-functor (lambda (x) (local-id x)) <)))

    (module varset-sig ()

      (use scheme-sig)
      (use set-mod set-sig s)

      (define varset+ (s set+))
      (define varset- (s set-))
      (define varset* (s set*))
      (define varset+1 (s set+1))
      (define list->varset (s list->set))

      (define (varset++ l)
	(if (pair? l)
	    (varset+ (car l) (varset++ (cdr l)))
	    '()))

      ;; taking advantage of uniqueness of locals
      (define (varset-in? e s) (memq e s)))))
