(define (scc-functor)

  (module scc-sig ()

    (use scheme-sig)

    ;; compute strongly connected components and a topological ordering
    ;; of a directed graph
    (define (scc-top n n->oen neq?)
      ;; n is a list of nodes
      ;; for a given node v (n->oen v) gives a list endpoints of outgoing edges
      ;; (neq? x y) tests nodes x and y for equality

      ;; node membership in a list
      (define (nmem x l)
	(cond ((not (pair? l)) #f)
	      ((neq? (car l) x) l)
	      (else (nmem x (cdr l)))))

      ;; node associations
      (define (nass x l)
	(cond ((not (pair? l)) #f)
	      ((neq? (nd (car l)) x) (car l))
	      (else (nass x (cdr l)))))

      (define (a n l p) (list n l p))	; make an association
      (define (nd a) (car a))		; the node
      (define (low a) (cadr a))		; the ``low-number''
      (define (set-low! a l) (set-car! (cdr a) l))
      (define (pre a) (caddr a))	; the ``preorder-number''

      ;; the depth-first search
      (define (dfs na pa next-pre al stack sccl cont)
	;; na - node association
	;; pa - parent's node association (or #f if na refers to root)
	;; next-pre - next available preorder-number
	;; al - list of known associations (includes na and pa (if there))
	;; stack - of nodes (includes current node and parent node (if there))
	;; sccl - list of strongly connected components (so far)
	;; cont - the continuation:
	;;   takes:
	;;    * the new next-pre
	;;    * the new al
	;;    * the new stack
	;;    * the new sccl
	(let edge-loop
	    ((tnl (n->oen (nd na)))
	     (next-pre next-pre)
	     (al al)
	     (stack stack)
	     (sccl sccl))
	  (cond ((not (pair? tnl))
		 (cond ((= (low na) (pre na))
			(do ((s stack (cdr s))
			     (scc '() (cons (car s) scc)))
			    ((neq? (car s) (nd na))
			     (cont next-pre
				   al
				   (cdr s)
				   (cons (cons (car s) scc) sccl)))))
		       (else
			(if (< (low na) (low pa))
			    (set-low! pa (low na)))
			(cont next-pre al stack sccl))))
		(else
		 (let* ((tn (car tnl))
			(tna (nass tn al)))
		   (if tna
		       (begin
			 (if (and (nmem tn stack)
				  (< (low tna) (low na)))
			     (set-low! na (low tna)))
			 (edge-loop (cdr tnl) next-pre al stack sccl))
		       (let ((tna (a tn next-pre next-pre)))
			 (dfs tna na
			      (+ next-pre 1)
			      (cons tna al)
			      (cons tn stack)
			      sccl
			      (lambda (next-pre al stack sccl)
				(edge-loop (cdr tnl)
					   next-pre al stack sccl))))))))))


      (let ((na (a n 0 0)))
	(dfs na '#f 1 (list na) (list n) '()
	     (lambda (i1 i2 i3 l)
	       l))))))
