;; This is currently a hack...
;; It will be replaced by the real code generator.

(define (hack-functor lgi-mod)

  (module hack-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)

    (define hack

      (let ((mapping '()))	; locals -> symbols

	;; ``hack'' is a mini-code-generator, which translates the
	;; ee-language back into Scheme...
	(define (h exp)

	  (define (h-lambda body)
	    (list 'lambda (map h (cadr body)) (h (caddr body))))

	  (define (h-vlambda body)
	    (let ((rgs (caddr body)))
	      (define (hl l)
		(if (null? l)
		    (h rgs)
		    (cons (h (car l)) (hl (cdr l)))))
	      (list 'lambda (hl (cadr body)) (h (cadddr body)))))

	  (define (h-delay body)
	    (list 'delay (h (cadr body))))

	  (define (h-c exp f)
	    (let ((body (ee-body exp)))
	      (list 'let
		    (list (list (h (car body)) (h (cadr body))))
		    (f (cddr body)))))

	  (case (ee-type exp)
	    ((quote) (list 'quote (ee-body exp)))
	    ((global) (global-symbol exp))
	    ((integrable)
	     (let ((s (integrable-symbol exp)))
	       (cond ((pair? s)
		      (do ((l s (cdr l))
			   (e 'x (list (car l) e)))
			  ((null? l) (list 'lambda '(x) e))))
		     ((assq s '((ref . list) (deref . car)
					     (assign . set-car!)))
		      => cdr)
		     (else s))))
	    ((local)
	     (cond ((assq exp mapping) => cdr)
		   (else
		    (let ((n (string->symbol
			      (string-append
			       "#:" (symbol->string (local-symbol exp))
			       "%" (number->string (local-id exp))))))
		      (set! mapping (cons (cons exp n) mapping))
		      n))))
	    ((set! if)
	     (cons (ee-type exp) (map h (ee-body exp))))
	    ((app) (map h (ee-body exp)))
	    ((letrec let)
	     (list (ee-type exp)
		   (map (lambda (b) (map h b)) (car (ee-body exp)))
		   (h (cadr (ee-body exp)))))
	    ((lambda) (h-lambda (ee-body exp)))
	    ((clambda) (h-c exp h-lambda))
	    ((vlambda) (h-vlambda (ee-body exp)))
	    ((cvlambda) (h-c exp h-vlambda))
	    ((delay) (h-delay (ee-body exp)))
	    ((cdelay) (h-c exp h-delay))
	    ((label)
	     (let ((body (ee-body exp)))
	       (list 'let
		     (string->symbol (string-append
				      "#lab%"
				      (number->string (car body))))
		     (map (lambda (b)
			    (list (h (car b)) (h (cadr b))))
			  (cadr body))
		     (h (caddr body)))))
	    ((goto)
	     (let ((body (ee-body exp)))
	       (cons (string->symbol
		      (string-append "#lab%"
				     (number->string (car body))))
		     (map h (cdr body)))))
	    ((wrap) (h (ee-body exp)))
	    ((definitions) (error "hack: ill-placed definitions"))
	    ((transformer) (error "hack: ill-placed transformer"))
	    (else
	     (display "UNRECOGNIZED: ") (write (ee-type exp)) (newline)
	     (error "hack: unrecognized construct"))))

	(lambda (exp)
	  (let ((r (h exp)))
	    (set! mapping '())
	    r))))))
