/*
 * Symbol.h -- Declarations for Scheme Symbols
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Symbol.h,v 2.8 1994/11/12 03:56:06 blume Exp $
 */

# ifndef SYMBOL_H_
# define SYMBOL_H_

# include "storage.h"

typedef
struct ScmSymbol {
  MEM_descriptor _;
  struct ScmSymbol *hashlink;
  void *value;			/* in global environment */
  short strong;			/* for GC */
  unsigned short primno_succ;	/* 0: not a primitive, other: prim_no + 1 */
  unsigned short length;
  char array[1];
} ScmSymbol;

DCL_MEM_TYPE (Symbol);

extern
void *ScmMakeSymbol (const char *name, unsigned length);

extern void ScmInitSymtab (void);

# endif
