/*
 * Code.h -- Declarations for Scheme Bytecode
 *
 * (C) m.b (Matthias Blume); Apr 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Code.h,v 2.6 1994/11/09 02:11:44 blume Exp $
 */

# ifndef CODE_H_
# define CODE_H_

# include "storage.h"
# include "Vector.h"

# include "noreturn.h"

typedef
struct ScmCode {
  MEM_descriptor _;
  unsigned arg_cnt;
  unsigned take_rest;
  void *argument_names;
  ScmVector *constants;
  void *proc_name;
  unsigned stack_requirement;
  unsigned length;
  unsigned short array[1];
} ScmCode;

DCL_MEM_TYPE (Code);

extern unsigned long ScmListLength (void *);
extern void *ScmReverseList (void *);
extern void *ScmReverseIP2 (void *, void *);
extern void ScmListToVector (void);

extern void *ScmAsmToCode (void *);
extern void *ScmCodeToProcedure (void *);
extern void *ScmAsmToProcedure (void *);

extern void ScmPrepareProcedureCall (void *proc, unsigned argcnt);
extern void NORETURN ScmVM (void) NRUTERON;
extern void ScmPushPrimitiveContinuation (void *env, unsigned stckrq);

extern void ScmRegisterInterrupt (unsigned cont_num, void *vect);
extern void ScmRegisterAsynInterrupt (void);
extern void ScmInstantInterruptHandling (int state);

/*
 * given a pointer to a ScmCode object (code) and a program counter (pc)
 * retrieve the string opcode (opcode), the instruction length (length)
 * which is the same as 1+#operands if possible the operands (op1,op2,op3)
 * return the ``new'' pc (pc + *length),
 *  -1 if pc is out of range,
 *  -2 if operation cannot be decoded
 */
extern
long ScmDisassemble
  (ScmCode *code, unsigned long pc, const char **opcode, int *length,
   unsigned short *op1, unsigned short *op2, unsigned short *op3);


/*
 * ScmTimer ALWAYS returns the number of units left in the timer (old value)
 * units == 0  -> disable
 * units == -1 -> no change
 * units >  0  -> set
 * The timer is automatically disabled after it expires.
 */
extern
long ScmTimer (long units);

# endif
