/*
 * strerr.c -- Implementation of ANSI C strerror (for brain-dead systems
 *             which don't have their own)
 *
 * (C) m.b (Matthias Blume); HUB; Nov 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: strerr.c,v 2.4 1994/11/12 22:25:15 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: strerr.c,v 2.4 1994/11/12 22:25:15 blume Exp $")

# ifdef sun

# include <string.h>

extern char *sys_errlist [];

char *strerror (int n)
{
  return sys_errlist [n];
}

# else

# include <stdio.h>
# include <string.h>

char *strerror (int num)
{
  static char buf [1024];

  sprintf
    (buf,
     "Error code %d\n"
     "[What you see here is a substitute for strerror at work.\n"
     " Complain to your system administration if you want the real thing!]",
     num);
  return buf;
}

# endif
