/*
 * posix.c -- Implementation of Scheme posix primitives
 *
 * (C) m.b (Matthias Blume); Oct 1994 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: posix.c,v 1.4 1997/05/24 18:42:57 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: posix.c,v 1.4 1997/05/24 18:42:57 blume Exp $")

# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include <errno.h>
# include <sys/types.h>
# include <dirent.h>
# include <unistd.h>
# include <limits.h>

# include "Boolean.h"
# include "String.h"
# include "Cons.h"
# include "Cont.h"
# include "type.h"
# include "except.h"
# include "tmpstring.h"

# include "builtins.tab"

static ScmString *scm_string (const char *s)
{
  int l;
  ScmString *string;

  l = strlen (s);
  SCM_VNEW (string, String, l, char);
  string->length = l;
  memcpy (string->array, s, l);
  return string;
}

static char *C_string_of (void *x, const char *fname)
{
  ScmString *string;
  if (ScmTypeOf (x) != ScmType (String))
    badarg (fname, x);
  string = x;
  return tmpstring (string->array, string->length);
}

# define problem(fun,file) error ("%s: %s (%s)", fun, file, strerror (errno))

/*ARGSUSED*/
unsigned ScmPrimitivePosixReadDir (unsigned argcnt)
{
  DIR *dir;
  char *name = C_string_of (PEEK (), "read-directory");
  ScmString *string;
  ScmCons *cons;
  struct dirent *de;

  errno = 0;

  if ((dir = opendir (name)) == NULL)
    problem ("read-dir", name);

  SET_TOP (&ScmNil);

  while ((de = readdir (dir)) != NULL) {
    size_t len = strlen (de->d_name);
    SCM_VNEW (string, String, len, char);
    string->length = len;
    memcpy (string->array, de->d_name, len);
    Push (string);
    SCM_NEW (cons, Cons);
    cons->car = POP ();
    cons->cdr = PEEK ();
    SET_TOP (cons);
  }

  (void) closedir (dir);

  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitivePosixChangeDir (unsigned argcnt)
{
  char *name = C_string_of (PEEK (), "change-dir");
  errno = 0;
  if (chdir (name) < 0)
    problem ("change-dir", name);
  else
    SET_TOP (&ScmFalse);
  return 0;
}

# ifndef PATH_MAX
# ifdef MAXNAMLEN
# define PATH_MAX MAXNAMLEN
# else
# define PATH_MAX 256
# endif
# endif

/*ARGSUSED*/
unsigned ScmPrimitivePosixGetWorkingDir (unsigned argcnt)
{
  char buf [PATH_MAX + 1];

  if (getwd (buf) == NULL)
    error ("get-working-dir failed: %s", buf);
  Push (&ScmNil);
  SET_TOP (scm_string (buf));
  return 0;
}
