(define (optutil-functor error-mod)

  (module optutil-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use error-mod error-sig)

    ;; function to apply given function to expression in letrec binding
    (define (bindgen f)
      (lambda (b) (list (car b) (f (cadr b)))))

    (define (bindapp f)
      (lambda (b) (f (cadr b))))

    ;; generic expression traversal
    (define (generic f exp)

      (let ((type (ee-type exp))
	    (body (ee-body exp)))
	(case type
	  ((quote global local integrable) exp)
	  ((set!)
	   (ee 'set! (list (car body) (f (cadr body)))))
	  ((if app)
	   (ee type (map f body)))
	  ((letrec let)
	   (ee type
	       (list (map (bindgen f) (car body)) (f (cadr body)))))
	  ((lambda)
	   (info-ee
	    'lambda
	    (ee-info exp)
	    (list (car body) (cadr body) (f (caddr body)))))
	  ((vlambda)
	   (info-ee
	    'vlambda
	    (ee-info exp)
	    (list (car body) (cadr body) (caddr body) (f (cadddr body)))))
	  ((delay)
	   (ee 'delay (list (car body) (f (cadr body)))))
	  ((goto)
	   (ee type (cons (car body) (map f (cdr body)))))
	  ((label)
	   (ee 'label
	       (list (car body)
		     (map (bindgen f) (cadr body))
		     (f (caddr body)))))
	  (else
	   (bug "optutil: funny expression type")))))

    ;; generic expression walk
    (define (walk f exp)

      (let ((body (ee-body exp)))
	(case (ee-type exp)
	  ((quote global local integrable) exp)
	  ((set!) (f (cadr body)))
	  ((if app) (for-each f body))
	  ((letrec let)
	   (for-each (bindapp f) (car body))
	   (f (cadr body)))
	  ((lambda) (f (caddr body)))
	  ((vlambda) (f (cadddr body)))
	  ((delay) (f (cadr body)))
	  ((goto) (for-each f (cdr body)))
	  ((label)
	   (for-each (bindapp f) (cadr body))
	   (f (caddr body)))
	  (else
	   (error "impossible: optimize: funny expression type")))))

    ;; visit local variables
    (define (visit-locals exp f)
      (define (visit exp)
	(case (ee-type exp)
	  ((lambda)
	   (for-each f (cadr (ee-body exp))))
	  ((vlambda)
	   (let ((b (ee-body exp)))
	     (for-each f (cadr b))
	     (f (caddr b))))
	  ((letrec let)
	   (for-each (lambda (b) (f (car b))) (car (ee-body exp))))
	  ((label)
	   (for-each (lambda (b) (f (car b))) (cadr (ee-body exp)))))
	(walk visit exp))
      (visit exp))))
