(define (names-functor)

  (module names-sig ()

    (use scheme-sig)

    (define generate-tag (list 'generated)) ; unique -- cannot be ``faked''

    (define (generate name uid)
      (cons generate-tag (cons name uid)))

    (define (generated? name)
      (and (pair? name)
	   (eq? (car name) generate-tag)))

    (define (name? name)
      (or (symbol? name) (generated? name)))

    (define (generated-name name)
      (cadr name))

    (define (generated-uid name)
      (cddr name))

    (define last-uid 0)

    (define (generate-unique-uid)
      (set! last-uid (+ last-uid 1))
      last-uid)

    (define (reset-uid!)
      (set! last-uid 0))

    (define (unwrap-name name)
      (if (generated? name)
	  (unwrap-name (generated-name name))
	  name))

    ;; generate a name that has the same uid's attached like another given
    ;; name (useful for introducing implicit - i.e. non-hygienic - bindings)
    (define (implicit-name tmpl)	; curried
      (lambda (n)
	(define (recur t)
	  (if (symbol? t)
	      (unwrap-name n)
	      (generate (recur (generated-name t)) (generated-uid t))))
	(recur tmpl)))

    ;; traverse expression
    (define (traversal handle-name)
      
      (define (traverse exp)
	(cond ((name? exp) (handle-name exp))
	      ((pair? exp)
	       (cons (traverse (car exp))
		     (traverse (cdr exp))))
	      ((vector? exp)
	       (list->vector (map traverse (vector->list exp))))
	      (else exp)))

      traverse)

    (define remove-wrappers
      (traversal unwrap-name))

    (define (symbolize-name name)
      (define (loop name l)
	(if (generated? name)
	    (loop (generated-name name)
		  (cons (string-append
			 ":" (number->string (generated-uid name)))
			l))
	    (string->symbol
	     (apply string-append
		    "#%"
		    (symbol->string name)
		    l))))
      (loop name '()))

    (define consume-wrappers
      (traversal symbolize-name))))
