(define (foldint-functor error-mod lgi-mod aux-mod)

  (module foldint-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)
    (use aux-mod aux-sig)
    (use error-mod error-sig)

    (define (fold-integrable op args o-op click! make-new-local)
      (let ((len (length args)))
      
	(define (require >= l)
	  (if (not (>= len l))
	      ((semantic-error (symbol->string op))
	       "wrong number of arguments:" len)))

	;; unroll sequence (same as in macro expander)
	(define (unroll-sequence l)
	  (define (loop cur rest)
	    (if (pair? rest)
		(ee 'letrec
		    (list (list (list (make-new-local 'fold-int) cur))
			  (loop (car rest) (cdr rest))))
		cur))

	  (loop (car l) (cdr l)))

	(define (onearg f type?)
	  (require = 1)
	  (let ((x (car args)))
	    (cond ((not (eq? (ee-type x) 'quote))
		   (ee 'app (cons o-op args)))
		  ((not (type? (ee-body x)))
		   ((semantic-error (symbol->string op))
		    "constant argument is not of correct type:" (ee-body x)))
		  (else
		   (click! "onearg")
		   (ee 'quote (f (ee-body x)))))))

	(define (valcmp f)
	  (require = 2)
	  (let ((x (car args))
		(y (cadr args)))
	    (if (not (and (eq? (ee-type x) 'quote)
			  (eq? (ee-type y) 'quote)))
		(ee 'app (cons o-op args))
		(begin
		  (click! "valcmp")
		  (ee 'quote (f (ee-body x) (ee-body y)))))))

	(define (arith-cmp <)

	  (define (uniq l)
	    (define (loop l r)
	      (cond ((not (pair? l)) r)
		    ((let ((x (car l))
			   (y (car r)))
		       (and (eq? (ee-type x) 'quote)
			    (eq? (ee-type y) 'quote)
			    (= (ee-body x) (ee-body y))))
		     (loop (cdr l) r))
		    (else (loop (cdr l) (cons (car l) r)))))
	    (if (pair? l)
		(loop (cdr l) (list (car l)))
		'()))

	  (require > 1)
	  (let loop
	      ((l (cdr args))
	       (prev (car args))
	       (to-check (if (eq? (ee-type (car args)) 'quote)
			     '()
			     (list (car args)))))
	    (cond ((not (pair? l))
		   (let ((tc (uniq to-check)))
		     (cond ((null? tc) (click! "arith-cmp #t") (ee 'quote #t))
			   ((null? (cdr tc))
			    (bug "fold-arith-cmp"))
			   (else
			    (ee 'app (cons o-op tc))))))
		  ((eq? (ee-type (car l)) 'quote)
		   (let ((x (ee-body (car l))))
		     (if (not (real? x))
			 ((semantic-error (symbol->string op))
			  "bad argument:" x))
		     (if (eq? (ee-type prev) 'quote)
			 (if (not (< (ee-body prev) x))
			     (begin
			       (click! "arith-cmp #f")
			       (unroll-sequence
				(append args (list (ee 'quote #f)))))
			     (loop (cdr l) (car l) to-check))
			 (loop (cdr l)
			       (car l)
			       (cons (car l) to-check)))))
		  ((eq? (ee-type prev) 'quote)
		   (loop (cdr l)
			 (car l)
			 (cons (car l) (cons prev to-check))))
		  (else
		   (loop (cdr l)
			 (car l)
			 (cons (car l) to-check))))))

	(define (nonum x)
	  ((semantic-error (symbol->string op))
	   "non-numeric arg:" x))

	(define (arith args *+ k)
	  (split args
		 (lambda (x)
		   (eq? (ee-type x) 'quote))
		 (lambda (c nc)
		   (let ((v (map (lambda (x) (ee-body x)) c)))
		     (for-each
		      (lambda (x)
			(if (not (number? x))
			    (nonum x)))
		      v)
		     (k (apply *+ v) nc)))))

	(define (dontcare x) #t)

	(case op
	  ((car) (onearg car pair?))
	  ((cdr) (onearg cdr pair?))
	  ((not)
	   (require = 1)
	   (let ((x (car args)))

	     (define (notnot)
	       (and (eq? (ee-type x) 'app)
		    (let ((bx (ee-body x)))
		      (and (= (length bx) 2)
			   (integrable? (car bx))
			   (eq? (ee-body (car bx)) 'not)
			   (cadr bx)))))

	     (cond ((notnot))
		   ((not (eq? (ee-type x) 'quote))
		    (ee 'app (cons o-op args)))
		   (else
		    (click! "not")
		    (ee 'quote (not (ee-body x)))))))
	  ((+)
	   (arith args +
		  (lambda (c l)
		    (cond ((null? l)
			   (ee 'quote c))
			  ((and (zero? c) (exact? c))
			   (if (null? (cdr l))
			       (car l)
			       (ee 'app (cons o-op l))))
			  (else
			   (ee 'app (cons o-op (cons (ee 'quote c) l))))))))
	  ((-)
	   (require > 0)
	   (if (not (pair? (cdr args)))
	       (onearg - number?)
	       (arith (cdr args) +
		      (lambda (c l)
			(if (eq? (ee-type (car args)) 'quote)
			    (let ((x (ee-body (car args))))
			      (if (not (number? x))
				  (nonum x))
			      (let ((c (- x c)))
				(cond ((null? l) (ee 'quote c))
				      ((and (zero? c)
					    (null? (cdr l))
					    (exact? c))
				       (ee 'app (cons o-op l)))
				      (else (ee 'app
						(cons
						 o-op
						 (cons (ee 'quote c) l)))))))
			    (let ((l (if (and (zero? c) (exact? c))
					 l
					 (cons (ee 'quote c) l))))
			      (if (null? l)
				  (car args)
				  (ee 'app
				      (cons o-op (cons (car args) l))))))))))
	  ((*)
	   (arith args *
		  (lambda (c l)
		    (cond ((null? l)
			   (ee 'quote c))
			  ((zero? c)
			   (unroll-sequence
			    (append l (list (ee 'quote c)))))
			  ((and (= c 1) (exact? c))
			   (if (null? (cdr l))
			       (car l)
			       (ee 'app (cons o-op l))))
			  (else
			   (ee 'app (cons o-op (cons (ee 'quote c) l))))))))
	  ((>) (arith-cmp >))
	  ((<) (arith-cmp <))
	  ((>=) (arith-cmp >=))
	  ((<=) (arith-cmp <=))
	  ((=)
	   (require > 1)
	   (split args
		  (lambda (x) (eq? (ee-type x) 'quote))
		  (lambda (c nc)

		    (define (cmp v)
		      (if (null? nc)
			  (ee 'quote #t)
			  (ee 'app (cons o-op (cons (ee 'quote v) nc)))))

		    (if (null? c)
			(ee 'app (cons o-op nc))
			(let ((vl (map (lambda (x) (ee-body x)) c)))
			  (for-each (lambda (x)
				      (if (not (number? x))
					  (nonum x)))
				    vl)
			  (cond ((or (null? (cdr c))
				     (apply = vl))
				 (cmp (car vl)))
				((null? nc)
				 (ee 'quote #f))
				(else
				 (unroll-sequence
				  (append nc
					  (list (ee 'quote #f)))))))))))
	  ((null?) (onearg null? dontcare))
	  ((pair?) (onearg pair? dontcare))
	  ((boolean?) (onearg boolean? dontcare))
	  ((string?) (onearg string? dontcare))
	  ((vector?) (onearg vector? dontcare))
	  ((char?) (onearg char? dontcare))
	  ((number?) (onearg number? dontcare))
	  ((complex?) (onearg complex? dontcare))
	  ((real?) (onearg real? dontcare))
	  ((rational?) (onearg rational? dontcare))
	  ((integer?) (onearg integer? dontcare))
	  ((exact?) (onearg exact? number?))
	  ((inexact?) (onearg inexact? number?))
	  ((zero?) (onearg zero? number?))
	  ((positive?) (onearg positive? real?))
	  ((negative?) (onearg negative? real?))
	  ((even?) (onearg even? integer?))
	  ((odd?) (onearg odd? integer?))
	  ((numerator) (onearg numerator rational?))
	  ((denominator) (onearg denominator rational?))
	  ((floor) (onearg floor real?))
	  ((ceiling) (onearg ceiling real?))
	  ((truncate) (onearg truncate real?))
	  ((round) (onearg round real?))
	  ((memv) (valcmp memv))
	  ((eqv?) (valcmp eqv?))
	  ((eq?) (valcmp eq?))
	  (else (ee 'app (cons o-op args))))))))
