;; some auxiliary stuff...

(define (aux-functor)

  (module aux-sig ()

    (use scheme-sig)

    ;; list selection
    (define (filter l t?)
      (cond ((not (pair? l)) '())
	    ((t? (car l)) (cons (car l) (filter (cdr l) t?)))
	    (else (filter (cdr l) t?))))

    ;; predicate true for any list element?
    (define (contains p? l)
      (cond ((not (pair? l)) #f)
	    ((p? (car l)) #t)
	    (else (contains p? (cdr l)))))

    (define (split l p c)
      (define (loop l x y)
	(cond ((not (pair? l)) (c x y))
	      ((p (car l)) (loop (cdr l) (cons (car l) x) y))
	      (else (loop (cdr l) x (cons (car l) y)))))
      (loop l '() '()))

    ;; function composition
    (define (compose f g)
      (lambda (x) (f (g x))))

    ;; identity function
    (define (identity x) x)))
