;;########################################################################
;; workmap2.lsp
;; code to implement window objects and methods for the workmap, 
;; a structured graphical user interface for data analysis
;; Copyright (c) 1992-95 by Forrest W. Young
;;########################################################################  

;;------------------------------------------------------------------------
;;define window and icon  management methods for workmap prototype
;;------------------------------------------------------------------------

(defmeth workmap-proto :do-click (x y m1 m2)
  (let* ((n (send self :num-icons))
         (redraw-order (send self :redraw-order))
         (current-time (/ (get-internal-real-time)
                          internal-time-units-per-second))
         (elapsed-time (- current-time (send self :click-time)))
         (text-h (+ (send self :text-ascent) 
                    (send self :text-descent)))
         (bar-bottom (+ 20 text-h));32
         (i nil)
         (iconx (send self :x))
         (icony (send self :y))
         (icon-type nil)
         (data-icon nil)
         (old-selected-icon (send self :selected-icon))
         (new-selected-icon nil)
         (new-current-time 0)
         (newxy nil)
         (ix nil)
         (iy nil)) 
;(format t "~%Elapsed Time=~d " elapsed-time)
#+msdos(setf m2 nil)
    (send self :click-time current-time)
    (when (not (send self :toolbar))
          (send help-overlay-proto :do-click x y m1 m2 self))

;;activate the tool clicked on in a visible toolbar  
    (when (and (send self :toolbar)
               (< y (+ (second (send self :scroll)) bar-bottom)));33
          (send *toolbox* :do-click x y m1 m2))

;;take action when click is below a visible toolbar
;;or anywhere except help button when toolbar is invisible
    (when (or (not (send self :toolbar)) (> y bar-bottom))
    (when (not (and (< x 47) (< y 19))) ; no popup menu on help button
    (cond 
      ((and m2 (= n 0))  ;condition that there are no icons
       (send *popup-desktop-menu* :popup (- x 40) (+ y 2) self))
      
      ((> n 0)           ;condition that there are icons
       (dotimes (j n)
        (setf i  (select redraw-order (- n 1 j)))
        (setf ix (select iconx i))
        (setf iy (select icony i))

;;do something when click is on an icon
        (when (and (> x ix) (< x (+ ix 25)) (> y iy) (< y (+ iy bar-bottom)))
              (setf new-selected-icon (select (send self :icon-list) i))
              (setf icon-type (send new-selected-icon :icon-type))
              (when (or (= icon-type 1) (= icon-type 4) (= icon-type 5))
                    (setf data-icon t))
;;On first click when clicked icon is not a tool,guide or "and" icon
;;select and/or select and drag an unselected data or model icon
;;or drag a selected data or model icon. If shift used, drag icon-tree.
;;If mac option key used, then show popup menu.
;(format t "Icon-type=~d i=~d old-selected-icon=~d~%"
;         icon-type i old-selected-icon)
              (when (and (/= 6 icon-type) (/= 7 icon-type) (/= 2 icon-type))
                    ;when icon is not a tool,guide  or and icon
                 (cond 
                   ((or (> elapsed-time .5)
                        (/= i old-selected-icon)) ;when first click
                    (when (/= i old-selected-icon) ;when an unselected icon
                          (send self :previously-selected-icon
                                old-selected-icon)
                          (cond 
                            ((equal self *expertmap*)
                             (send self :select-icon i))                
                            ((equal self *workmap*)
                             (if data-icon
                                 (setcd (send new-selected-icon :object))
                                 (setcm (send new-selected-icon :object)))
                             (send self :click-time 
                                   (/ (get-internal-real-time)
                                      internal-time-units-per-second)))))
                    (if m2
                        (if data-icon 
                            (when (not (current-datasheet-open))
                                  (send *popup-data-menu* :popup 
                                        (- x 40) (+ y 2) self))
                            (send *popup-model-menu* :popup 
                                  (- x 40) (+ y 2) self))
                        (send self :drag-icon 
                              i newxy x y iconx icony 25 bar-bottom ix iy m1));32
                     (return))
;;On second click open data or model icon.
                   ((< elapsed-time .5)
                    (if data-icon (browse-data) 
                        (report-model :dialog t)) (return))
                    )));ends when click is on an icon
;;drag a selected or unselected tool/guide/and icon or icon-tree
        (when (and (> x ix) (< x (+ ix 45)) (> y iy) (< y (+ iy 13)))
           (setf new-selected-icon (select (send self :icon-list) i))
           (setf icon-type (send new-selected-icon :icon-type))
              (when (or (= 2 icon-type) (< 5 icon-type)) ;tool/guide/and icon
                    (when (and (author) (/= i (send self :selected-icon)))
                          (send self :select-icon i)
                          (send self :previously-selected-icon 
                                old-selected-icon))
                    (send self :drag-icon 
                          i newxy x y iconx icony 45 13 ix iy m1)
                    (return)))
;;popup workmap menu when click is not on an icon (and option key is pressed)
                (when (and m2 (= j (- n 1)))
                  (send *popup-desktop-menu* :popup (- x 40) (+ y 2) self)
                  (return)));ends dotimes loop
       ))))
    (setf new-current-time (/ (get-internal-real-time)
                          internal-time-units-per-second))
   ;(format t "Click Time: ~f~%" (- new-current-time current-time))
    (send self :click-time new-current-time)
    ))

(defmeth workmap-proto :add-icon (w x y title icon-type)
  (send self :redraw-order 
        (append (send self :redraw-order) (list (send self :num-icons))))
  (send self :num-icons (+ 1 (send self :num-icons)))
  (send self :x (append (send self :x) (list x)))
  (send self :y (append (send self :y) (list y)))
  (send self :icon-title (append (send self :icon-title) (list title)))
  (send self :icon-type (append (send self :icon-type) (list icon-type))) 
  (cond 
    ((or (= 1 icon-type)  ;when mv-data-icon
         (= 4 icon-type)  ;when diss-data-icon
         (= 5 icon-type)) ;when table-icon
     (send self :num-data-icons (+ 1 (send self :num-data-icons)))
     (send self :selected-data-icon (- (send self :num-icons) 1))
     (send self :icon-list (append (send self :icon-list)
                 (when (= 1 icon-type) ; data-icon
                 (list (send dob-icon-proto :new w x y 25 32 
                             :title title :draw nil)))
                 (when (= 4 icon-type) ; diss-data-icon
                 (list (send dib-icon-proto :new w x y 25 32 
                             :title title  :draw nil)))
                 (when (= 5 icon-type) ;table-data-icon
                 (list (send tab-icon-proto :new w x y 25 32 
                             :title title  :draw nil)))
                 ))
     (send self :data-icon-number-list (append 
                 (send self :data-icon-number-list)
                 (list (- (send self :num-icons)1))))
     (send self :data-icon-list (append (send self :data-icon-list)
                 (list (select (send self :icon-list) 
                               (- (send self :num-icons) 1)))))
     (send (select (send self :icon-list) (- (send self :num-icons) 1))
           :icon-number (send self :num-data-icons)))
    ((or (= 2 icon-type)  (< 5 icon-type)) ;when tool/guide-icon
     (send self :icon-list (append (send self :icon-list)
                (when (= 2 icon-type) ;tool-icon
                      (list (send tool-icon-proto :new w x y 45 13 
                                  :title title :state "selected" :draw nil)))
                (when (= 6 icon-type) ;guide-icon
                (list (send guide-icon-proto :new w x y 45 13 
                            :title title :draw nil)))
                (when (= 7 icon-type) ;and-icon
                (list (send and-icon-proto :new w x y 45 13 
                            :title title :draw nil)))
                )))
    ((= 3 icon-type)  ;when model-icon
     (send self :num-model-icons (+ 1 (send self :num-model-icons)))
     (send self :icon-list (append (send self :icon-list)
                 (list (send mob-icon-proto :new w x y 25 32 
                             :title title :draw nil))))
     (send self :model-icon-number-list (append 
                 (send self :model-icon-number-list)
                 (list (- (send self :num-icons) 1))))
     (send self :model-icon-list (append (send self :model-icon-list)
                 (list (select (send self :icon-list) 
                               (- (send self :num-icons) 1)))))
     (send (select (send self :icon-list) (- (send self :num-icons) 1))
           :icon-number (send self :num-model-icons)))
    )
  (send self :selected-icon (- (send self :num-icons) 1))
  (let ((n (send self :num-icons)))
    (if (= n 1) 
        (send self :connection-list (list (list nil)))
        (send self :connection-list 
              (append (select (send self :connection-list) (iseq (- n 1)))
                      (list (list nil))))))
;(format t "~%ADD ICON (WM2): ")  
 ; (format t "ADD  ICON -> REDRAW~%")
 ; (send self :redraw)
  (select (send self :icon-list) (send self :selected-icon))
 ; (send self :draw-color 'black)
  )

(defmeth workmap-proto :close ()
;;#+msdos     (send self :hide-window)
#-macintosh (send self :hide-window)
#+macintosh (send self :gui nil)
  )

(defmeth workmap-proto :show-window ()
  
  (call-next-method))

(defmeth workmap-proto :load-object (file)
"Args: (file)
Loads an object contained in FILE."
  (setf file (string-downcase-if-not-X11 file))
  (let* ((f (open (string file)))
         (object (eval (read f)))) 
    (close f)
    (format t "; finished loading ViSta object file: ~s~%" file)
    object))

(defmeth workmap-proto :initialize-data-menu ()
  (send *tools-menu* :enabled t)
  (send visualize-data-menu-item  :enabled t)
  (send summarize-data-menu-item  :enabled t)
  (send save-data-menu-item       :enabled t)
  (send delete-data-menu-item     :enabled t)
  (send create-dob-data-menu-item :enabled t)
  (send show-datasheet-menu-item  :enabled t)
  (send show-obs-menu-item        :enabled t)
  (send show-vars-menu-item       :enabled t)
  (send report-data-menu-item     :enabled t)
  (send browse-data-menu-item     :enabled t)
  )

(defmeth workmap-proto :initialize-trans-menu ()
  (send *trans-menu* :enabled t))

(defmeth workmap-proto :enabled-trans-menu (tnil)
"Enables or disabled all items of the transformation menu"
  (let* ((items (send *trans-menu* :items))
         (num-items (length items)))
    (mapcar #'(lambda (i)
                (send (select items i) :enabled tnil))
            (iseq num-items)))
  (send *trans-menu* :enabled tnil)
  tnil)

(defmeth workmap-proto :initialize-model-menu ()
  (send guide-model-menu-item :enabled t)
  (send visualize-model-menu-item :enabled t)
  (send report-model-menu-item :enabled t)
  (send save-model-menu-item :enabled t)
  (send interpret-model-menu-item :enabled t)
  (send create-dataobjects-model-menu-item :enabled t)
  )

(defmeth workmap-proto :hide-toolbar ()
  (when (send self :toolbar)
        (send self :toolbar nil)
        (when (equal self *workmap*) 
              (send self :add-overlay (send self :help-overlay)))
        (send self :redraw)
        (send *popup-desktop-menu* :delete-items hide-toolbar-popup-item)
        (send *popup-desktop-menu* :append-items show-toolbar-popup-item)
        (send *command-menu* :delete-items command-menu-hide-tool-item)
        (send *command-menu* :append-items command-menu-show-tool-item)))

(defmeth workmap-proto :show-toolbar ()
  (when (not (send self :toolbar))
        (send self :toolbar t)
        (when (equal self *workmap*) 
              (send self :delete-overlay (send self :help-overlay)))
        (send self :move-hidden-icons-down)
        (send self :redraw)
        (send *popup-desktop-menu* :delete-items show-toolbar-popup-item)
        (send *popup-desktop-menu* :append-items hide-toolbar-popup-item)
        (send *command-menu* :delete-items command-menu-show-tool-item)
        (send *command-menu* :append-items command-menu-hide-tool-item)))

(defmeth workmap-proto :move-hidden-icons-down ()
  (let* ((n (send self :num-icons))
         (x (send self :x))
         (y (send self :y)))
    (when (and (> n 0) (< (min y) 32))
          (dotimes (i n)
                   (send self :move-icon-tree i 0 -32 x y nil)))))

(defun show-toolbar ()
  (send *workmap* :show-toolbar))

(defun hide-toolbar ()
  (send *workmap* :hide-toolbar))

;;---------------------------------------------------------------------------
;;define workmap constructor function
;;---------------------------------------------------------------------------

(defun workmap ()
  (let ((object (send workmap-proto :new 2 
                      :title "ViSta WorkMap"
                      :size '(475 280)
                      :show nil)))
    (menus t)
    (send object :menu nil)
    (send object :has-v-scroll t)
    (send object :has-h-scroll t)
    (send object :h-scroll-incs 10 100)
    (send object :v-scroll-incs 10 100)
    (send object :short-icon-titles t)
    object))

(defun desktop () (workmap))

;;########################################################################
;;define toolbox prototype toolbox and it's methods
;;########################################################################

(defproto toolbox-overlay-proto '(num-icons icon-list x y selected-icon)  
   () graph-overlay-proto)

(defmeth toolbox-overlay-proto :isnew (&rest args)
  (apply #'call-next-method args)
  (setf (slot-value 'num-icons) 0))

(defmeth toolbox-overlay-proto :num-icons (&optional (val nil set))
  (if set (setf (slot-value 'num-icons) val))
  (slot-value 'num-icons))

(defmeth toolbox-overlay-proto :icon-list (&optional (val nil set))
  (if set (setf (slot-value 'icon-list) val))
  (slot-value 'icon-list))

(defmeth toolbox-overlay-proto :x (&optional (val nil set))
  (if set (setf (slot-value 'x) val))
  (slot-value 'x))

(defmeth toolbox-overlay-proto :y (&optional (val nil set))
  (if set (setf (slot-value 'y) val))
  (slot-value 'y))

(defmeth toolbox-overlay-proto :selected-icon 
       (&optional (icon-number nil set))
  (if set (setf (slot-value 'selected-icon) icon-number))
  (slot-value 'selected-icon))

(defmeth toolbox-overlay-proto :redraw ()
;fwy
  (when (not (send *workmap* :postpone-redraw))
        (when (send *desktop* :toolbar)
              (let* ((graph (send self :graph))
                     (text-h (+ (send graph :text-ascent) 
                             (send graph :text-descent)))
                     (draw-color (send graph :draw-color))
                     (back-color (send graph :back-color))
                     (n    (send self :num-icons))
                     (icon-list (send self :icon-list))
                     (x    (send self :x))
                     (y    (send self :y))
                     (scroll (send graph :scroll))
                     (scrollx (first scroll))
                     (scrolly (second scroll))
                     (icon nil)
                     (bar-bottom (+ 20 text-h));32
                     (right-end (+ (first (last x)) 56))
                     (h (send graph :canvas-height))
                     (w (send graph :canvas-width))
#+macintosh          (u 1)
#-macintosh          (u 0)
                     )
                (if (send *vista* :background-color)
                    (send graph :draw-color 'toolbar-background)
                    (send graph :draw-color 'white))
                (send graph :paint-rect 
                      (+ scrollx 2) (- scrolly u)
                      (- right-end 4) (+ bar-bottom 2))
                (send graph :draw-color 'toolbar-background)
                (send graph :draw-color draw-color)
                (send graph :back-color 'white)
                (dotimes (i n)
                         (setf icon (select icon-list i))
                         (send icon :x (+ (select x i) scrollx))
                         (send icon :y (+ (select y i) scrolly))
                         (send icon :icon-state (send icon :icon-state))
                         )
                (send graph :draw-color 'black)
                (send graph :frame-rect
                      (+ scrollx 2) (- scrolly u) 
                      (- right-end 4) (+ bar-bottom 2))
                (send graph :frame-rect
                      (+ scrollx 4) (- (+ scrolly 2) u)
                      (- right-end 8) (- bar-bottom 2))
                (when (send *vista* :background-color)
                      (send graph :back-color back-color))
                ))))

(defmeth toolbox-overlay-proto :do-click (x y m1 m2)
  (when (send *desktop* :toolbar)
        (let* ((graph (send self :graph))
               (n (send self :num-icons))
               (icon-list (send self :icon-list))
               (iconx (send self :x))
               (icony (send self :y))
               (scroll (send graph :scroll))
               (scrollx (first scroll))
               (scrolly (second scroll))
               (ix nil)
               (iy nil)
               ) 
          (dotimes (i n)
              (setf ix (+ scrollx (select iconx i)))
              (setf iy (+ scrolly (select icony i)))
              (when (and (< ix x (+ ix 45)) (< iy y (+ iy 13)))
                 (send self :selected-icon i)
                 (let* ((icon (select icon-list i))
                        (state (send icon :icon-state))
                        )
                   (when (equal "normal" state)
                         (send icon :icon-state "selected")
                         (send (eval (send icon :analysis)) :do-action)
                         )))))))

(defmeth toolbox-overlay-proto :add-tool-icon (x y title)
  (let ((graph (send self :graph))
        )
    (send self :num-icons (+ 1 (send self :num-icons)))
    (send self :x (append (send self :x) (list x)))
    (send self :y (append (send self :y) (list y)))
    (send self :icon-list (append (send self :icon-list)
       (list (send tool-icon-proto :new graph x y 45 13 :title title))))
    ))

(defmeth toolbox-overlay-proto :copy-tool-icon (tool-number)
  (send *desktop* :selected-icon (send *desktop* :selected-data-icon))
        (let* ((tool nil)
               (title nil)
               (out-number (send *desktop* :selected-icon))
               )
          (cond ((< tool-number 9)
                 (setf tool (select (send self :icon-list) tool-number))
                 (setf title (send tool :title)))
            (t (setf title (send current-transf :model-abbrev))))
        ;  (send *desktop* :start-buffering)
          (send *desktop* :add-connected-icon out-number title 2)
          (when (< tool-number 9) (send tool :icon-state "normal"))
         ; (send *desktop* :buffer-to-screen)
          ))

(defun show-tools (*toolbox*)
  (let ((tool-names '(
 "Help" "ANOVA" "Coresp" "MDScal" "MulReg" "NonPar" "PrnCmp" "Regres" "UniVar"
;  0       1       2        3        4        5       6           7     8
))
;Was
;"Help" "ANOVA" "Coresp" "Factor" "MDScal" "MulReg" "PrnCmp" "Regres" "UniVar"
;   0       1        2        3       4      5        6         7       8
        (num-tools 9)
        (graph (send *toolbox* :graph))
        )
    (dotimes (i num-tools)
        (send *toolbox* :add-tool-icon 
              (+ (* i 52) 10) 5 (select tool-names i)))
    ))

(defmeth toolbox-overlay-proto :reset-button (but-num)
        (send (select (send self :icon-list) but-num) :icon-state "normal"))

;;---------------------------------------------------------------------------
;;define toolbox overlay constructor function
;;---------------------------------------------------------------------------

(defun toolbox ()
  (let ((overlay (send toolbox-overlay-proto :new))
        )
    (send *workmap* :add-overlay overlay)
    (show-tools overlay)
    (let ((tool-list (send overlay :icon-list))
          )
;fwy4.28 changed next statement for revised help system
      (send (select tool-list 0) :analysis 'workmap-help)
      (send (select tool-list 1) :analysis 'anova-model-menu-item)
      (send (select tool-list 2) :analysis 'corresp-model-menu-item)
      (send (select tool-list 3) :analysis 'mds-model-menu-item)
      (send (select tool-list 4) :analysis 'mulreg-model-menu-item)
      (send (select tool-list 5) :analysis 'nonpar-model-menu-item)
      (send (select tool-list 6) :analysis 'prin-model-menu-item)
      (send (select tool-list 7) :analysis 'reg-model-menu-item)
      (send (select tool-list 8) :analysis 'univar-model-menu-item))   
    overlay))

;fwy4.28 changed next two statements for revised help system
(setf workmap-help
      (send menu-item-proto :new "Show Help" :key #\H
            :action 'show-help))

(defun show-help ()
  (send *workmap* :show-help *workmap*)
  (send (first (send *toolbox* :icon-list)) :icon-state "normal"))


;;###########################################################################
;;define help button overlay prototype and methods
;;###########################################################################

(defproto help-overlay-proto '(x y) () graph-overlay-proto)

;upperleft corner of help button located at pixel 6,3 when x and y are nil, 
;at x,y otherwise

(defmeth help-overlay-proto :x (&optional (val nil set))
  (if set (setf (slot-value 'x) val))
  (slot-value 'x))

(defmeth help-overlay-proto :y (&optional (val nil set))
  (if set (setf (slot-value 'y) val))
  (slot-value 'y))

(defmeth help-overlay-proto :redraw ()
;fwy
  (when (not (send *workmap* :postpone-redraw))
        (let* ((graph (send self :graph))
               (scroll (send graph :scroll))
               (scrollx (first scroll))
               (scrolly (second scroll))
               (x (send self :x))
               (y (send self :y))
               (tw (send graph :text-width "Help")))
          (when (not x) (setf x 6))
          (when (not y) (setf y 3))
          (send graph :draw-color 'white)
          (send graph :paint-rect (+ scrollx x)  (+ scrolly y) (+ tw 22) 16)
          (send graph :draw-color 'black)
          (send graph :frame-rect (+ scrollx x)  (+ scrolly y) (+ tw 22) 16)
          (send graph :frame-rect (+ scrollx x 4) (+ scrolly y 3) 10 10)
          (send graph :draw-string "Help" (+ scrollx x 18) (+ scrolly y 13))
          )))

(defmeth help-overlay-proto :do-click (x y m1 m2 graph)
  (let* ((scroll (send graph :scroll))
         (scrollx (first scroll))
         (scrolly (second scroll))
         (xx (send (send graph :help-overlay) :x))
         (yy (send (send graph :help-overlay) :y))
         (tw (send graph :text-width "Help")))
    (when (not xx) (setf xx 6))
    (when (not yy) (setf yy 3))
    (when (and (< (+ scrollx xx) x (+ scrollx tw xx 22))  10 20
               (< (+ scrolly yy) y (+ scrolly yy 15)))  6 16
          (send graph :show-help graph))))

(defmeth workmap-proto :show-help 
                   (icon &optional (flush t) title (add-help t))
"ARGS: icon &optional (flush t) title
Shows help file associated with ICON, using the icon title as the file name. Flushes existing help window unless FLUSH is nil. Displays icon title as help window title unless TITLE is not nil."
  (let* ((icon-title (send icon :title))
         (i (min (list 8 (length icon-title))))
         (help-file-name icon-title)
         (w (send *vista* :help-window-object))
        )
    (when (equal icon-title "Menu Help") (setf icon-title "Menu Help On"))
    (when (equal ":" (subseq icon-title 4 5))
          (setf help-file-name (strcat (subseq icon-title 0 4) "-" 
                                       (subseq icon-title 5 i))))
    (setf help-file-name 
          (strcat *help-dir-name* 
                  (string-downcase 
                   (subseq (blanks-to-dashes help-file-name) 0 i)) ".hlp"))
    (if (not title) (setf title icon-title))
    (file-to-window help-file-name title w flush add-help)
    ))

(defmeth workmap-proto :plot-help ()
  (send self :show-help self))

(defmeth workmap-proto :add-plot-help-item  ()
  (let* ((g self)
         (m (send menu-item-proto :new "WorkMap"
                  :action '(lambda () 
                      (send (send self :slot-value 'plot-obj) :plot-help))))
         (m2 (send menu-item-proto :new "GuideMap"
                   :action '(lambda ()
                      (file-to-window (strcat *help-dir-name* "guidemap.hlp") 
                                      "GuideMaps" *help-window*))))
         )
    (send m :add-slot 'plot-obj g)
    (send g :add-slot 'plot-help-menu m)
    (send *help-menu* :append-items m m2)
    (defmeth g :remove ()
      (send *help-menu* :delete-items 
            (send self :slot-value 'plot-help-menu))
      (call-next-method))
    m))

(provide "workmap2")