;;########################################################################
;; workmap1.lsp
;; code to implement window objects and methods for the workmap, 
;; a structured graphical user interface for data analysis
;; Copyright (c) 1992-95 by Forrest W. Young
;;########################################################################

(defproto iconmap-proto
  '(num-icons         icon-list     connection-list  x  y
    icon-number-list  redraw-order  selected-icon    previously-selected-icon
    toolbar           gui           icon-type        icon-title
    guidemap-number   help-overlay  postpone-redraw  short-icon-titles) 
  nil graph-proto)

(defmeth iconmap-proto :isnew (&rest args)
  (apply #'call-next-method args)
  (send self :help-overlay (send help-overlay-proto :new))
  (send self :add-overlay (send self :help-overlay))
  (send self :num-icons 0)
#+color (when (> *color-mode* 0) (send self :use-color t))
  )

(defmeth iconmap-proto :num-icons (&optional (val nil set))
  (if set (setf (slot-value 'num-icons) val))
  (slot-value 'num-icons))

(defmeth iconmap-proto :icon-list (&optional (val nil set))
  (if set (setf (slot-value 'icon-list) val))
  (slot-value 'icon-list))

(defmeth iconmap-proto :icon-number-list (&optional (val nil set))
  (if set (setf (slot-value 'icon-number-list) val))
  (slot-value 'icon-number-list))

(defmeth iconmap-proto :connection-list (&optional (list nil set))
  (if set (setf (slot-value 'connection-list) list))
  (slot-value 'connection-list))

(defmeth iconmap-proto :redraw-order (&optional (val nil set))
  (if set (setf (slot-value 'redraw-order) val))
  (slot-value 'redraw-order))

(defmeth iconmap-proto :x (&optional (val nil set))
  (if set (setf (slot-value 'x) val))
  (slot-value 'x))

(defmeth iconmap-proto :y (&optional (val nil set))
  (if set (setf (slot-value 'y) val))
  (slot-value 'y))

(defmeth iconmap-proto :icon-type (&optional (val nil set))
  (if set (setf (slot-value 'icon-type) val))
  (slot-value 'icon-type))

(defmeth iconmap-proto :icon-title (&optional (string nil set))
  (if set (setf (slot-value 'icon-title) string))
  (slot-value 'icon-title))

(defmeth iconmap-proto :selected-icon (&optional (icon-number nil set))
  (if set (setf (slot-value 'selected-icon) icon-number))
  (slot-value 'selected-icon))

(defmeth iconmap-proto :previously-selected-icon (&optional (icon-number nil set))
  (if set (setf (slot-value 'previously-selected-icon) icon-number))
  (slot-value 'previously-selected-icon))

(defmeth iconmap-proto :toolbar (&optional (val nil set))
  (if set (setf (slot-value 'toolbar) val))
  (slot-value 'toolbar))

(defmeth iconmap-proto :gui (&optional (logical nil set))
  (if set (setf (slot-value 'gui) logical))
  (slot-value 'gui))

(defmeth iconmap-proto :help-overlay (&optional (object nil set))
  (if set (setf (slot-value 'help-overlay) object))
  (slot-value 'help-overlay))

(defmeth iconmap-proto :guidemap-number (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the guidemap number (used for identification)." 
  (if set (setf (slot-value 'guidemap-number) number))
  (slot-value 'guidemap-number))

(defmeth iconmap-proto :postpone-redraw (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to postpone redraw." 
  (if set (setf (slot-value 'postpone-redraw) logical))
  (slot-value 'postpone-redraw))

(defmeth iconmap-proto :short-icon-titles (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show short icon titles." 
  (if set (setf (slot-value 'short-icon-titles) logical))
  (slot-value 'short-icon-titles))

(defmeth iconmap-proto :redraw ()
  (send self :start-buffering)
  (call-next-method)
  (send self :redraw-overlays)
  (send self :buffer-to-screen)
  )

(defmeth iconmap-proto :redraw-background ()
  (send self :back-color 'workmap-background) ;tool-bar color
  (call-next-method))



(defmeth iconmap-proto :redraw-content ()
  (when (not (send self :postpone-redraw))
  (when (send *vista* :ready-to-redraw self);fwy 4.31 10/30/97 
   (when (send self :gui)
     (let* ((n    (send self :num-icons))
            (icon-list (send self :icon-list))
            (icon-type nil)
            (redraw-order (send self :redraw-order))
            (connection-list (send self :connection-list))
            (draw-x-offset nil)
            (draw-y-offset nil)
            (x    (send self :x))
            (y    (send self :y))
            (scroll (send self :scroll))
            (scrollx (first scroll))
            (scrolly (second scroll))
            (size (send self :size))
            (w (first size))
            (h (second size))
            (draw-color (send self :draw-color))
            (back-color (send self :back-color))
            )
;(format t "~%~%N=~d ~%Icon-List=~f ~%Redraw-Order=~f ~%Connection-List=~f ;~%x=~f ~%y=~f" n icon-list redraw-order connection-list x y)
       (when (and icon-list (not connection-list)) 
             (setf connection-list '((nil)))
             (send self :connection-list connection-list))
       (send self :start-buffering)
       (call-next-method)
       (send self :erase-window) 
      ; (send self :back-color 'workmap-background)
      ; (send self :paint-rect scrollx scrolly w h)
      ; (send self :draw-color draw-color)
       (when (and (> n 0) icon-list)
             (send self :back-color 'white)
             (dotimes (i n)
                      (setf icon-type 
                            (send (select icon-list (select redraw-order i)) 
                                  :icon-type))
                      (when (select (select connection-list 
                                            (select redraw-order i)) 0)
                            (dotimes (j (length (select connection-list
                                                  (select redraw-order i))))
                                     (send self :connect-icons 
                                           (select redraw-order i)
                                           (select (select connection-list
                                               (select redraw-order i)) j))))
               #+color(when (> *color-mode* 0)
                       (cond
                        ((or (= 1 icon-type) (= 4 icon-type) (= 5 icon-type))
                         (send self :draw-color 'data-icon-color))
                        ((= 2 icon-type) 
                         (send self :draw-color 'tool-icon-color))
                        (t (send self :draw-color 'model-icon-color))))
                      (if (= i (- n 1))
                          (send self :draw-bitmap 
                                     (send (select icon-list 
                                         (select redraw-order i)) :hi-icon)
                                (select x (select redraw-order i)) 
                                (select y (select redraw-order i)))
                          (send self :draw-bitmap 
                                (send (select icon-list 
                                              (select redraw-order i)) :icon)
                                (select x (select redraw-order i)) 
                                (select y (select redraw-order i)))
                          )
                      (send self :draw-color 'black)
                      (setf draw-x-offset 13)
                      (setf draw-y-offset 31)
                      (setf icon-type 
                            (send (select icon-list (select redraw-order i)) 
                                  :icon-type))
                      (when (or (< 5 icon-type) (= 2 icon-type))
                            (setf draw-x-offset 22)
                            (setf draw-y-offset 12))
                      (send (select icon-list(select redraw-order i)) :draw-title)
                      ))
       (send self :back-color back-color)
       (send self :buffer-to-screen)
       )))
        (send *vista* :finished-redraw self);fwy 4.31 10/30/97
        ))

(defmeth iconmap-proto :do-click (x y m1 m2)
  (let* ((n (send self :num-icons))
         (redraw-order (send self :redraw-order))
         (i nil)
         (iconx (send self :x))
         (icony (send self :y))
         (newxy nil)
         (ix nil)
         (iy nil)
        )
      (when (> n 0)           ;when there are icons
            (dotimes (j n)
               (setf i  (select redraw-order (- n 1 j)))
               (setf ix (select iconx i))
               (setf iy (select icony i))
               (when (and (> x ix) (< x (+ ix 45)) (> y iy) (< y (+ iy 13)))
                     (send self :select-icon i)
                     (send self :drag-icon 
                           i newxy x y iconx icony 45 13 ix iy m1)
                     (return))))
    ))

(defmeth iconmap-proto :drag-icon 
          (i newxy x y iconx icony colpix rowpix xoff yoff shift)
;i is icon number. newxy is nil. 
;x and y are locations of click
;iconx icony are lists of old x y locs of upper left corner of all icons
;colpix rowpix are sizes of icon i
;xoff yoff are locations moving icon i from (ith iconx and icony)
;shift is t if move tree
  (let ((oldlocx (select iconx i))
        (oldlocy (select icony i))
        (offsetx 0)
        (offsety 0)
        (bar-bottom (+ 30 (send self :text-ascent) 
                       (send self :text-descent)))
        )
    (setf newxy 
          (send self :drag-grey-rect x y colpix rowpix (- x xoff) (- y yoff)))
    (when (< (first newxy) 0) (setf (first newxy) 0))
    (when (< (second newxy) 0) (setf (second newxy) 0))
    (when (and (< (second newxy) bar-bottom)
               (equal self *workmap*)
               (send self :toolbar))
          (setf (second newxy) bar-bottom))
    (setf offsetx (- oldlocx (select newxy 0)))
    (setf offsety (- oldlocy (select newxy 1)))
    (send self :move-icon-tree i offsetx offsety iconx icony shift)
    (dotimes (iconnum (send self :num-icons))
             (send (select (send self :icon-list) iconnum) :moved-p nil))
    )
  (when (or (/= (first newxy) xoff) (/= (second newxy) yoff))
        (send self :redraw))
  )

(defmeth iconmap-proto :move-icon-tree (i offsetx offsety iconx icony shift)
  (let ((icon-i (select (send self :icon-list) i))
        )
    (setf (select iconx i) (- (select iconx i) offsetx))
    (setf (select icony i) (- (select icony i) offsety))
    (send icon-i :x (select iconx i))
    (send icon-i :y (select icony i))
    (send icon-i :moved-p t)
    )
  (when shift 
        (let ((connected-icons (select (send self :connection-list) i))
              )
          (when (select connected-icons 0)
                (dolist 
                 (j connected-icons)
                 (when 
                  (not (send (select (send self :icon-list) j) :moved-p))
                  (send self :move-icon-tree 
                        j offsetx offsety iconx icony shift)))
                ))))

(defmeth iconmap-proto :select-icon (i)
  (when (> (send self :num-icons) 1)
        (let ((icon-number nil)
              (ix (select (send self :x) i))
              (iy (select (send self :y) i))
              (icon-list (send self :icon-list))
              (selected-icon (send self :selected-icon))
              (redraw-order (send self :redraw-order))
              (iconx (send self :x))
              (icony (send self :y))
              (draw-color (send self :draw-color))
              (icon-type (select (send self :icon-type) i))
              )
          (send self :selected-icon i)
          (setf icon-number (send self :selected-icon))
   #+color(when (and (> *color-mode* 0) (send self :use-color))
                (cond
                  ((or (= 1 icon-type) (= 4 icon-type) (= 5 icon-type))
                   (send self :draw-color 'data-icon-color))
                  ((= 2 icon-type)
                   (send self :draw-color 'tool-icon-color))
                  (t (send self :draw-color 'model-icon-color))))
          (send self :draw-bitmap  
                (send (select icon-list selected-icon) :icon) 
                (select iconx selected-icon) 
                (select icony selected-icon))
          (send (select icon-list selected-icon) :icon-state "normal")
          (send self :draw-bitmap 
                (send (select icon-list i) :hi-icon) ix iy)
          (send self :draw-color draw-color)
          (send (select icon-list i) :icon-state "selected")
          (send self :redraw-order 
                (combine (remove icon-number redraw-order) icon-number))
          )))

(defmeth iconmap-proto :add-connected-icon (from-icon-number title icon-type 
                  &key (x-offset 0) (y-offset 0))
  (let* ((from-icon (select (send self :icon-list) from-icon-number))
         (from-x (send from-icon :x))
         (from-y (send from-icon :y))
         (to-icon nil)
         (to-icon-number nil)
         (to-x nil)
         (to-y nil)
         (horizontal-seperation 74);was 94
         (vertical-seperation   19);was 16,14
         (vertical-zig-zag      0); was 10
         (num-connections (length 
            (select (send self :connection-list) from-icon-number)))
         )
    (when (and (= num-connections 1) 
               (not (select 
                     (select (send self :connection-list) from-icon-number)
                     0)))
          (setf num-connections 0))
    (setf x-offset (* num-connections horizontal-seperation))
    (when (or (= 2 icon-type) (= 6 icon-type)) 
          (setf x-offset (- x-offset 10)))
    (when (or (= 2 (send from-icon :icon-type)) 
              (= 6 (send from-icon :icon-type)))
          (setf x-offset (+ x-offset 10)))
    (setf y-offset (+ (send from-icon :height) vertical-seperation))
    (setf to-x (+ from-x x-offset))
    (setf to-y (+ from-y y-offset))
    (when (/= (/ num-connections 2) (floor (/ num-connections 2))) 
          (setf to-y (+ to-y vertical-zig-zag)))
    (setf to-icon (send self :add-icon self to-x to-y title icon-type))
    (setf to-icon-number (- (send self :num-icons) 1))
    (send from-icon :show-icon "normal")
    (send self :connect-icons from-icon-number to-icon-number :new t)
    (send to-icon :show-icon "selected")
    to-icon
    ))

(defmeth iconmap-proto :locate-new-icon ()
  (let* ((n (send self :num-icons))
         (min-separation-x 35);was 50,35
         (min-separation-y 70);was 70,40
         (x-spacing 80);was 77,60
         (y-spacing 74);was 94 (104 puts 4 icons in std window,64=7,84=5)
         (grid-x min-separation-x);was 46,36
         (grid-y 40);was 50
         (vertical-zig-zag 0);was 10
         (min-y (+ 30 (send self :text-ascent) 
                   (send self :text-descent)))
         (grid-y (if (< grid-y min-y) (setf grid-y min-y) grid-y))
         (violate-x 0)
         (violate-y 0)
         (all-x (send self :x))
         (all-y (send self :y))
         (try-x nil)
         (try-y nil)
         (neg-x nil)
         (neg-y nil)
         (iflag t)
         (ok-x grid-x);was 46,36
         (ok-y grid-y);was 50,40
         (set-x grid-x);was 46,36
         )
    (when (> n 0)
      (dotimes (i (floor (/ (select (send self :size) 0) x-spacing)))
        (setf grid-y (+ (* i x-spacing) ok-y));ok-y was constant=50
        (setf try-y (abs (- all-y grid-y)))
        (setf violate-y (- try-y min-separation-y))
        (when (>= (min violate-y) 0)
                    (setf ok-x set-x);set-x was constant-46
                    (setf ok-y grid-y)
                    (return))
        (setf neg-y (< violate-y 0))
        (dotimes (j (floor (/ (select (send self :size) 0) y-spacing)))
          (setf grid-x (+ (* j y-spacing) ok-x));ok-x was constant=46
          (setf try-x (abs (- all-x grid-x)))
          (setf violate-x (- try-x min-separation-x))
          (setf neg-x (< violate-x 0))
          (when (not (which (select neg-x (which neg-y))))
                (when iflag
                      (setf ok-x grid-x)
                      (setf ok-y grid-y)
                      (when (/= (/ j 2) (floor (/ j 2))) 
                            (setf ok-y (+ ok-y vertical-zig-zag)))
                      (setf iflag nil)
                      (return))))
          (when (not iflag) (return))
          
       ))
    (when (< ok-y min-y) (setf ok-y min-y))
    (list ok-x ok-y)
    ))

(defmeth iconmap-proto :connect-icons (icon-number-out icon-number-in 
                                                       &key new)
  (let* ((icon-out (select (send self :icon-list) icon-number-out))
         (x-out (send icon-out :x))
         (y-out (send icon-out :y))
         (icon-in  (select (send self :icon-list) icon-number-in))
         (x-in  (send icon-in  :x))
         (y-in  (send icon-in  :y))
         (center-out (floor (/ (send icon-out :width) 2)))
         (center-in  (floor (/ (send icon-in  :width) 2)))
         (below-out  (send icon-out :height))
         (below-in   (send icon-in  :height))
         (c 8) ;this is a constant for wrapping line around icons
         (c+ (+ c 1))
         (horizontal-in  (+ center-in c)) 
         (horizontal-out (+ center-out c)) 
         (line-start-x (+ x-out center-out))
         (line-start-y (+ y-out below-out))
         (line-end-x (+ x-in center-in))
         (line-end-y y-in)
         (line-mid-segment-x nil)
         (line-mid-segment-y nil)
         (ifl nil)
         (line-list (list (list line-start-x line-start-y)))) 
    (cond 
      ((and (= line-start-x line-end-x) ;when in icon directly below out icon
            (< line-start-y line-end-y))
       (setf line-list (append line-list (list 
                              (list 0 (- line-end-y line-start-y 1))))))
      (t ;in not directly below out
         (setf line-list (append line-list (list (list 0 10))))
         (cond
           ((< line-start-y line-end-y) ;in below out, but not directly
            (setf line-list (append line-list (list 
                            (list (- line-end-x line-start-x)
                                  (- line-end-y c+ (+ line-start-y 10)))
                            (list 0 c)))))
           (t ;in above out
              (when (> line-start-x line-end-x)  ;in right of out
                    (setf horizontal-out (- horizontal-out))
                    (setf horizontal-in  (- horizontal-in)))
              (setf line-list (append line-list (list
                              (list horizontal-out 0))))
              (setf line-mid-segment-x (- (- line-end-x horizontal-in) 
                                          (+ line-start-x horizontal-out)))
              (setf line-mid-segment-y (- (- line-end-y c+)
                                          (+ line-start-y 10)))
              (when (> (* line-mid-segment-x (- line-start-x line-end-x)) 0)
                    (setf ifl t)
                    (setf line-mid-segment-x 
                          (+ line-mid-segment-x (* 2 horizontal-in)))
                    (setf horizontal-in (- horizontal-in))
                    (setf line-mid-segment-y 
                          (+ line-mid-segment-y below-in 19)))
              (setf line-list (append line-list (list 
                              (list line-mid-segment-x line-mid-segment-y))))
              (when ifl
                    (setf line-list (append line-list (list 
                                    (list 0 (- 0 below-in 19))))))
              (setf line-list (append line-list (list
                              (list horizontal-in 0)
                              (list 0 c)))))))) 
    (setf line-list (append line-list (list '(-4 -4) '(8 0) '(-4 4))))
    (send self :frame-poly line-list nil) 
    (when new 
          (let ((to-list 
                 (select (send self :connection-list) icon-number-out))
                )
            (setf to-list (remove 'nil (combine to-list icon-number-in)))
            (setf (select (send self :connection-list) icon-number-out)
                  to-list)))))

;;########################################################################
;;define workmap prototype window object inheriting from iconmap prototype
;;########################################################################

(defproto workmap-proto
  '(num-data-icons      num-model-icons 
    data-icon-list      data-icon-number-list 
    model-icon-list     model-icon-number-list 
    selected-data-icon  previously-selected-data-icon
    num-data-menu-items num-model-menu-items
    active-button-list  click-time)   
  nil iconmap-proto)

(defmeth workmap-proto :isnew (&rest args)
  (apply #'call-next-method args)
  (send self :num-data-icons 0)
  (send self :num-model-icons 0)
  (send self :click-time (/ (get-internal-real-time) 
                            internal-time-units-per-second))
  (send self :add-plot-help-item)
#+color (when (> *color-mode* 0) (send self :use-color t))
  )

(defmeth workmap-proto :num-data-icons (&optional (val nil set))
  (if set (setf (slot-value 'num-data-icons) val))
  (slot-value 'num-data-icons))

(defmeth workmap-proto :num-model-icons (&optional (val nil set))
  (if set (setf (slot-value 'num-model-icons) val))
  (slot-value 'num-model-icons))

(defmeth workmap-proto :data-icon-list (&optional (val nil set))
  (if set (setf (slot-value 'data-icon-list) val))
  (slot-value 'data-icon-list))

(defmeth workmap-proto :model-icon-list (&optional (val nil set))
  (if set (setf (slot-value 'model-icon-list) val))
  (slot-value 'model-icon-list))

(defmeth workmap-proto :data-icon-number-list (&optional (val nil set))
  (if set (setf (slot-value 'data-icon-number-list) val))
  (slot-value 'data-icon-number-list))

(defmeth workmap-proto :model-icon-number-list (&optional (val nil set))
  (if set (setf (slot-value 'model-icon-number-list) val))
  (slot-value 'model-icon-number-list))

(defmeth workmap-proto :num-data-menu-items (&optional (val nil set))
  (if set (setf (slot-value 'num-data-menu-items) val))
  (slot-value 'num-data-menu-items))

(defmeth workmap-proto :num-model-menu-items (&optional (val nil set))
  (if set (setf (slot-value 'num-model-menu-items) val))
  (slot-value 'num-model-menu-items))

(defmeth workmap-proto :selected-data-icon (&optional (icon-number nil set))
  (if set (setf (slot-value 'selected-data-icon) icon-number))
  (slot-value 'selected-data-icon))

(defmeth iconmap-proto :active-button-list (&optional (list nil set))
  (if set (setf (slot-value 'active-button-list) list))
  (slot-value 'active-button-list))

(defmeth workmap-proto :previously-selected-data-icon 
                        (&optional (icon-number nil set))
  (if set (setf (slot-value 'previously-selected-data-icon) icon-number))
  (slot-value 'previously-selected-data-icon))

(defmeth workmap-proto :click-time (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the time at which a click occurs." 
  (if set (setf (slot-value 'click-time) number))
  (slot-value 'click-time))

(defmeth workmap-proto :data-in-construction (&optional args)
"Message args: (&optional args)
 Sets or retrieves whether to postpone redraw because there is a data object in construction."
  (send self :postpone-redraw args))

(defmeth workmap-proto :gui (&optional (arg nil set))
  (when set 
        (setf (slot-value 'gui) arg)
        (cond (arg
               (send self :show-window))
          (t
           (send self :hide-window))))
  (slot-value 'gui))

(defmeth workmap-proto :toolbar (&optional (val nil set))
  (if set (setf (slot-value 'toolbar) val))
  (slot-value 'toolbar))

(defmeth workmap-proto :no-menu-marks (menu-object)
    (dolist (i (iseq 4 (- (length (send menu-object :items)) 1)))
             (send (select (send menu-object :items) i) :mark nil)))
        
(provide "workmap1")