;;########################################################################
;; vismenu2.lsp
;; contains code to define ViSta command, help, tool and file menus
;; Copyright (c) 1991-98 by Forrest W. Young
;; X11 changes by Anthony J. Rossini
;;########################################################################
(defun quit ())

(defun save-exit ()
"Changes Quit or Exit to present warning dialog box"
  (let (
#+macintosh (exit-item (- (length (send *file-menu* :items)) 1))
#+msdos     (exit-item  3)
#+X11       (exit-item  10)
        )
    (send *file-menu* :delete-items
          (select (send *file-menu* :items) exit-item))
    (send *file-menu* :append-items
          (send menu-item-proto :new "Quit" :key #\Q 
                :action #'(lambda () (quit) )
                ))))
;save-exit-dialog-box function is in function.lsp

;; AJR add msdos, X11.
;;#-macintosh (defvar *command-menu* (send menu-proto :new "Command"))
#+msdos (defvar *command-menu* (send menu-proto :new "Command"))
#+X11   (defvar *command-menu* (send menu-proto :new "Command"))

(setf command-menu-dribble-item
      (send menu-item-proto :new "Record Listener ..."
            :action #'(lambda ()
            (cond
              ((send command-menu-dribble-item :mark) (dribble)
               (send command-menu-dribble-item :mark nil))
              (t (let ((f 

#-X11  (set-file-dialog "Listener file:")
#+X11  (file-save-dialog "Std. Output file:" "*.txt" "." "dribble.txt")
))
                   (when f
                         (dribble f)
                         (send command-menu-dribble-item :mark t))))))))



(setf command-menu-workmap-item
      (send menu-item-proto :new "Show WorkMap"
            :action #'(lambda () (send *workmap* :gui t))))

(setf command-menu-guidemap-item
      (send menu-item-proto :new "Show GuideMap"
            :action 'show-guidemap))

(setf command-menu-refresh-spreadplot-item
      (send menu-item-proto :new "Refresh SpreadPlot" :enabled nil
            :action 'refresh-spreadplot))

(setf command-menu-refresh-item
      (send menu-item-proto :new "Refresh Desktop"
            :action 'refresh-desktop))

(setf command-menu-show-tool-item
      (send menu-item-proto :new "Show ToolBar" :key #\T
            :action 'show-toolbar))

(setf command-menu-hide-tool-item
      (send menu-item-proto :new "Hide ToolBar" :key #\T
            :action 'hide-toolbar))

(setf command-menu-resize-item
      (send menu-item-proto :new "Resize Desktop ..."
            :action 'resize-desktop))

(setf command-menu-colors-item
      (send menu-item-proto :new "Change Colors ..."
            :action 'change-colors))

(setf command-menu-startup-item
      (send menu-item-proto :new "Startup Preferences... "
            :action 'startup-preferences))

(setf command-menu-buglist-item
      (send menu-item-proto :new "Show Bug List"
            :action 'show-bug-list))

(setf command-menu-configure-item
      (send menu-item-proto :new "Configure ..."
            :action 'configure))

(setf command-menu-author-item
      (send menu-item-proto :new "Author GuideMaps"
            :action 'author-guidemaps))

(setf command-menu-screen-saver-item
      (send menu-item-proto :new "Screen Saver"
            :action 'screen-saver))

(defun select-current-data-icon ()
  (send *workmap* :select-icon
        (select (send *workmap* :data-icon-number-list)
                (- current-item-number
                   (send *workmap* :num-data-menu-items)))))

#+macintosh(defun show-listener () (send *listener* :show-window))

#+macintosh(setf listener-menu-item (select (send *command-menu* :items) 0))
#+macintosh(setf dash1 (select (send *command-menu* :items) 1))
#+macintosh(setf cleanup (select (send *command-menu* :items) 2))
#+macintosh(setf toplevel (select (send *command-menu* :items) 3))
#+macintosh(setf dash2 (select (send *command-menu* :items) 4))
#+macintosh(setf dribble (select (send *command-menu* :items) 5))
#+macintosh(setf repeat (select (send *command-menu* :items) 6))
#+macintosh(send *command-menu* :delete-items
                 listener-menu-item dash1 cleanup toplevel 
                 dash2 dribble repeat)

(send *command-menu* :append-items
      command-menu-workmap-item
      command-menu-guidemap-item
#+macintosh (send menu-item-proto :new "Show Listener" 
                  :action #'show-listener)
      (send dash-item-proto :new)
      command-menu-refresh-item
      command-menu-resize-item
      command-menu-colors-item
      command-menu-refresh-spreadplot-item
      (send dash-item-proto :new))
(when *change-profiles*
      (send *command-menu* :append-items
            command-menu-startup-item))
(when *configure*
      (send *command-menu* :append-items
            command-menu-configure-item))
(when *author*
      (send *command-menu* :append-items
            command-menu-author-item))
(send *command-menu* :append-items
      command-menu-show-tool-item
      command-menu-buglist-item
      command-menu-screen-saver-item
      (send dash-item-proto :new)
#-macintosh (send menu-item-proto :new "Clean Up" :action #'clean-up)
#+macintosh cleanup
#-macintosh (send menu-item-proto :new "Toplevel" :action #'top-level)
#+macintosh toplevel
      command-menu-dribble-item
#+macintosh repeat
      )

(setf new-data-file-menu-item
      (send expert-menu-item-proto :new "New Data ..." :key #\N ;fwy 4.28
            :action 'new-data))

(setf open-data-file-menu-item
      (send expert-menu-item-proto :new "Open Data ..." :key #\O ;fwy 4.28
            :action 'open-data))

(setf simulate-data-file-menu-item
      (send expert-menu-item-proto :new "Simulate Data ..." ;fwy 4.28
            :action 'simulate-data))

(setf import-data-file-menu-item
      (send expert-menu-item-proto :new "Import Data ..." ;fwy 4.28
            :action 'import-data))

(setf print-file-menu-item
      (send menu-item-proto :new "Print" :key #\P ;fwy 4.32
            :action 'print-output))


;;RAF 7/29/95
#+macintosh (setf close-window-menu-item
                  (send menu-item-proto :new "Close Window" :key  #\W
                        :action
                        #'(lambda ()
                            (let* (
                                   (fw (front-window))
                                   )
                              (if (send fw :has-method ':close)
                                  (send fw :close)) )) ))

;;RAF 7/29/95
#+macintosh (defmeth close-window-menu-item :update ()
              (let (
                    (fw (front-window))
                    )
                (if fw
                    (send self :enabled (send fw :has-method ':close))
                    (send self :enabled nil) )) )

#+macintosh (defun close-window ()
              (send close-window-menu-item :do-action))

(setf load-edit-menu-item
      (send menu-item-proto :new "Load Edit" :key #\L
            :action #'(lambda () (clean-open-file-dialog t))))

(defun mac-file-menu ()
  (let ((file-menu-items (send *file-menu* :items))
        )
    (apply #'send *file-menu* ':delete-items file-menu-items)
    (send *file-menu* :append-items
          new-data-file-menu-item    ;new data 0
          open-data-file-menu-item   ;open data 1
          simulate-data-file-menu-item ;simulate data 2
          import-data-file-menu-item ;import data 3
          (send dash-item-proto :new);dash       4
          save-data-menu-item        ;save data 5 moved here fwy 4.29 8/25/97
          save-model-menu-item       ;save data 6 moved here fwy 4.29 8/25/97
          load-data-menu-item        ;7
          load-model-menu-item       ;8
          (send dash-item-proto :new) ;9
          print-file-menu-item        ;10
          (send dash-item-proto :new);dash      11
          (select file-menu-items 2) ;new  edit 12
          (select file-menu-items 3) ;open edit 13
          (select file-menu-items 5) ;save edit 14
          (select file-menu-items 6) ;save edit as 15
          load-edit-menu-item ;(select file-menu-items 0) load edit 16
          (send dash-item-proto :new)
          close-window-menu-item
          (select file-menu-items 10);quit
          )
;    (send (select (send *file-menu* :items)  5) :key #\S) ;save data
    (send (select (send *file-menu* :items) 12) :key nil) ;new edit
    (send (select (send *file-menu* :items) 13) :key nil) ;open data
;    (send (select (send *file-menu* :items) 14) :key nil) ;save edit
    (send (select (send *file-menu* :items) 16) :title "Load Edit")
     ))
#+macintosh(mac-file-menu)

(defun msdos-file-menu ()
  (apply #'send *file-menu* ':delete-items (send *file-menu* :items))
  (send *file-menu* :append-items
        new-data-file-menu-item
        open-data-file-menu-item
        simulate-data-file-menu-item
        import-data-file-menu-item
        (send dash-item-proto :new)
        save-data-menu-item        ;save data 8 moved here fwy 4.29 8/25/97
        save-model-menu-item       ;save data 8 moved here fwy 4.29 8/25/97
        (send dash-item-proto :new)
        load-data-menu-item
        load-model-menu-item
        (send menu-item-proto :new "&Load Edit" :action
              #'(lambda ()
                  (let ((fname (open-file-dialog)))
                    (if fname (load fname)))))
        (send dash-item-proto :new)
        print-file-menu-item
        (send dash-item-proto :new)	
        (send menu-item-proto :new "E&xit" :action #'quit)
        )
  (send *file-menu* :install))

;(defun msdos-file-menu () (mac-file-menu))
#+msdos(msdos-file-menu)


;; AJR -- needed for X11.
(defun x11-file-menu ()
  (apply #'send *file-menu* ':delete-items (send *file-menu* :items))
  (send *file-menu* :append-items
        new-data-file-menu-item
        open-data-file-menu-item
        simulate-data-file-menu-item
        import-data-file-menu-item
        (send dash-item-proto :new)
        save-data-menu-item        ;save data 8 moved here fwy 4.29 8/25/97
        save-model-menu-item       ;save data 8 moved here fwy 4.29 8/25/97
        (send dash-item-proto :new)
        load-data-menu-item
        load-model-menu-item
        (send menu-item-proto :new "Load Edit" :action
              #'(lambda ()
                  (let ((fname (open-file-dialog)))
                    (if fname (load fname)))))
        (send dash-item-proto :new)
        (send menu-item-proto :new "Quit" :action #'quit)
        (send menu-item-proto :new "About XLISP-STAT ..." :action #'about-xlisp-stat)
        (send menu-item-proto :new "About ViSta ..." :action #'about-vista))
  (send *file-menu* :install))
#+X11 (x11-file-menu)


;;RAF 7/29/95
#+macintosh(send (select (send *edit-menu* :items) 10) :key #\G)
#+macintosh(defun remove-undo-item ()
             (let* ((edit-menu-items (send *edit-menu* :items))
                    (edit-menu-length (1- (length edit-menu-items)))
                    (edit-items (select edit-menu-items 
                                        (iseq 2 edit-menu-length)))
                    )
               (apply #'send *edit-menu* :delete-items edit-menu-items)
               (apply #'send *edit-menu* :append-items edit-items)))
#+macintosh(remove-undo-item)

; asked charlie to remove #-X11 on next stmnt. Will quit work under X11?
(save-exit) 

(defvar *expert-menu* (send menu-proto :new "Tools"))

(setf link-icon-expert-menu-item
      (send menu-item-proto :new "Auto LINK Icon" :enabled t
            :action 'auto-link-icon))

(setf return-icon-expert-menu-item
      (send menu-item-proto :new "Auto RETURN Icon" :enabled t
            :action 'auto-return-icon))

(setf link-button-expert-menu-item
      (send menu-item-proto :new "LINK Button" :enabled t
            :action 'link-button))

(setf return-button-expert-menu-item
      (send menu-item-proto :new "RETURN Button" :enabled t
            :action 'return-button))

(setf goto-button-expert-menu-item
      (send menu-item-proto :new "GOTO Button" :enabled t
            :action 'goto-button))

(setf and-icon-expert-menu-item
      (send menu-item-proto :new "AND Icon" :enabled t
            :action 'and-icon))

(setf connect-icons-expert-menu-item
      (send menu-item-proto :new "Connect Objects" :enabled t
            :action 'connect-objects))

(setf active-icon-expert-menu-item
      (send menu-item-proto :new "Initial Button" :enabled t
            :action #'(lambda () (send *expertmap* :initial-button))))

(setf save-expert-menu-item
      (send menu-item-proto :new "Save Author Map" :enabled t
            :action #'(lambda () (send *expertmap* :save-workmap))))

(send *expert-menu* :append-items
      and-icon-expert-menu-item
      link-icon-expert-menu-item
      return-icon-expert-menu-item
      (send dash-item-proto :new)
      link-button-expert-menu-item
      return-button-expert-menu-item
      goto-button-expert-menu-item
      (send dash-item-proto :new)
      connect-icons-expert-menu-item
      active-icon-expert-menu-item
      (send dash-item-proto :new)
      save-expert-menu-item)

(defvar *help-menu* (send menu-proto :new "Help"))
(send   *help-menu* :enabled t)


(setf help-menu-help-topics-item
      (send menu-item-proto :new "Help Topics" :key #\H
            :action 'vista-help))

(defun help-topics () (vista-help))

(defun vista-help ()
  (send *workmap* :show-help *vista-help*))

(setf help-menu-menu-help-item
      (send menu-item-proto :new "Menu Help"
            :action 'show-menu-help))

(defun menu-help () (show-menu-help))

(defun show-menu-help ()
  (cond 
    ((send *vista* :show-help)
     (send *vista* :show-help nil)
     (send mv-data-object-proto :set-menu&tool-states
           (send *vista* :menu-states))
     (send help-menu-menu-help-item :mark nil)
     (menu-help-off)
     (when *current-data* (setcd *current-data* t))
     (if *current-model*
         (setcm *current-model*)
         (send *model-menu* :enabled nil))
     )
    (t
     (send *vista* :show-help t)
     (send help-menu-menu-help-item :mark t)
     (send mv-data-object-proto :set-menu&tool-states "Enabled")
     (send *workmap* :show-help help-menu-menu-help-item))
    (send *vista* :show-menu-help-again t)
    ))

(defun file-to-window (filename title w)
  (send *vista* :file-to-help-window filename title w)
  w)

(defun menu-help-off ()
  (file-to-window 
   (strcat *help-dir-name* "menuoff.hlp") "Menu Help Off" *help-window*))

(setf help-menu-plot-help-item
      (send menu-item-proto :new "Window Help"
            :action 'window-help))

(defun window-help ()
  (send (front-window) :plot-help))

(setf help-menu-spreadplot-help-item
      (send menu-item-proto :new "SpreadPlot Help"
            :action 'spreadplot-help))

(setf help-menu-guidemap-item
      (send menu-item-proto :new "Show GuideMap"
            :action 'show-guidemap))

(send *help-menu* :append-items
      help-menu-help-topics-item
#-macintosh(send menu-item-proto :new "About XLISP-STAT ..." 
            :action #'about-xlisp-stat)
#-macintosh(send menu-item-proto :new "About ViSta ..." 
            :action #'(lambda () (about-vista)))
      (send dash-item-proto :new)
      help-menu-menu-help-item
      help-menu-spreadplot-help-item
      help-menu-guidemap-item
      (send dash-item-proto :new)
      )

;(send *help-menu* :install)
(setf HELP-MENU-SHOW-HELP-ITEM help-menu-help-topics-item); for quit to work

(provide "vismenu2")