/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include<limits.h>
#include<ncurses.h>

#define MENU_COLOR 1
#define BORDER_COLOR 2
#define WIN_COLOR 3
#define	STATUS_BAR_COLOR  4
#define CURR_LINE_COLOR 5
#define DIRECTORY_COLOR 6
#define LINK_COLOR 7
#define SOCKET_COLOR 8
#define DEVICE_COLOR 9
#define EXECUTABLE_COLOR 10
#define SELECTED_COLOR 11
#define CURRENT_COLOR 12


typedef struct _Config {
	char config_dir[PATH_MAX];
	char trash_dir[PATH_MAX];
	char *vi_command;
	int bookmarks_pos;
	int use_trash;
	int use_color;
	int vim_filter;
	int use_screen;
	int show_full;
	int use_vim_help;
	int command_num;
	int filetypes_num;
	int history_len;
	int nmapped_num;
	int screen_num;
	int timer;
} Config;


extern Config cfg;

int read_config_file(void);
void write_config_file(void);
void set_config_dir(void);

#endif
