/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include<ctype.h> /* isspace() */
#include<ncurses.h>
#include<stdio.h>
#include<stdlib.h> /*  system() */
#include<string.h> /* strncmp() */
#include<time.h>
#include<unistd.h> /* chdir() */

#include "bookmarks.h"
#include "commands.h"
#include "config.h"
#include "filelist.h"
#include "fileops.h"
#include "keys.h"
#include "keys.h"
#include "menus.h"
#include "search.h"
#include "signals.h"
#include "sort.h"
#include "status.h"
#include "ui.h"
#include "utils.h"

enum
{
	COM_EXECUTE,
	COM_CD, 		
	COM_CMAP,			
	COM_COMMAND,		
	COM_DELETE, 		
	COM_DELCOMMAND,	
	COM_EDIT,				
	COM_EMPTY,
	COM_FILTER,
	COM_FILE,
	COM_FIND,
	COM_HELP,
	COM_HISTORY,
	COM_INVERT,
	COM_MAP,
	COM_MARKS,
	COM_NMAP,
	COM_NOH,
	COM_PWD,
	COM_QUIT,
	COM_SORT,
	COM_SCREEN,
	COM_SHELL,
	COM_UNMAP,
	COM_VIFM,
	COM_VMAP,
	COM_X
};

int
sort_this(const void *one, const void *two)
{
	const command_t *first = (const command_t *)one;
	const command_t *second = (const command_t *)two;

	return strcmp(first->name, second->name);
}

int
command_is_reserved(char *name)
{
	int x;
		/* The order of the commands is important as :e will match the first 
		 * command starting with e.
		 */
	char *reserved[] = {
		"!",
		"cd",
		"cmap",
		"command",
		"delete",
		"delcommand",
		"edit",
		"empty",
		"filter",
		"file",
		"find",
		"help",
		"history",
		"invert",
		"map",
		"marks",
		"nmap",
		"nohlsearch",
		"pwd",
		"quit",
		"sort",
		"screen",
		"shell",
		"unmap",
		"vifm",
		"vmap",
		"x"
		};

	for(x = 0; x < 27; x++)
	{
		if(!strncmp(reserved[x], name, strlen(name)))
				return x;
	}
	return -1;
}

int
command_is_being_used(char *command)
{
	int x;
	for(x = 0; x < cfg.command_num; x++)
	{
		if(!strcmp(command_list[x].name, command))
				return 1;
	}
	return 0;
		
}

/* The string returned needs to be freed in the calling function */
char *
expand_macros(FileView *view, char *command, char *args)
{
	char * expanded = NULL;
	int x;
	int y = 0;
	int len = 0;

	curr_stats.getting_input = 1;

	expanded = (char *)calloc(strlen(command) +1, sizeof(char *));

	for(x = 0; x < strlen(command); x++)
			if(command[x] == '%')
				break;

	strncat(expanded, command, x);
	x++;
	len = strlen(expanded);

	do
	{
		switch(command[x])
		{
			case 'a': /* user arguments */
				{
					if(!args)
						break;
					else
					{
						char arg_buf[strlen(args) +2];

						expanded = (char *)realloc(expanded, 
								strlen(expanded) + strlen(args) +3);
						snprintf(arg_buf, sizeof(arg_buf), " %s ", args);
						strcat(expanded, arg_buf);
						len = strlen(expanded);
					}
				}
				break;
			case 'f': /* current dir selected files */
				{
					if(view->selected_files)
					{
						int y = 0;
						for(y = 0; y < view->list_rows; y++)
						{
							if(view->dir_entry[y].selected)
							{
								expanded = (char *)realloc(expanded, 
										len + strlen(view->dir_entry[y].name) +5);
								/* Directory has / appended to the name this removes it. */
								if(view->dir_entry[y].type == DIRECTORY)
								{
									strcat(expanded, "\"");
									strncat(expanded, view->dir_entry[y].name, 
											strlen(view->dir_entry[y].name) -1);
									strcat(expanded, "\"");
								}
								else /* The " " are needed for filenames with spaces */
								{
									strcat(expanded, "\"");
									strcat(expanded, view->dir_entry[y].name);
									strcat(expanded, "\"");
								}
								strcat(expanded, " ");
								len = strlen(expanded);
							}
						}
					}
					else
					{
						expanded = (char *)realloc(expanded, strlen(expanded) + 
								strlen(view->dir_entry[view->list_pos].name) +3);
						if(view->dir_entry[view->list_pos].type == DIRECTORY)
						{
							strcat(expanded, "\"");
							strncat(expanded, view->dir_entry[view->list_pos].name,
									strlen(view->dir_entry[view->list_pos].name) -1);
							strcat(expanded, "\"");
						}
						else
						{
							strcat(expanded, "\"");
							strcat(expanded, view->dir_entry[view->list_pos].name);
							strcat(expanded, "\"");
						}
						len = strlen(expanded);
					}
				}
				break;
			case 'F': /* other dir selected files */
				{
					if(other_view->selected_files)
					{
						int y = 0;
						for(y = 0; y < other_view->list_rows; y++)
						{
							if(other_view->dir_entry[y].selected)
							{
								expanded = (char *)realloc(expanded, len +
										strlen(other_view->dir_entry[y].name) +
										strlen(other_view->curr_dir) + 3);
								if(expanded == NULL)
								{
									show_error_msg("Memory Error", "Unable to allocate memory");
									return NULL;
								}
								

								strcat(expanded, "\"");
								strcat(expanded, other_view->curr_dir);
								strcat(expanded, "/");

								if(other_view->dir_entry[y].type == DIRECTORY)
									strncat(expanded, other_view->dir_entry[y].name,
											strlen(other_view->dir_entry[y].name) -1);
								else
									strcat(expanded, other_view->dir_entry[y].name);
								strcat(expanded, "\"");

								strcat(expanded, " ");
								len = strlen(expanded);
							}
						}
					}
					else
					{
						expanded = (char *)realloc(expanded, len + 
								strlen(other_view->dir_entry[other_view->list_pos].name) +
								strlen(other_view->curr_dir) +4);
						if(expanded == NULL)
						{
							show_error_msg("Memory Error", "Unable to allocate memory");
							return NULL;
						}

						strcat(expanded, "\"");
						strcat(expanded, other_view->curr_dir);
						strcat(expanded, "/");

						if(other_view->dir_entry[other_view->list_pos].type == DIRECTORY)
							strncat(expanded, 
									other_view->dir_entry[other_view->list_pos].name,
									strlen(other_view->dir_entry[other_view->list_pos].name) -1);
						else
							strcat(expanded, other_view->dir_entry[other_view->list_pos].name);
						strcat(expanded, "\"");
						len = strlen(expanded);
					}
				}
				break;
			case 'd': /* current directory */
				{
					expanded = (char *)realloc(expanded, 
							len + strlen(view->curr_dir) +3);
					strcat(expanded, "\"");
					strcat(expanded, view->curr_dir);
					strcat(expanded, "\"");
					len = strlen(expanded);
				}
				break;
			case 'D': /* other directory */
				{
					expanded = (char *)realloc(expanded, 
							len + strlen(other_view->curr_dir) +3);
					if(!expanded)
					{
						show_error_msg("Memory Error", "Unable to allocate memory");
						return NULL;
					}
					strcat(expanded, "\"");
					strcat(expanded, other_view->curr_dir);
					strcat(expanded, "\"");
					len = strlen(expanded);
				}
				break;
			default:
				break;
		}
		x++;
		y = x;

		for(; x < strlen(command); x++)
		{
				if(command[x] == '%')
					break;
		}
		expanded = (char *)realloc(expanded, len + strlen(command) +1); 
		strncat(expanded, command + y, x - y);
		len = strlen(expanded);
		x++;
		}while(x < strlen(command));

		curr_stats.getting_input = 0;
	
	return expanded;
}

int
is_user_command(char *command)
{
	char buf[strlen(command) +1]; 
	char *com;
	char *ptr;
	int x;

	com = strcpy(buf, command);

	if((ptr = strchr(com, ' ')) != NULL)
		*ptr = '\0';

	for(x = 0; x < cfg.command_num; x++)
	{
		if(!strcmp(com, command_list[x].name))
		{
			return x;
		}
	}
	return -1;
}

void
remove_command(char *name)
{
	char *ptr = NULL;
	char *s = name;
	int x;
	int found = 0;

	if((ptr = strchr(s, ' ')) != NULL)
		*ptr = '\0';

	if(command_is_reserved(s) > -1)
	{
		show_error_msg(" Trying to delete a reserved Command ", s);
		return;
	}

	for(x = 0; x < cfg.command_num; x++)
	{
		if(!strcmp(s, command_list[x].name))
		{
			found = 1;
			break;
		}
	}
	if(found)
	{
		cfg.command_num--;
		while(x < cfg.command_num)
		{
			command_list[x].name = (char *)realloc(command_list[x].name, 
					strlen(command_list[x +1].name +1));
			strcpy(command_list[x].name, command_list[x +1].name);
			command_list[x].action = (char *)realloc(command_list[x].action, 
					strlen(command_list[x +1].action +1));
			strcpy(command_list[x].action, command_list[x +1].action);
			x++;
		}
		if(command_list[x].name)
			my_free(command_list[x].name);
		if(command_list[x].action)
			my_free(command_list[x].action);
	}
	else
		show_error_msg(" Command Not Found ", s);
}

void
add_command(char *name, char *action)
{
	if(command_is_reserved(name) > -1)
			return;
	if(isdigit(*name))
	{
		show_error_msg(" Invalid Command Name ", 
				"Commands cannot start with a number.");
		return;
	}

	if(command_is_being_used(name))
	{
		return;
	}

	command_list = (command_t *)realloc(command_list, 
			(cfg.command_num +1) * sizeof(command_t));

	command_list[cfg.command_num].name = (char *)malloc(strlen(name) +1);
	strcpy(command_list[cfg.command_num].name, name);
	command_list[cfg.command_num].action = (char *)malloc(strlen(action) +1);
	strcpy(command_list[cfg.command_num].action, action);
	cfg.command_num++;
}

static void
set_user_command(char * command, int overwrite)
{
	char buf[80];
	char *ptr = NULL;
	char *com_name = NULL;

	while(isspace(*command))
		command++;

	com_name = command;

	if((ptr = strchr(command, ' ')) == NULL)
			return;

	*ptr = '\0';
	ptr++;

	while(isspace(*ptr))
		ptr++;

	if((strlen(ptr) < 1))
	{
		show_error_msg(" To set a Command Use: ", 
				":com command_name command_action");
		return;
	}
	if(command_is_reserved(com_name) > -1)
	{
		snprintf(buf, sizeof(buf), "%s is a reserved command name", com_name);
		show_error_msg("", buf);
		return;
	}
	if(command_is_being_used(com_name))
	{
		if(overwrite)
		{
			remove_command(com_name);
			add_command(com_name, ptr);
		}
		else
		{
			snprintf(buf, sizeof(buf), "%s is already set. Use :com! to overwrite.",
					com_name);
			show_error_msg("", buf);
		}
	}
	else
	{
		add_command(com_name, ptr);
	}
}

void
shellout(char *command, int pause)
{
	char buf[1024];


	if(command != NULL)
	{
		if(cfg.use_screen)
		{
			char *title = strstr(command, cfg.vi_command);

			if(title != NULL)
			{
				if(pause)
					snprintf(buf, sizeof(buf), "screen -t '%s' sh -c 'pauseme %s'", 
							title + strlen(cfg.vi_command) +1, command);
				else
					snprintf(buf, sizeof(buf), "screen -t '%s' sh -c '%s'", 
							title + strlen(cfg.vi_command) +1, command);
			}
			else
			{
				if(pause)
					snprintf(buf, sizeof(buf), "screen -t '%s' sh -c 'pauseme %s'", 
							command, command);
				else
					snprintf(buf, sizeof(buf), "screen -t '%s' sh -c '%s'", command, command);
			}
		}
		else
		{
			if(pause)
				snprintf(buf, sizeof(buf), "sh -c 'pauseme %s'", command);
			else
				snprintf(buf, sizeof(buf), "sh -c '%s'", command);
		}
	}
	else
	{
		if(cfg.use_screen)
			snprintf(buf, sizeof(buf), "screen");
		else
		{
			char *sh = getenv("SHELL");
			snprintf(buf, sizeof(buf), "%s", sh);
		}
	}

	def_prog_mode();
	endwin();

	my_system("clear");
	my_system(buf);


	/* The window size has changed 
	if(curr_stats.need_redraw)
		redraw_window();
	else
		update_all_windows();

	def_prog_mode();
	endwin();
	refresh();
	*/

	/* There is a problem with using the screen program and 
	 * catching all the SIGWICH signals.  So just redraw the window.
	 */
	redraw_window();

	curs_set(0);
}


/* This is still a mess.  But the basic functionality is there. */
int
execute_command(FileView *view, char *command)
{
	char *com_name = NULL;
	char *args = NULL;
	int count = 0;
	int startrange = 0;
	int endrange = 0;
	int background = 0;
	int i = 0;
	int a = 0;
	int x = -1;
	int save_msg = 0;
	int builtin = -1;

	while(isspace(*command))
		i++;
	while(isspace(command[strlen(command) -1]))
			command[strlen(command) -1] = '\0';

	/*
	 * First check for a count or a range
	 * This should be changed to include the rest of the range 
	 * characters [/?\/\?\&]
	 */
	if(command[i] == '\'')
	{
		char mark;
		i++;
		mark = command[i];
		startrange = check_mark_directory(view, mark);
		if(startrange < 0)
		{
			show_error_msg("Invalid mark in range", "Trying to use an invalid mark.");
			return 1;
		}
		i++;
	}
	else if(command[i] == '$')
	{
		count = view->list_rows;
		if(strlen(command) == strlen("$"))
		{
			moveto_list_pos(view, count -1);
			return 0;
		}
		i++;

	}
	else if(command[i] == '.')
	{
		startrange = view->list_pos;
		i++;
	}
	else if(command[i] == '%')
	{
		startrange = 1;
		endrange = view->list_rows;
		i++;
	}
	else if(isdigit(command[i]))
	{
		char num_buf[strlen(command)];
		int z = 0;
		while(isdigit(command[i]))
		{
			num_buf[z] = command[i];
				i++;
				z++;
		}
		num_buf[z] = '\0';
		startrange = atoi(num_buf);

		/* The command is just a number */
		if(strlen(num_buf) == strlen(command))
		{
			moveto_list_pos(view, startrange - 1);
			return 0;
		}
	}
	while(isspace(command[i]))
			i++;

	/* Check for second number of range. */
	if(command[i] == ',')
	{
		i++;

		if(command[i] == '\'')
		{
			char mark;
			i++;
			mark = command[i];
			endrange = check_mark_directory(view, mark);
			if(endrange < 0)
			{
				show_error_msg("Invalid mark in range", 
						"Trying to use an invalid mark.");
				return 1;
			}
			i++;
		}
		else if(command[i] == '$')
		{
			endrange = view->list_rows - 1;
			i++;
		}
		else if(command[i] == '.')
		{
			endrange = view->list_pos;
			i++;
		}
		else if(isdigit(command[i]))
		{
			char num_buf[strlen(command)];
			int z = 0;
			while(isdigit(command[i]))
			{
				num_buf[z] = command[i];
					i++;
					z++;
			}
			num_buf[z] = '\0';
			endrange = atoi(num_buf);
		}
		else
			i--;
	}
	else if(!endrange)/* Only one number is given for the range */
	{
		endrange = startrange;
		startrange = -1;
	}



	while(isspace(command[i]))
		i++;



	/* Second - Get the actual command name */
	com_name = strdup(command +i);

	/* The builtin commands do not contain numbers and ! is only used at the
	 * end of the command name.
	 */
	while(com_name[a] != ' ' && a < strlen(com_name) && !isdigit(com_name[a])
			&& com_name[a] != '!')
		a++;
	com_name[a] = '\0';

	while(isspace(command[i + strlen(com_name)]))
		i++;

	if((strlen(com_name) +i) < strlen(command))
		args = strdup(command + i + strlen(com_name));

	/* Third - Check if it is a builtin commands */
	if((builtin = command_is_reserved(com_name)) > -1)
	{
		/* Check whether to run command in background */
		if(command[strlen(command) -1] == '&' && command[strlen(command) -2] == ' ')
		{
			background = 1;
			/*command[strlen(command) -2] = '\0'; */
		}
		switch(builtin)
		{
			case COM_EXECUTE:
				{
					int pause = 0;
					char *com = NULL;

					if(strchr(command, '%') != NULL)
						com = expand_macros(view, command, NULL);
					else
						com = strdup(command);

					i = 1;
					if(com[i] == '!')
					{
						/* repeat last command or pauseme */
						pause = 1;
						i++;
					}
					while(isspace(com[i]))
							i++;
					if((strlen(com + i) > 0) && background)
						run_background_process(com + i);
					else if(strlen(com + i) > 0)
					{
						shellout(com +i, pause);
					}
					if(!background)
						my_free(com);
				}
				break;
			case COM_CD:
				{
					char dir[PATH_MAX];

					if(args)
					{
						if(args[0] == '/')
						{
							change_directory(view, args);
							load_dir_list(view, 0);
							moveto_list_pos(view, view->list_pos);
						}
						else if(*args == '~')
						{
							snprintf(dir, sizeof(dir), "%s%s", getenv("HOME"), args +1);
							change_directory(view, dir);
							load_dir_list(view, 0);
							moveto_list_pos(view, view->list_pos);
						}
						else
						{
							snprintf(dir, sizeof(dir), "%s/%s", view->curr_dir, args);
							change_directory(view, dir);
							load_dir_list(view, 0);
							moveto_list_pos(view, view->list_pos);
						}
					}
					else
					{
						change_directory(view, getenv("HOME"));
						load_dir_list(view, 0);
						moveto_list_pos(view, view->list_pos);
					}
				}
				break;
			case COM_CMAP:
				break;
			case COM_COMMAND:
				{
					if(args)
					{
						if(*args == '!')
						{
							x = 1;
							while(isspace(args[x]))
								x++;
							set_user_command(args + x, 1);
						}
						else
							set_user_command(args, 0);
					}
					else
						show_commands_menu(view);
				}
				break;
			case COM_DELETE:
				{
					int x;
					int y = 0;

					/* Both a starting range and an ending range are given. */
					if(startrange > -1)
					{
						if(endrange < startrange)
						{
							show_error_msg(" Command Error ", "Backward range given.");
							return 1;
						}

						for(x = 0; x < view->list_rows; x++)
							view->dir_entry[x].selected = 0;

						for(x = startrange; x <= endrange; x++)
						{
							view->dir_entry[x].selected = 1;
							y++;
						}
						view->selected_files = y;
					}
					/* A count is given */
					else if(args)
					{
						count = atoi(args);
						if(!count)
							count = 1;

						/* A one digit range with a count. :4d5 */
						if(endrange)
						{
							y = 0;
							for(x = 0; x < view->list_rows; x++)
								view->dir_entry[x].selected = 0;

							for(x = endrange; x < view->list_rows; x++)
							{
								if(count == y)
									break;
								view->dir_entry[x].selected = 1;
								y++;

							}
							view->selected_files = y;
						}
						/* Just a count is given. */
						else
						{
							y = 0;

							for(x = 0; x < view->list_rows; x++)
								view->dir_entry[x].selected = 0;

							for(x = view->list_pos; x < view->list_rows; x++)
							{
								if(count == y )
									break;

								view->dir_entry[x].selected = 1;
								y++;
							}
							view->selected_files = y;

						}
					}
					delete_file(view);
				}
				break;
			case COM_DELCOMMAND:
				{
					if(args)
					{
						remove_command(args);
						write_config_file();
					}
				}
				break;
			case COM_EDIT:
				{
					if(!view->selected_files)
					{
						char buf[PATH_MAX];
						if(view->dir_entry[view->list_pos].name != NULL)
						{
							snprintf(buf, sizeof(buf), "%s \"%s/%s\"", cfg.vi_command, 
									view->curr_dir, view->dir_entry[view->list_pos].name); 
							shellout(buf, 0);
						}
					}
					else
					{
						int i;
						char name[PATH_MAX];
						char *buf = NULL;
						if((buf = (char *)malloc(strlen(cfg.vi_command) + 2)) == NULL)
						{
							show_error_msg("Unable to allocate enough memory", 
									"Cannot load file");
							return 0;
						}
						snprintf(buf, sizeof(buf), "%s ", cfg.vi_command);
						
						for(i = 0; i < view->list_rows; i++)
						{
							if(view->dir_entry[i].selected)
							{

								snprintf(name, sizeof(name), " \"%s\"",
										view->dir_entry[i].name);
								if((buf = (char *)realloc(buf, strlen(buf) +
										strlen(name +1))) == NULL)
								{
									show_error_msg("Unable to allocate enough memory", 
											"Cannot load file.");
									return 0;
								}
								strcat(buf, name);
							}
						}
						shellout(buf, 0);
					}
				}
				break;
			case COM_EMPTY:
				{
					char buf[256];
					snprintf(buf, sizeof(buf), "%s/Trash", cfg.config_dir);
					if(chdir(buf))
						return 0;

					run_background_process("rm -fr * .[!.]*");
					chdir(view->curr_dir);
				}
				break;
			case COM_FILTER:
				{
					if(args)
					{
						view->invert = 1;
						view->filename_filter = (char *)realloc(view->filename_filter,
							strlen(args) +2);
						snprintf(view->filename_filter, strlen(args) +1, 
								"%s", args); 
						load_dir_list(view, 1);
						moveto_list_pos(view, 0);
					}
					else
						show_error_msg(" Command Error ", 
								"The :filter command requires an argument - :filter pattern");
				}
				break;
			case COM_FILE:
				show_filetypes_menu(view);
				break;
			case COM_FIND:
				show_error_msg(" Find Command ", 
						"The :find command is not yet implemented.");
				break;
			case COM_HELP:
				{
					char help_file[PATH_MAX];

					if(cfg.use_vim_help)
					{
						if(args)
						{
							snprintf(help_file, sizeof(help_file), 
									"%s -c \"help %s\" -c only", cfg.vi_command, args);
							/*
							snprintf(help_file, sizeof(help_file), "%s %s/vifm-%.1f.help.txt", 
									cfg.vi_command, cfg.config_dir, VERSION);
									*/
							shellout(help_file, 0);

						}
						else 
						{
							snprintf(help_file, sizeof(help_file), 
									"%s -c \"help vifm\" -c only", cfg.vi_command);
							shellout(help_file, 0);
						}
					}
					else
					{

						snprintf(help_file, sizeof(help_file), "%s %s/vifm-%.1f.help.txt",
								cfg.vi_command, cfg.config_dir, VERSION);
						shellout(help_file, 0);
					}
				}
				break;
			case COM_HISTORY:
				show_history_menu(view);
				break;
			case COM_INVERT:
				{
					if(view->invert)
						view->invert = 0;
					else
						view->invert = 1;
					load_dir_list(view, 1);
					moveto_list_pos(view, 0);
				}
				break;
			case COM_MAP:
				break;
			case COM_MARKS:
				show_bookmarks_menu(view);
				break;
			case COM_NMAP:
				break;
			case COM_NOH:
				{
					if(view->selected_files)
					{
						int y = 0;
						for(y = 0; y < view->list_rows; y++)
						{
							if(view->dir_entry[y].selected)
								view->dir_entry[y].selected = 0;
						}
						draw_dir_list(view, view->top_line, view->list_pos);
						moveto_list_pos(view, view->list_pos);
					}
				}
				break;
			case COM_PWD:
				status_bar_message(view->curr_dir);
				save_msg = 1;
				break;
			case COM_X:
			case COM_QUIT:
				{
					if(cfg.vim_filter)
					{
						char buf[256];
						FILE *fp;

						snprintf(buf, sizeof(buf), "%s/vimfiles", cfg.config_dir);
						fp = fopen(buf, "w");
						endwin();
						fprintf(fp, "NULL");
						fclose(fp);
						exit(0);
					}
					endwin();
					write_config_file();
					clear_term_title();
					system("clear");
					exit(0);
				}
				break;
			case COM_SORT:
				show_sort_menu(view);
				break;
			case COM_SCREEN:
				{
					if(cfg.use_screen)
						cfg.use_screen = 0;
					else
						cfg.use_screen = 1;
				}
				break;
			case COM_SHELL:
				shellout(NULL, 0);
				break;
			case COM_UNMAP:
				break;
			case COM_VIFM:
				show_error_msg(" I haven't gotten here yet ",
							"Sorry this is not implemented");
				break;
			case COM_VMAP:
				break;
			default:
				{
				char buf[48];
				snprintf(buf, sizeof(buf), "Builtin is %d", builtin);
				show_error_msg("Internal Error", buf);
				}
				break;
		}

		my_free(com_name);
		my_free(args);
		if(view->selected_files)
			view->selected_files = 0;
		return save_msg;
	}
	/* Fourth - The command is not builtin so check the user commands. */
	else if((x = is_user_command(com_name)) > -1)
	{
		char *expanded_com = NULL;

		if(strchr(command_list[x].action, '%') != NULL)
			expanded_com = expand_macros(view, command_list[x].action, args);
		else
			expanded_com = strdup(command_list[x].action);

		while(isspace(expanded_com[strlen(expanded_com) -1]))
			expanded_com[strlen(expanded_com) -1] = '\0';

		if(expanded_com[strlen(expanded_com)-1] == '&' 
				&& expanded_com[strlen(expanded_com) -2] == ' ')
		{
			background = 1;

		}

		if(!strncmp(expanded_com, "filter ", 7)) 
		{
			view->invert = 1;
			view->filename_filter = (char *)realloc(view->filename_filter,
					strlen(strchr(expanded_com, ' ')) +1);
			snprintf(view->filename_filter, 
					strlen(strchr(expanded_com, ' ')) +1, "%s", 
					strchr(expanded_com, ' ') +1); 

			load_dir_list(view, 1);
			moveto_list_pos(view, 0);
		}
		else if(!strncmp(expanded_com, "!", 1))
		{
			char buf[strlen(expanded_com) + 1];
			char *tmp = strcpy(buf, expanded_com);
			int pause = 0;
			tmp++;
			if(*tmp == '!')
			{
				pause = 1;
				tmp++;
			}
			while(isspace(*tmp))
					tmp++;

			if((strlen(tmp) > 0) && background)
				run_background_process(tmp);
			else if(strlen(tmp) > 0)
				shellout(tmp, pause);
		}
		else if(!strncmp(expanded_com, "/", 1))
		{
			strncpy(view->regexp, expanded_com +1, sizeof(view->regexp));
			return find_pattern(view, view->regexp);
		}
		else if(background)
		{
			char buf[strlen(expanded_com) + 1];
			char *tmp = strcpy(buf, expanded_com);
			run_background_process(tmp);
		}
		else
			shellout(expanded_com, 0);

		if(!background)
			my_free(expanded_com);
			my_free(com_name);
			my_free(args);
		if(view->selected_files)
		{
			free_selected_file_array(view);
			view->selected_files = 0;
			load_dir_list(view, 1);
		}
		return 0;
	}
	else
	{
		my_free(com_name);
		my_free(args);
		status_bar_message("Command is not set");
		save_msg = 1;
		return save_msg;
	}
}

int
get_command(FileView *view, int type, char *string)
{
	int key;
	int pos;
	int index = 0;
	int done = 0;
	int abort = 0;
	int len = 0;
	char buf[64];

	if(type == GET_VISUAL_COMMAND)
		pos = 6;
	else
		pos = 1;

	curs_set(1);
	werase(status_bar);

	if(type == GET_COMMAND)
		mvwaddch(status_bar, 0, 0, ':');
	else if (type == GET_SEARCH_PATTERN)
		mvwaddch(status_bar, 0, 0, '/');
	else if (type == MAPPED_COMMAND || type == MAPPED_SEARCH)
	{
		snprintf(buf, sizeof(buf), string +1);
		mvwaddstr(status_bar, 0, 0, string);
		pos = strlen(string);
		index = pos -1;
		len = index;
	}
	else if(type == GET_VISUAL_COMMAND)
		mvwaddstr(status_bar, 0, 0, ":'<,'>");

  while(!done)
  {
	  if(curr_stats.freeze)
		  continue;
	  curs_set(1);
		flushinp();
		curr_stats.getting_input = 1;
		key = wgetch(status_bar);

		switch(key)
		{
			case 27: /* ascii Escape */
			case 3: /* ascii Ctrl C */
				done = 1;
				abort = 1;
				break;
			case 13: /* ascii Return */
				done = 1;
				break;
			/* This needs to be changed to a value that is read from 
			 * the termcap file.
			 */
			case 0x7f: /* This is the one that works on my machine */
			case 8: /* ascii Backspace  ascii Ctrl H */
			case KEY_BACKSPACE: /* ncurses BACKSPACE KEY */
				{
					pos--;
					index--;
					len--;
					if(type == GET_VISUAL_COMMAND)
					{
						if(pos < 6)
							pos = 6;
						if(index < 0)
							index = 0;
					}
					else
					{
						if(pos < 1)
							pos = 1;
						if(index < 0)
							index = 0;
					}
					mvwdelch(status_bar, 0, pos);
					buf[index] = '\0';
				}
				break;
			default:
				if(key > 31 && key < 127) 
				{
					mvwaddch(status_bar, 0, pos, key);
					buf[index] = key;
					index++;
					buf[index] = '\0';
					if(index > 62)
					{
						abort = 1;
						done = 1;
					}

					pos++;
					len++;
				}
				break;
		}
		curr_stats.getting_input = 0;
  }
	curs_set(0);
	werase(status_bar);
	wnoutrefresh(status_bar);

	if(abort)
		return 0;

	if(type == GET_COMMAND || type == MAPPED_COMMAND || type == GET_VISUAL_COMMAND)
		return execute_command(view, buf);
	else if(type == GET_SEARCH_PATTERN || type == MAPPED_SEARCH)
	{
		if(len < 2)
			return find_pattern(view, view->regexp);
		else
		{
			strncpy(view->regexp, buf, sizeof(view->regexp));
			return find_pattern(view, buf);
		}

	}

	return 0;
}

