/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "commands.h"
#include "config.h"
#include "filelist.h"
#include "fileops.h"
#include "visual.h"
#include "status.h"

int
visual_key_cb(FileView *view)
{
	int done = 0;
	int abort = 0;
	int count = 0;
	int start_pos = view->list_pos;
	char buf[36];
	int save_msg = 0;

	while(!done)
	{
		int key;
		curr_stats.getting_input = 1;
		key = wgetch(view->win);
		curr_stats.getting_input = 0;

		switch(key)
		{
			case 13: /* ascii Return */
				done = 1;
				break;
			case 27: /* ascii Escape */
			case 3: /* ascii Ctrl C */
				abort = 1;
				break;
			case ':':
				{
					get_command(view, GET_VISUAL_COMMAND, NULL);
					/*abort = 1;*/
					return 0;
				}
				break;
			case 'd':
				delete_file(view);
				done = 1;
				break;
			case KEY_DOWN:
			case 'j':
			{
				view->list_pos++;

				if(view->list_pos >= view->list_rows)
					 ;
				else if(view->list_pos > start_pos)
				{
					view->dir_entry[view->list_pos].selected = 1;
					view->selected_files++;
				}
				else if(view->list_pos == start_pos)
				{
					view->dir_entry[view->list_pos].selected = 1;
					view->dir_entry[view->list_pos -1].selected = 0;
					view->selected_files = 1;
					
				}
				else
				{
					view->dir_entry[view->list_pos -1].selected = 0;
					view->selected_files--;
				}
			}
				break;
			case KEY_UP:
			case 'k':
			{
				view->list_pos--;
				if(view->list_pos < 0)
					;
				else if(view->list_pos < start_pos)
				{
					view->dir_entry[view->list_pos].selected = 1;
					view->selected_files++;
				}
				else if(view->list_pos == start_pos)
				{
					view->dir_entry[view->list_pos].selected = 1;
					view->dir_entry[view->list_pos +1].selected = 0;
					view->selected_files = 1;
				}
				else
				{
					view->dir_entry[view->list_pos +1].selected = 0;
					view->selected_files--;
				}
			}
				break;
				/*
			case 'v':
				done = 1;
				break;
				*/
			case 'y':
				{
					get_all_selected_files(view);
					yank_selected_files(view);
					count = view->selected_files;
					free_selected_file_array(view);
					snprintf(buf, sizeof(buf), " %d files yanked", count);
					save_msg = 1;
				}
				abort = 1;
				break;
			default:
			break;
		}
		if(abort)
		{
			int x;
			if(view->selected_files)
			{
				for(x = 0; x < view->list_rows; x++)
					view->dir_entry[x].selected = 0;

				view->selected_files = 0;
			}
			done = 1;
		}

		draw_dir_list(view, view->top_line, view->list_pos);
		moveto_list_pos(view, view->list_pos);
		wattron(view->win, COLOR_PAIR(CURR_LINE_COLOR) | A_BOLD);
		mvwaddstr(view->win, view->curr_line, 0, "=>");
		wattroff(view->win, COLOR_PAIR(CURR_LINE_COLOR));
		wmove(view->win, view->curr_line, 0);
		update_pos_window(view);
		if(count)
		{
			status_bar_message(buf);
			save_msg = 1;
		}
	}
	return save_msg;
}

int
start_visual_mode(FileView *view)
{
	int x;
	write_stat_win("  --VISUAL--");
	for(x = 0; x < view->list_rows; x++)
		view->dir_entry[x].selected = 0;

	view->selected_files = 1;
	view->dir_entry[view->list_pos].selected = 1;
	draw_dir_list(view, view->top_line, view->list_pos);
	moveto_list_pos(view, view->list_pos);
	wattron(view->win, COLOR_PAIR(CURR_LINE_COLOR) | A_BOLD);
	mvwaddstr(view->win, view->curr_line, 0, "=>");
	wattroff(view->win, COLOR_PAIR(CURR_LINE_COLOR));
	wmove(view->win, view->curr_line, 0);

	return visual_key_cb(view);
}
