// ****************************************************************************
// *                                                                          *
// *                      Velena Source Code V1.0                             *
// *                   Written by Giuliano Bertoletti                         *
// *       Based on the knowledged approach of Louis Victor Allis             *
// *   Copyright (C) 1996-97 by Giuliano Bertoletti & GBE 32241 Software PR   *
// *                                                                          *
// ****************************************************************************

// Portable engine version.
// read the README file for further informations.

// ==========================================================================


#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "connect4.h"
#include "pnsearch.h"
#include "proto.h"

long seed=0;

// #define MAGIC_NUM1 ((unsigned int)3440802871L)
// #define MAGIC_NUM2 ((unsigned int)3792808219L)
//
// unsigned long pseudo32(unsigned long *seed)
//   {
//   if(*seed&1) *seed=(*seed>>1)^MAGIC_NUM1;
//   else *seed=(*seed>>1);
//
//   return *seed;
//   }


/* ========================================================================= */

// This section is taken from Numerical Recipes in C in order to implement
// a better random number generator.

void randomize()
    {
    seed=time(NULL);
    }

#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)
#define MASK 123459876

float ran1(long *idum)
{
	int j;
	long k;
	static long iy=0;
	static long iv[NTAB];
	float temp;

	if (*idum <= 0 || !iy) {
		if (-(*idum) < 1) *idum=1;
		else *idum = -(*idum);
		for (j=NTAB+7;j>=0;j--) {
			k=(*idum)/IQ;
			*idum=IA*(*idum-k*IQ)-IR*k;
			if (*idum < 0) *idum += IM;
			if (j < NTAB) iv[j] = *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ;
	*idum=IA*(*idum-k*IQ)-IR*k;
	if (*idum < 0) *idum += IM;
	j=iy/NDIV;
	iy=iv[j];
	iv[j] = *idum;
	if ((temp=AM*iy) > RNMX) return RNMX;
	else return temp;
}
#undef IA
#undef IM
#undef AM
#undef IQ
#undef IR
#undef NTAB
#undef NDIV
#undef EPS
#undef RNMX

int my_random(unsigned short maxval)
    {
    return (int)(ran1(&seed)*maxval);
    }


