#
# Copyright (c) 1993-1995 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the Computer Systems
#	Engineering Group at Lawrence Berkeley Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

global font
set font(helvetica10) {
	normal--*-100-75-75-*-*-*-*
	normal--10-*-*-*-*-*-*-*
	normal--11-*-*-*-*-*-*-*
	normal--*-100-*-*-*-*-*-*
	normal--*-*-*-*-*-*-*-*
}
set font(helvetica12) {
	normal--*-120-75-75-*-*-*-*
	normal--12-*-*-*-*-*-*-*
	normal--14-*-*-*-*-*-*-*
	normal--*-120-*-*-*-*-*-*
	normal--*-*-*-*-*-*-*-*
}
set font(helvetica14) {
	normal--*-140-75-75-*-*-*-*
	normal--14-*-*-*-*-*-*-*
	normal--*-140-*-*-*-*-*-*
	normal--*-*-*-*-*-*-*-*
}
set font(times14) {
	normal--*-140-75-75-*-*-*-*
	normal--14-*-*-*-*-*-*-*
	normal--*-140-*-*-*-*-*-*
	normal--*-*-*-*-*-*-*-*
}

proc search_font { foundry style weight points slant } {
	global font
	foreach f $font($style$points) {
		set fname -$foundry-$style-$weight-$slant-$f
		if [havefont $fname] {
			return $fname
		}
	}
	puts stderr "vat: can't find $weight $style font (using fixed)"
	if ![havefont fixed] {
		puts stderr "vat: can't find fixed font"
		exit 1
	}
	return $f
}

proc init_fonts {} {
	set foundry [option get . foundry Vat]

	set helv10  [search_font $foundry helvetica medium 10 r]
	set helv10b [search_font $foundry helvetica bold 10 r]
	set helv10o [search_font $foundry helvetica bold 10 o]
	set helv12b [search_font $foundry helvetica bold 12 r]
	set helv14b [search_font $foundry helvetica bold 14 r]
	set times14 [search_font $foundry times medium 14 r]

	option add *Font $helv12b startupFile
	option add Vat.medfont $helv12b startupFile
	option add Vat.smallfont $helv10b startupFile
	option add Vat.helpFont $times14 startupFile
	option add Vat.entryFont $helv10 startupFile
	option add Vat.audioFont $helv10 startupFile
	option add Vat.ctrlTitleFont $helv12b startupFile
	option add Vat.ctrlFont $helv10b startupFile
	option add Vat.noAudioFont $helv10o startupFile
	option add Vat.siteFont $helv12b startupFile

	option add *Font $helv14b startupFile
	option add *Radiobutton.font $helv12b 100
}

proc init_resources {} {
	#
	# use 2 pixels of padding by default
	#
	option add *padX 2
	option add *padY 2
	#
	# don't put tearoffs in pull-down menus
	#
	option add *tearOff 0

	#
	# Make the color scheme a little darker than the default gray.
	# Go through all the palette resources and raise the option data
	# base priority from widgetDefault to 61 so that user's X resources
	# won't override these.
	#
	tk_setPalette gray80
	foreach option [array names tkPalette] {
		option add *$option $tkPalette($option) 61
	}

	option add *highlightThickness 0

	option add *Radiobutton.relief flat startupFile
	option add *Checkbutton.anchor w startupFile
	option add *Radiobutton.anchor w startupFile
	option add *Radiobutton.relief flat startupFile
	option add *Scale.sliderForeground gray66 startupFile
	option add *Scale.activeForeground gray80 startupFile
	option add *Scale.background gray70 startupFile

	# vat widgets
	option add Vat.disabledColor gray50 startupFile
	option add Vat.highlightColor gray95 startupFile
	option add Vat.infoHighlightColor LightYellow2 startupFile
	option add *VatVU.foreground black startupFile
	option add *VatVU.peak gray50 startupFile
	option add *VatVU.hot firebrick1 startupFile
	option add *VatVU.hotLevel 90 startupFile

	if { [winfo depth .] == 1 } {
		# make mono look better
		option add *selectBackground black startupFile
		option add *selectForeground white startupFile
		option add *activeForeground black startupFile
		option add *VatVU.background white startupFile
		option add *VatVU.hot gray50 startupFile
		option add Vat.highlightColor white startupFile
	}

	option add Vat.iconPrefix "" startupFile

	# colors
	option add Vat.titleReleased "gray95" startupFile
	option add Vat.titleHave "#aaaaaa" startupFile
	option add Vat.titlePinned "black" startupFile

	option add Vat.mikeGain "32" startupFile
	option add Vat.lineinGain "180" startupFile
	option add Vat.linein2Gain "180" startupFile
	option add Vat.linein3Gain "180" startupFile
	option add Vat.speakerGain "180" startupFile
	option add Vat.jackGain "180" startupFile
	option add Vat.lineoutGain "180" startupFile
	option add Vat.lineout2Gain "180" startupFile

	option add Vat.speakerMute "false" startupFile
	option add Vat.mikeMute "true" startupFile

	option add Vat.speakerMode "NetMutesMike" startupFile
	option add Vat.jackMode "FullDuplex" startupFile
	option add Vat.lineoutMode "NetMutesMike" startupFile
	option add Vat.lineout2Mode "NetMutesMike" startupFile
	option add Vat.maxPlayout "6" startupFile
	option add Vat.lectureMode "false" startupFile
	option add Vat.useNames "false" startupFile
	option add Vat.defaultTTL "16" startupFile

	option add Vat.filterLength "256" startupFile
	option add Vat.filterMaxTaps "35" startupFile

	option add Vat.meterDisable "false" startupFile
	option add Vat.meterStyle "discrete" startupFile
	option add Vat.inputPort "Mike" startupFile
	option add Vat.outputPort "Speaker" startupFile
	option add Vat.audioFormat "pcm2" startupFile
	option add Vat.mikeAGC "false" startupFile
	option add Vat.mikeAGCLevel "0" startupFile
	option add Vat.speakerAGC "false" startupFile
	option add Vat.speakerAGCLevel "0" startupFile

	option add Vat.defaultPriority "100" startupFile
	option add Vat.idleDropTime "20" startupFile
	option add Vat.autoRaise "true" startupFile
	option add Vat.externalEchoCancel "false" startupFile
	option add Vat.silenceThresh "20" startupFile
	option add Vat.talkThresh "0" startupFile
	option add Vat.echoThresh "70" startupFile
	option add Vat.echoSuppressTime "400" startupFile
	option add Vat.keepSites "false" startupFile
	option add Vat.muteNewSites "false" startupFile
	option add Vat.sortSites "true" startupFile
	option add Vat.compactSites "true" startupFile
	option add Vat.compressionSlope "0.0625" startupFile
	option add Vat.key "" startupFile
	option add Vat.afDevice "-1" startupFile
	option add Vat.afBlocks "2" startupFile
	option add Vat.afSoftOuputGain "0" startupFile
	option add Vat.afSoftInputGain "0" startupFile
	option add Vat.siteDropTime "300" startupFile
	option add Vat.audioFileName "/dev/audio" startupFile
	option add Vat.statTimeConst 0.1 startupFile
	option add Vat.statsFilter 0.0625 startupFile

	option add Vat.mtu 1024 startupFile
	option add Vat.network ip startupFile
	option add Vat.maxbw -1 startupFile
	option add Vat.bandwidth 128 startupFile
	option add Vat.confBusChannel 0 startupFile
	option add Vat.sessionType vat startupFile
	
	option add Vat.foundry adobe startupFile
	option add Vat.recvOnly false startupFile

	init_fonts

	option add Vat.suppressUserName true startupFile

	# list of sdes items to display in info window
	option add Vat.sdesList "cname tool email note"

	catch "option readfile ~/.RTPdefaults startupFile"
}
