.\"
.\" urlget.man,v 1.8 2004/02/15 20:56:35 kim Exp
.\"
.TH URLGET 1 "14 October 2000" "TAC 1.3"
.SH NAME 
.B urlget
- Retrieve the specified URL
.SH SYNOPSIS
.B urlget
.RB [ \-DPhop ]
.I URL
.RI [ name = value ]...
.br
.SH DESCRIPTION
.B Urlget
retrieves the URL specified on the command line and outputs
it to the standard output.  It uses the HTTP 1.0 \fIGET\fR
query by default.
.SH OPTIONS
.TP 5
.B \-h
Uses the \fIHEAD\fR query to only get available header information
for the specified URL.
.TP
.B \-o
Uses \fIold\fR GET query (HTTP/0.9), useful for really old servers.
.TP
.B \-p
Sends a \fIPOST\fR command rather than a GET. In this case, arguments
after the URL are assumed to be name=value pairs to be used as data
for the POST command.  Any non-alphanumeric characters after the '='
in the argument are escaped.
.TP
.B \-D
Debugging -- shows the command (and post data, if any) that it would
send, but doesn't actually open a connection.
.TP
.B \-P
Do not use a proxy.  By default proxies defined in the environment
will be used.
.TP
.B \-R
Force proxies to reload (revalidate) the requested URL.
.SH ENVIRONMENT
.TP 5
.B http_proxy
If set it should be an http URL for the proxy service.  E.g.
.B http://proxy:3128/
declares that the proxy lives on host
.I proxy
on port
.IR 3128 .
.SH EXAMPLES
urlget http://www.ibiblio.org/Dave/Dr-Fun/latest.jpg | xv
.SH SEE ALSO
.IR Mosaic (1X),
.IR lynx (1),
.IR netscape (1X),
.IR xv (1X)
.SH DIAGNOSTICS
The following exit values are returned.
.TP 5
0
Successful completion.
.PD 0
.TP
1
Invalid URL, URL missing, or other usage error.
.TP
2
Unknown host.
.TP
3
Cannot create socket.
.TP
4
Cannot connect to remote host.
.TP
5
Resource allocation error.
.TP
6
I/O error.
.TP
7
Server returned an empty document.
.TP
>20
Error code returned by server divided by ten.
.PD
.SH BUGS
Only handles the \fIhttp\fR scheme.
.SH AUTHORS
Kimmo Suominen <kim@tac.nyc.ny.us>
.br
Mark Moraes <moraes@deshaw.com>
