#ifndef __MYCONFIG_HPP__
#define __MYCONFIG_HPP__

#include <fstream.h>
#include <SysConfig.hpp>

#define NR_INPUT           20

struct ImmOpMethod
{
     char *szMethodName;
     char *szImmModule;
     char *szImmTable;
     long type;
};

class CMyConfig
{
private:
    char *szConfigFileName;
    char *szLanguageName;
public:
    /* Input Method Module defination */
    ImmOpMethod aInputMethod[NR_INPUT];
    int TotalMethod;
    /* IMM User Interface  defination */
    char *szFullSymbolLeftMark,
         *szFullSymbolRightMark,
         *szSingleSymbolLeftMark,
         *szSingleSymbolRightMark;
    char *szFullChar,
         *szSingleChar,
         *szSingleSymbol,
         *szFullSymbol,
         *szVersionInfo,
         *szLanguageCode,
         *szFirstMessage;
    /* Help defination */
    char **pszHelp;
    int  TotalHelp;

    /* SysMenu Support */
    char *szSysMenu;
private:
    long GetLanguageCode (char *szLanguageCode);
    void FreeString (char *p);
    char *szLoadSysConfigString (CSysConfig *pConfig, char *p, 
                                 char *szCapName, char *szDefault);
    bool LoadLanguageCode ();
public:
    CMyConfig (char *szConfigFileName, char *szLanguageName);
    ~CMyConfig ();
    bool ChangeLanguageCode (char *szNewLanguageCode);
    char *szGetCurrentLanguageCode ();
};

#endif

