#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <assert.h>
#include <TLS_PthSocket.hpp>
#include <pth.h>

TLS_CPthSocket::TLS_CPthSocket (int fd): fd(fd)
{
}

TLS_CPthSocket::~TLS_CPthSocket ()
{
}

int TLS_CPthSocket::PollRead (char *buf, int len)
{
    char *p = buf;
    int b = len, t;
    fd_set readset;
    struct timeval timeout;

    do
    {
        FD_ZERO (&readset);
        FD_SET (fd, &readset);
        timeout.tv_sec = 120;
        timeout.tv_usec = 0;

        if (select (fd+1, &readset, NULL, NULL, &timeout) <= 0)
           continue;
        t = pth_read_ev(fd, p, len, NULL);
        if (t < 0)
           continue;
        p += t;
        len -= t;
    }
    while (len != 0);
    return b;
}

int TLS_CPthSocket::PollWrite (char *buf, int len)
{
    char *p = buf;
    int b = len, t;

    do
    {
        t = pth_write_ev(fd, p, len, NULL);
        if (t < 0)
           continue;
        p += t;
        len -= t;
    }
    while (len != 0);
    return b;
}

int TLS_CPthSocket::read (void *buf, int buflen)
{
    short len;
#ifdef __IMM_DEBUG__
    printf ("receiving:");
#endif
    PollRead ((char *) &len, sizeof (short));
    assert (len < buflen);
    PollRead ((char *) buf, len);
#ifdef __IMM_DEBUG__
    char *p = (char *) buf;
    printf ("len = %d\n", len);
    for (int i = 0; i < len; i++)
        printf ("(0x%x,%c)", p[i], p[i]);
    printf ("\n");
#endif
    return len;
}

int TLS_CPthSocket::write (void *buf, int len)
{
    short len0 = len;
#ifdef __IMM_DEBUG__
    printf ("sending: len = %d\n", len);
#endif
    PollWrite ((char *) &len0, sizeof (short));
    PollWrite ((char *) buf, len);
#ifdef __IMM_DEBUG__
    char *p = (char *) buf;
    for (int i = 0; i < len; i++)
        printf ("(0x%x,%c)", p[i], p[i]);
    printf ("\n");
#endif
    return len;
}
 
