#ifndef __MEMFILE_HPP__
#define __MEMFILE_HPP__

#include <stdio.h>
#include <stdlib.h>

typedef char * PSTR;
class TLS_CMemFile
{
private:
   char *buf;
   long max;
   long pos;
   long len;
   bool bAllocate;
public:    
    TLS_CMemFile (char *buf, u_long len, u_long max);
    TLS_CMemFile (u_long max);
    ~TLS_CMemFile ();
    int fseek (long offset, int whence);
    long ftell ();
    size_t fread (void *ptr, size_t size, size_t nmemb);
    size_t  fwrite (void  *ptr,  size_t  size, size_t nmemb);
    void rewind ();
    /* buf operation */
    char *pGetBuf ();
    char *pGetCurrentPos ();
    u_long GetBufLen ();
    u_long GetMax ();
    void SetBufLen (int n);    

    /* operator overload */
    friend TLS_CMemFile & operator >> (TLS_CMemFile &in, long &b);
    friend TLS_CMemFile & operator >> (TLS_CMemFile &in, short &b);
    friend TLS_CMemFile & operator >> (TLS_CMemFile &in, char &b);
    friend TLS_CMemFile & operator >> (TLS_CMemFile &in, PSTR &p);
    friend TLS_CMemFile & operator << (TLS_CMemFile &in, long b);
    friend TLS_CMemFile & operator << (TLS_CMemFile &in, short b);
    friend TLS_CMemFile & operator << (TLS_CMemFile &in, char b);
    friend TLS_CMemFile & operator << (TLS_CMemFile &in, PSTR p);
};

#endif

