
/* System Config Management */

/* Similar to Microsoft Windows 
   1). Syntex definations
       ^[xxx]           -- Group
       =                -- equal
       empty line       -- group defination end
   2). Comments

 */

struct SysConfigCap
{
    char *szName;
    char *szValue;
};

class CSysConfigGroup
{
public:
    char *szGroupName;
    SysConfigCap *pOurCap;
    int nTotalCap; 
public:
    CSysConfigGroup (const char *szGroupName = NULL);
    ~CSysConfigGroup ();

    /* Group name operation */
    char *szGetGroupName ();
    bool SetGroupName (const char *szGroupName);

    SysConfigCap *pFindItem (const char *szItemName);
    bool bChangeItem (const char *szItemName, const char *szNewValue);
    bool bAddItem (const char *szItemName, const char *szValue);
    char *szGetItemValue (const char *szItemName);

    friend ifstream & operator >> (ifstream &a, CSysConfigGroup &b);
    friend ofstream & operator << (ofstream &a, CSysConfigGroup &b);
};

class CSysConfig
{
private:
    char *szFileName;
    CSysConfigGroup **ppOurGroup;
    int nTotalGroup;
    int modified;
public:
    CSysConfig (const char *szFileName = NULL);
    ~CSysConfig ();
    bool bSave (const char *szFileName);

    /* Group Operation */
    CSysConfigGroup *AddGroup (CSysConfigGroup *p);
    CSysConfigGroup *pFindGroup (const char *szGroup);
    CSysConfigGroup *pCreateNewGroup (const char *szGroup);

    /* Item Operation */
    bool bWriteCapItem (const char *szGroup, const char *capName, const char *value);
    char *szReadCapItem (const char *szGroup, const char *szCapName);
};

