#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <termios.h>
#include <getopt.h>
#include <locale.h>
#include <libintl.h>
#include <math.h>
#include <setjmp.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/resource.h>
#include <linux/fb.h>
#include <linux/keyboard.h>
#include <pthread.h>

#include <unistd.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <linux/kd.h>

#include <ImmHzInput.hpp>
#include <UniKey.hpp>

#define MAX_TTY         6
class CHzInputMain
{
private:
    /* Low Interface */
    CUniKey *pCMyKey;
    CMyConfig *pMyConfig;
    CImmHzInput *pTtyHzInput[MAX_TTY]; 
    ImmServer_T ImmServer;
public:
    CHzInputMain (char *szIpAddr, short port, 
                  char *szConfigFile, char *szLanguageCode);
    ~CHzInputMain ();
    void DoRun ();
    void FlushAllTty ();
};

CHzInputMain::CHzInputMain (char *szIpAddr, short port, 
                            char *szConfigFile, char *szLanguageCode)
{
    pCMyKey = new CUniKey ("/dev/unikey");
    pMyConfig = new CMyConfig (szConfigFile, szLanguageCode);
    ImmServer = IMM_OpenClient (szIpAddr, port);
    for (int i = 0; i < MAX_TTY; i++)
    {
        pTtyHzInput[i] = new CImmHzInput (i + 1, 
              ImmServer, pMyConfig, pCMyKey);
    }
}

CHzInputMain::~CHzInputMain ()
{
    for (int i = 0; i < MAX_TTY; i++)
        delete pTtyHzInput[i];
    IMM_CloseClient (ImmServer);
    delete pMyConfig;
    delete pCMyKey;
}

int bExitInput = 0;
void CHzInputMain::DoRun ()
{
    TTY_KEY_T ui;
    static int nFlushTerm[8];
    int nCurTty = 0;

    memset (nFlushTerm, 0, sizeof (nFlushTerm));
    do
    {
        pCMyKey->ReadKeys (&ui);
        printf (".");
   //    if (ui.buf[0] == 'q')
   //         break;
        nCurTty = ui.nTty;       
        if (ui.bFlushInput == 1)
            nFlushTerm[nCurTty] = 1;

        if (nFlushTerm[nCurTty] == 1)
        {
            int i;
            // usleep (200);
            nFlushTerm[nCurTty] = 0;
            for (i = 0; i < 5; i++)
                pTtyHzInput[nCurTty]->RefreshInputArea ();
            nFlushTerm[nCurTty] = 0;
        }
        if (ui.nTotal != 0)
            pTtyHzInput[nCurTty]->KeyFilters (ui.buf, ui.nTotal);
    }
    while (bExitInput == 0);
}

void CHzInputMain::FlushAllTty ()
{
    for (int i = 0; i < MAX_TTY; i++)
        pTtyHzInput[i]->DoFlush (); 
}

int StartDaemon()
{
        pid_t pid;

        pid = fork();
        if(pid < 0) return 1;
        if(pid > 0) exit(0);    //parent
        //signal (SIGTERM, PinyinInputCleanup);
        return 0;
}

void SetIgnoreSignal ()
{
        signal( SIGTTOU, SIG_IGN );
        signal( SIGTTIN, SIG_IGN );

        //really for security, your terminal will be hungup
        signal( SIGINT, SIG_IGN );
        signal( SIGTSTP, SIG_IGN );
}

CHzInputMain *MyInput;

#ifdef __DLL_SUPPORT__
#ifdef  __cplusplus
extern "C" {
#endif
    extern long TCP_Connect (char *szIpAddr, short Port);
    extern int TCP_Disconnect (long handle);
    extern int LibOpen ();
    extern int LibRelease ();
#ifdef  __cplusplus
}
#endif

#endif

void our_exit (int i)
{
    extern int bExitInput;
    bExitInput = 1;
}

void WaitAllTtyStart ()
{
    int fd, i, n = 1;                                                               char buf[32];
    do
    {
        usleep (500);
        for (i = n; i <= 6; i++)
        {
            sprintf (buf, "/dev/tty%d", i);
            fd = open(buf, O_RDWR);
            if (fd != -1)
               n ++;
            close(fd);
        }
    }
    while (n <= 6);
}

int main (int argc, char **argv)
{
    char *szLocalCode;
    if (argc < 3)
    {
        printf ("\t\t%s --gb or --big5 <port> \n", argv[0]);
        exit (-1);
    }
#ifdef __DLL_SUPPORT__
    LibOpen ();
#endif
    if (strcmp (argv[1], "--gb") == 0)
        szLocalCode = "GB";
    else if (strcmp (argv[1], "--big5") == 0)
        szLocalCode = "BIG5";
    StartDaemon();
    WaitAllTtyStart ();
    SetIgnoreSignal ();
    signal (SIGTERM, our_exit);
    MyInput = 
         new CHzInputMain ("127.0.0.1", atoi (argv[1]), 
                           UNICON2_LIB"/unicon.ini", szLocalCode);
    MyInput->DoRun ();
    MyInput->FlushAllTty ();
    delete MyInput;
    printf ("Success Unload Unicon.....\n");
#ifdef __DLL_SUPPORT__
    LibRelease ();
#endif
}

