#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <ImmHzInput.hpp>
#include <xl_key.h>

CImmHzInput::CImmHzInput (int nTty0, ImmServer_T ImmServer, 
                    CMyConfig *pMyConfig0, CUniKey *pCMyKey):
                    CAImmHzInput (nTty0, ImmServer, pMyConfig0, pCMyKey) 
{
    nTty = nTty0;
    pMyConfig = pMyConfig0;
    // DoSelectMethod (0);
}

CImmHzInput::~CImmHzInput ()
{
}

#include <MyConfig.hpp>
int CImmHzInput::DoSelectMethod (int method)
{
    assert (method >= 0 && method < 10);
    ImmOpMethod *p = &pMyConfig->aInputMethod[method];
    if (p->szImmModule != NULL)
    {
        int b = OpenInputMethod (p->szImmModule, p->szImmTable, 
                                 p->type, p->szMethodName);
        if (b == 0)
            return 0;
        if (!IsHanziInput)
            ToggleInputMethod();
        else
        {
            RefreshInputArea ();
            RefreshInputMode ();
        }
        return b;
    }
    return 0;
}

/*************************************************************************
 *                        public function                                *
 *************************************************************************/
void CImmHzInput::SwitchHelpToNormal ()
{
    if (bShowFirstStartMsg == 0)
        return;
    bShowFirstStartMsg = 0;
    RefreshInputArea();
}

void CImmHzInput::ToggleInputMethod(void)
{
    if (pImm == NULL)
    {
        DoSelectMethod (0);
        return;
    }
    if (bShowFirstStartMsg == 1)
        SwitchHelpToNormal ();
   if (IsMakingPhrase)
       return;
    if (pImm != NULL)
    {
        IsHanziInput ^= 1;
        IsHanziInputBackup = IsHanziInput;
        if (IsHanziInput == 1)
        {
            IsFullCharBackup = IsFullChar;
            IsFullComma = IsFullCommaInChinese;
            IsFullChar = 0;
        }
        else
        {
            IsFullChar = IsFullCharBackup;
            IsFullComma = IsFullCommaInEnglish;
        }
        RefreshInputMode ();
        RefreshInputArea();
   }
}

void CImmHzInput::ToggleHalfFull(void)
{
   // temporarily disabled
   if (bShowFirstStartMsg == 1)
       SwitchHelpToNormal ();
   if (IsMakingPhrase)
       return;
   IsFullChar = 1 - IsFullChar;
   IsFullCharBackup = IsFullChar;
   if (IsFullChar == 1)
   {
       IsHanziInputBackup = IsHanziInput;
       IsHanziInput = 0;
   }
   else
   {
       IsHanziInput = IsHanziInputBackup;
   }
   RefreshInputMode ();
   RefreshInputArea ();
}

void CImmHzInput::ToggleUserDefinePhrase ()
{
   if (IsHanziInput != 1)
       return;
   if (IsMakingPhrase)
   {
       if (szUserPhrase[0] != '\0')
           MakingUserPhrase (szUserPhraseCode, szUserPhrase);
       pCMyInputArea->SetNewMethod (szOldMethod);
       RefreshInputArea ();
       pCMyKey->WriteKeys (nTty, szUserPhrase, strlen (szUserPhrase));
   }
   else
   {
       char buf[256];
       szUserPhrase[0] = '\0';
       GetInputDisplay (szUserPhraseCode, sizeof (szUserPhraseCode));
       if (szUserPhraseCode[0] == '\0')
           return;
       ResetInput ();
       strcpy (szOldMethod, pCMyInputArea->GetNewMethod ());
       sprintf (buf, "<%s>", szUserPhraseCode);
       pCMyInputArea->SetNewMethod (buf);
       RefreshInputArea ();
   }
   IsMakingPhrase = 1 - IsMakingPhrase;
}

int CImmHzInput::SendSysHelpKey (unsigned char key)
{
    int nDone = 1;
    extern void ShowTips (int ShowTipItem);
    if (ShowTipItem != 0)
    {
        if (key == ' ')
        {
            pCMyInputArea->ShowHelpItem (ShowTipItem++);
            return 0;
        }
        else if (key != '\033')
            return 0;
    }
    switch (key)
    {
        case '\033':  /* ESCAPE */
            ShowTipItem = 0;
            break;
        case 255: /* Help */
            ShowTipItem = 1;
            pCMyInputArea->ShowHelpItem (ShowTipItem++);
            return 0;
        default:
            nDone = 0;
            break;
    }
    return nDone;
}

int CImmHzInput::SendSysMenuKey (unsigned key)
{
    int nDone = 1;
    switch (key)
    {
        case '\033':  /* ESCAPE */
            break;
        case '0':
            //bExitInput = 1;
            break;
        case '1':
            // PinyinInputCleanup ();
            break;
        default:
            nDone = 0;
            break;
    }
    return nDone;
}

int CImmHzInput::ExecPreFuncKey (u_char key)
{
    if (IsHelpMenu == 1)
    {
        if (SendSysHelpKey (key) == 1)
        {
            IsHelpMenu = 0;
        }
        RefreshInputArea ();
        return 1;
    }
    else if (IsSysMenu == 1)
    {
        if (SendSysMenuKey (key) == 1)
        {
            IsSysMenu = 0;
            RefreshInputArea ();
        }
        else
            pCMyInputArea->ShowSysMenu ();
        return 1;
    }
    return 0;
}

int CImmHzInput::ExecSystemFuncKey (u_char key)
{
    switch ( key )
    {
        case CTRL_ALT_0:
        case CTRL_ALT_1:
        case CTRL_ALT_2:
        case CTRL_ALT_3:
        case CTRL_ALT_4:
        case CTRL_ALT_5:
        case CTRL_ALT_6:
        case CTRL_ALT_7:
        case CTRL_ALT_8:
        case CTRL_ALT_9:
            DoSelectMethod (key - CTRL_ALT_0);
            break;
        case SHIFT_TAB:
            ToggleUserDefinePhrase ();
            break;
        case CTRL_F5:
            IsSysMenu = 1;
            RefreshInputArea ();
            pCMyInputArea->ShowSysMenu ();
            break;
        case CTRL_SPACE:
            ToggleInputMethod();
            break;
        case SHIFT_SPACE:
            ToggleHalfFull();
            break;
        case ALT_SPACE:
            if (IsHanziInput == 1)
            {
                IsFullCommaInChinese ^= 1;
                IsFullComma = IsFullCommaInChinese;
            }
            else
            {
                IsFullCommaInEnglish ^= 1;
                IsFullComma = IsFullCommaInEnglish;
            }
            RefreshInputMode ();
            RefreshInputArea ();
            break;
        case F1_HELP:
            if (IsHelpMenu == 1)
                return 1;
            IsHelpMenu = 1;
            SendSysHelpKey (255);
            break;
        default:
            return 0;
    };
    return 1;
}

int CImmHzInput::AllKeyFilter (u_char key, char *buf, int *len)
{
    if (ExecPreFuncKey (key) == 1)
        return 1;
    if (ExecSystemFuncKey (key) == 1)
        return 1;
    if (IsFullChar == 1 || 
        IsHanziInput == 1 ||
        IsFullComma == 1)
        return KeyFilter (key, buf, len);
    return 0;
}

int CImmHzInput::KeyFilters (u_char *key, int total)
{
    int n, len;
    char buf[32];
    for (int i = 0; i < total; i++)
    {
        // printf ("%c, 0x%x\n", key[i], key[i]);
        n = AllKeyFilter (key[i], buf, &len);
        switch (n)
        {
            case 2:
               if (WriteUserDefinedPhrase (buf, len) == 0)
                   pCMyKey->WriteKeys (nTty, buf, len);
               break;
            case 0:
               if (WriteUserDefinedPhrase ((char *) &key[i], 1) == 0)
                   pCMyKey->WriteKeys (nTty, (char *) &key[i], 1);
               break;
        }
    }
    return total;
}

