/*****************************************************************************
 *
 * Communicaton.h  ===  Communicaton between Server and Client 
 *
 *****************************************************************************/
#ifndef __IMMSERVER_HPP__
#define __IMMSERVER_HPP__
#include <stdlib.h>
#include <ImmClient.h>
#include <TLC_SocketClient.hpp>
#include <TLC_MemFile.hpp>

class TLC_CImmServer
{
private:
    TLC_CSocketClient *pCSocketClient;
    TLC_CMemFile *MemIn, *MemOut;
public:
    TLC_CImmServer (char *szIpAddr, u_short port);
    ~TLC_CImmServer ();

    /* Server Imm Operations */
    IMM_HANDLE  OpenImm (char *szImmModule,
                         char *szImmTable, u_long type, IMM *p);
    int CloseImm (IMM_HANDLE  handle);

    /* Imm Input Method Operations */
    int ResetInput (IMM_HANDLE  handle);
    int KeyFilter (IMM_HANDLE handle, u_char key, char *buf, int *len);
    int SetInputMode  (IMM_HANDLE handle, long mode);

    /* Input Area Configuration & Operation */
    int ConfigInputArea (IMM_HANDLE handle, int SelectionLen);
    int GetInputDisplay (IMM_HANDLE handle, char *buf, long buflen);
    int GetSelectDisplay (IMM_HANDLE handle, char *buf, long buflen);

    /* Phrase Item Operations */
    int SetPhraseItem (IMM_HANDLE handle, 
                       u_long n, 
                       char *szCode,
                       char *szPhrase,
                       u_long freq);
    int AddUserPhrase (IMM_HANDLE handle, 
                       char *szCode,
                       char *szPhrase,
                       u_long freq);
    int FlushUserPhrase (IMM_HANDLE handle);
};

#endif

