/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  This will restart one or more of the UBS daemons.  If a specific daemon is specified on the command line, it will start that one.  Otherwise, it starts all known daemons (which are known by their name, which is in the form ubs-*).
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <sys/types.h>
#include <errno.h>

#include "ubs-main.h"

/*+
  Restarts the UBS daemons.

  int cmd_start Returns OK on success, NO_DIR if the bin/ directory can't be found, or FAIL if the daemon can't be started

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_restart(int cmdc, char **cmdv) {
 DIR *dp;
 struct dirent *ds;
 int ch, format = ENGLISH;

 while((ch = getopt(cmdc, cmdv, "hwces")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'h':
    sub_help_cmd("restart");
    return OK;
    break;
   default:
    sub_help_cmd("restart");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 if(cmdc == 0 || !strcasecmp(cmdv[0], "all")) {
  // start all.  To do this, we basically find all the files
  // in the bin directory that match some form of ubs-*, and exec
  // each one of those.  Kind of weird.  But it works, so shut up.
  if((dp = opendir("bin")) == NULL) {
   printf("Error: Can't open bin/ directory to search for UBS daemons");
   return NO_DIR;
  }

  while((ds = readdir(dp)) != NULL) {
   if(!strncmp(ds->d_name, "ubs-", 4)) {
    // need to do some checking here
    sub_stop_proc(ds->d_name, format);
    // wait for it....wait for it...
    usleep(100);
    // need to do some checking here
    sub_start_proc(ds->d_name, format);
   }
  }

  closedir(dp);
 }
 // just start a process as specified on the command line
 else {
  // need to do some checking here
  sub_stop_proc(cmdv[0], format);
  // wait for it....wait for it...
  usleep(100);
  // need to do some checking here
  sub_start_proc(cmdv[0], format);
 }
 
 return OK;
}
