/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/***
  Reads in the ubs.conf file, and stores any information parsed from a specific section into a ubs_table data structure.
***/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "ubs.h"

/*+
  Reads in the configuration file for a given context

  int read_config Returns NO if no errors occurred during parsing, NO_FILE if the configuration file could not be opened, or YES if any error occurred during parsing.

  char *fname The name of the configuration file to read

  char *section The context name to parse

  ubs_table *table Data structure where the data is to be stored
+*/
int read_config(char *fname, char *section, ubs_table * table)
{
 FILE *config_fp;
 char line_buf[BIGBUF], directive[STRBUF], argument[BIGSTR], buf[STRBUF], *p;
 int bad = NO, line_ct = 0, res;

 if(fname == NULL) {
  snprintf(buf, STRBUF, "%s/%s", ubs_table_data(&GLOBAL, "prefix"), DEF_CONFIG);
  if((config_fp = fopen(buf, "r")) == NULL) {
   return NO_FILE;
  }
 }
 else {
  if((config_fp = fopen(fname, "r")) == NULL) {
   return NO_FILE;
  }
 }

 while(fgets(line_buf, BIGBUF, config_fp)) {
  chomp_line(line_buf);
  line_ct++;
  res = parse_line(line_buf, directive, argument);
  if(res < 0) {
   printf("%s: Bad syntax or error on line %d\n", fname, line_ct);
   bad = YES;
  }
  else {
   if(directive[0] != '\0' && argument[0] != '\0') {
    // separate the context from the actual variable
    p = strchr(directive, '.');
    if(p == NULL) {
     continue;
     bad = YES;
    }
    else {
     strncpy(buf, directive, STRBUF);
     *p = '\0';
     if(!strcasecmp(directive, section)) {
      strncpy(directive, p + 1, STRBUF);
      // insert subcontext and argument into table
      ubs_table_add(table, directive, argument);
     }
    }
   }
  }
 }

 fclose(config_fp);

 return bad;
}
