(* now in cs-manager.fun *)
(*
structure CSManager = CSManager (structure Global = Global
                                 (*! structure IntSyn = IntSyn !*)
                                 structure Unify = UnifyTrail
                                 structure Fixity = Names.Fixity
                                 structure ModeSyn = ModeSyn);
*)

structure CSEqQ = CSEqField (structure Field = Rationals
                             (*! structure IntSyn = IntSyn !*)
                             structure Whnf = Whnf
                             structure Unify = UnifyTrail
                             (*! structure CSManager = CSManager !*)
			       );

structure CSIneqQ = CSIneqField (structure OrderedField = Rationals
				 (*! structure IntSyn = IntSyn !*)
                                  structure Trail = Trail
                                  structure Unify = UnifyTrail
                                  structure SparseArray = SparseArray
                                  structure SparseArray2 = SparseArray2
				  (*! structure CSManager = CSManager !*)
                                  structure CSEqField = CSEqQ);

structure CSEqStrings = CSEqStrings ((*! structure IntSyn = IntSyn !*)
                                     structure Whnf = Whnf
                                     structure Unify = UnifyTrail
                                     (*! structure CSManager = CSManager !*)
				       );

structure CSEqBools = CSEqBools ((*! structure IntSyn = IntSyn !*)
                                 structure Whnf = Whnf
                                 structure Unify = UnifyTrail
                                 (*! structure CSManager = CSManager !*)
				   );

structure CSEqZ = CSEqIntegers (structure Integers = Integers
                                (*! structure IntSyn = IntSyn !*)
                                structure Whnf = Whnf
                                structure Unify = UnifyTrail
                                (*! structure CSManager = CSManager !*)
				  );

structure CSIneqZ = CSIneqIntegers (structure Integers = Integers
                                    structure Rationals = Rationals
                                    (*! structure IntSyn = IntSyn !*)
                                    structure Trail = Trail
                                    structure Unify = UnifyTrail
                                    structure SparseArray = SparseArray
                                    structure SparseArray2 = SparseArray2
                                    (*! structure CSManager = CSManager !*)
                                    structure CSEqIntegers = CSEqZ);

(*
structure CSIntWord32 = CSIntWord (structure Word = Word32
                                   (*! structure IntSyn = IntSyn !*)
                                   structure Whnf = Whnf
                                   structure Unify = UnifyTrail
                                   (*! structure CSManager = CSManager !*)
				     );
*)

(* Poly/ML does not have a Word32 structure *)
signature CS_INSTALLER =
sig
  val version : string
end; 

(* execute for effect *)
(* wrapped in structure so it can be tracked by CM *)
structure CSInstaller : CS_INSTALLER =
struct
  val _ = CSManager.installSolver (CSEqQ.solver)
  val _ = CSManager.installSolver (CSIneqQ.solver)
  val _ = CSManager.installSolver (CSEqStrings.solver)
  val _ = CSManager.installSolver (CSEqBools.solver)
  val _ = CSManager.installSolver (CSEqZ.solver)
  val _ = CSManager.installSolver (CSIneqZ.solver)
  (* val _ = CSManager.installSolver (CSIntWord32.solver) *)
  val version = "12/19/2002"
end;
