/* autoinit.c 
	vi:ts=3 sw=3:
 */

/* $Id: autoinit.c,v 5.4 1996/04/09 21:13:20 espie Exp espie $ 
 * $Log: autoinit.c,v $
 * Revision 5.4  1996/04/09 21:13:20  espie
 * *** empty log message ***
 *
 * Revision 5.3  1996/04/02 09:32:04  espie
 * *** empty log message ***
 *
 * Revision 5.2  1996/03/12 22:35:59  espie
 * Added prototypes, cleaned up. Varargs end_all().
 *
 * Revision 5.0  1995/10/21 14:56:06  espie
 * New
 *
 * Revision 4.7  1995/02/01  16:39:04  espie
 * Includes moved to defs.h
 *
 */

/* emulates atexit functionality, but much more reliable */

#include "defs.h"
#include "extern.h"
#include "autoinit.h"

ID("$Id: autoinit.c,v 5.4 1996/04/09 21:13:20 espie Exp espie $")

LOCAL struct clist
	{
	struct clist *next;
	void (*func)(void);
	} *list = 0;
	

void at_end(void (*cleanup)(void))
	{
#ifdef USE_AT_EXIT
	atexit(cleanup);
#else
	struct clist *new;

	new = (struct clist *)malloc(sizeof(struct clist));
	if (!new)
		{ /* don't forget to call the latest function ! */
		(*cleanup)();	
		end_all("Allocation problem");
		}
	new->next = list;
	new->func = cleanup;
	list = new;
#endif
	}
	
void end_all(char *template, ...)
	{
	va_list al;
#ifndef USE_AT_EXIT
	struct clist *p;
#endif
	if (template)
		{
		va_start(al, template);
		vnotice(template, al);
		va_end(al);
		}
#ifndef USE_AT_EXIT
	for (p = list; p; p = p->next)
		(p->func)();			/* don't bother freeing (malloc) */
#endif
	exit(template ? EXIT_FAILURE : EXIT_SUCCESS);
	}
