/* tdocked.c -- return the status of the SelectBay in a docking station.
 *
 * Copyright (c) 1999  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log: tdocked.c,v $
 * Revision 1.1  1999/12/17 12:15:17  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

static char const rcsid[]="$Id: tdocked.c,v 1.1 1999/12/17 12:15:17 jab Exp jab $";


#include<stdio.h>
#include<unistd.h>
#include<string.h>
#ifdef __GLIBC__
#include<sys/perm.h>
#endif

#include"hci.h"
#include"sci.h"

#define USAGE "\
Usage: tdocked [-h]\n\
return the status of the SelectBay in a docking station:\n\
  0x00   The SelectBay is empty\n\
  0x01   The SelectBay contains a floppy drive\n\
  0x02   The SelectBay contains an ATAPI device such as a CD-ROM\n\
  0x03   The SelectBay contains an IDE hard disk\n\
  0x04   The SelectBay contains a second battery\n\
  0x80   The system does not support SelectBay devices\n\
  0x83   The docking station is not attached to the laptop.\n\
  0xff   The computer is not a Toshiba laptop.\n"


int main(int argc, char *argv[])
{
	HciRegisters reg;
	int version;

	/* get the necessary I/O permissions */

	if (ioperm(0xb2, 1, 1)) {
		fprintf(stderr, "tdocked: can't get I/O permissions.\n");
		return 0xff;
	}

	/* drop root priveleges to reduce security risk of running suid root */

	seteuid(getuid());
	setegid(getgid());

	/* do a check on the laptop to see if it is a Toshiba */

	if (SciSupportCheck(&version)==SCI_FAILURE) {
		fprintf(stderr, "tdocked: this computer is not supported\n");
		return 0xff;
	}

	/* process any command line arguments */

	if (argc>1) {
		if (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help"))
			printf(USAGE);
	}
                
	/* get the status of the external SelectBay */

	reg.ax = HCI_GET;
	reg.bx = HCI_SELECT_STATUS;
	reg.cx = 0x0100;
	if (HciFunction(&reg)!=HCI_SUCCESS)
		return reg.ax>>8;

	return reg.cx;
}
