/* hci.c -- Hardware Configuration Interface
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *   
 * $Log: hci.c,v $
 * Revision 1.3  1999/12/12 11:33:39  jab
 * changed assembler to save registers, should make the programs stabler
 * slightly fudged addition to GetMachineID to get SCTTable ID's
 *
 * Revision 1.2  1999/08/15 10:43:28  jab
 * removed the HciGet and HciSet and replaced with HciFunction
 *
 * Revision 1.1  1999/03/11 20:27:06  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

static const char rcsid[]="$Id: hci.c,v 1.3 1999/12/12 11:33:39 jab Exp jab $";

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>

#include"hci.h"

static int id=0x0000;

int HciFunction(HciRegisters *reg)
{
	unsigned short ax,bx,cx,dx;

	ax = reg->ax;
	bx = reg->bx;
	cx = reg->cx;
	dx = reg->dx;

	/* emulate the HCI fan function for the Portage 610 and Tecra 700 */

	if ((id==0xfccb) && (bx==HCI_FAN)) {
		asm("movw %1,%%ax\n\t" \
			"movw %2,%%cx\n\t" \
			"cli\n\t" \
			"movb $0xbe,%%al\n\t" \
			"outb %%al,$0xe4\n\t" \
			"inb $0xe5,%%al\n\t" \
			"cmpb $0xfe,%%ah\n\t" \
			"je 3f\n\t" \
			"cmpw $0x0001,%%cx\n\t" \
			"jne 1f\n\t" \
			"andb $0xfe,%%al\n\t" \
			"jmp 2f\n\t" \
			"1: orb $0x01,%%al\n\t" \
			"2: movb %%al,%%ah\n\t" \
			"movb $0xbe,%%al\n\t" \
			"outb %%al,$0xe4\n\t" \
			"movb %%ah,%%al\n\t" \
			"outb %%al,$0xe5\n\t" \
			"3: sti\n\t" \
			"andw $0x0001,%%ax\n\t" \
			"movw %%ax,%0\n" \
 			:"=m" (cx) : "m" (ax), "m" (cx) : "memory" );
		cx = (cx==0x00) ? 0x01:0x00;
		ax = 0x0000;
	} else if ((id==0xfccb) && (bx==HCI_FAN)) {
		asm("movw %1,%%ax\n\t" \
			"movw %2,%%cx\n\t" \
			"cli\n\t" \
			"movw $0x00e4,%%dx\n\t" \
			"movb $0xe0,%%al\n\t" \
			"outb %%al,%%dx\n\t" \
			"incw %%dx\n\t" \
			"inb %%dx,%%al\n\t" \
			"cmpb $0xfe,%%ah\n\t" \
			"je 3f\n\t" \
			"cmpw $0x0001,%%cx\n\t" \
			"jne 1f\n\t" \
			"orw $0x0001,%%ax\n\t" \
			"jmp 2f\n\t" \
			"1: andw $0xfffe,%%ax\n\t" \
			"2: decw %%dx\n\t" \
			"movb %%al,%%ah\n\t" \
			"movb $0xe0,%%al\n\t" \
			"outw %%ax,%%dx\n\t" \
			"3: sti\n\t" \
			"andw $0x0001,%%ax\n\t" \
			"movw %%ax,%0\n" \
 			:"=m" (cx) : "m" (ax), "m" (cx) : "memory" );
		ax = 0x0000;		
	} else {
		asm ("inb $0xb2,%%al\n" \
			:"=ax" (ax), "=bx" (bx), "=cx" (cx), "=dx" (dx) \
			:"ax" (ax), "bx" (bx), "cx" (cx), "dx" (dx) \
			: "memory" );
	}
	
	reg->ax = ax;
	reg->bx = bx;
	reg->cx = cx;
	reg->dx = dx;

	return (int) (ax & 0xff00)>>8;
}


/*
 * Return the BIOS version of the laptop
 *
 *   I may or may not follow the Toshiba version of this function. The
 *   Toshiba function would appear to read from this area of memory, but
 *   exactly what it does I am not sure. This implemenation is impirically
 *   based on the contents of these memory locations on my Satellite Pro
 *   400CS and Libretto 50CT. I have confirmed that it returns the correct
 *   information on a Tecra 750CDT and a T4900 as well.
 */
int HciGetBiosVersion(void)
{
	int device,major,minor;
	unsigned char *mem;


	if ((device = open("/dev/mem", O_RDWR))==-1)
		return HCI_FAILURE;

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xfe000);
	if (mem==(unsigned char *)-1)
		return HCI_FAILURE;

	major = (char) mem[0x0009]-'0';
	minor = (((char) mem[0x000b]-'0')*10)+((char) mem[0x000c]-'0');

	munmap(mem, 0x1000);
	close(device);

	id = (major*0x100)+minor;

	return id;
}


/*
 * Get some sort of machine ID pointer from the SMM
 */
static int HciGetIDPointer(unsigned int edx, unsigned short *cx)
{
	unsigned char ah;
	unsigned short xc;

	xc = *cx;

	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"pushl %%edx\n\t" \
		"movw $0xfefe,%%ax\n\t" \
		"movw $0x0070,%%bx\n\t" \
		"movw $0x0000,%%cx\n\t" \
		"movl %2,%%edx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movw %%cx,%0\n\t" \
		"movb %%ah,%1\n\t" \
		"popl %%edx\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=m" (xc), "=m" (ah) \
		:"m" (edx) \
		: "memory" );

	*cx = xc;

	return (int) ah;
}


/*
 * Get the Toshiba machine identification number
 *
 *   Below is a list of known ID's and the models.
 *
 *     0xfc39: T2200SX
 *     0xfc40: T4500C
 *     0xfc41: T4500
 *     0xfc45: T4400SX
 *     0xfc45: T4400SXC
 *     0xfc5f: T3300SL
 *     0xfc69: T1900C
 *     0xfc6a: T1900
 *     0xfc6d: T1850C
 *     0xfc6e: T1850
 *     0xfc6f: T1800
 *     0xfc7e: T4600C
 *     0xfc7f: T4600
 *     0xfc8a: T6600C
 *     0xfc91: T2400CT
 *     0xfc97: T4800CT
 *     0xfc99: T4700CS
 *     0xfc9b: T4700CT
 *     0xfc9d: T1950
 *     0xfc9e: T3400
 *     0xfc9e: T3400CT
 *     0xfcb2: Libretto 30CT
 *     0xfcba: T2150
 *     0xfcbe: T4850CT
 *     0xfcc0: Satellite Pro 420x
 *     0xfcc1: Satellite 100x
 *     0xfcc3: Tecra 710x, Tecra 720x
 *     0xfcc6: Satellite Pro 410x
 *     0xfcca: Satellite Pro 400x
 *     0xfccb: Portage 610CT
 *     0xfccc: Tecra 700x
 *     0xfccf: T4900CT
 *     0xfcd0: Satellite 300x
 *     0xfcd1: Tecra 750CDT
 *     0xfcd4: Tecra 510x
 *     0xfcd5: Satellite 200x
 *     0xfcd7: Satellite Pro 430x
 *     0xfcd8: Tecra 740x
 *     0xfcd9: Portage 660CDT
 *     0xfcda: Tecra 730x
 *     0xfcdb: Portage 620CT
 *     0xfcdc: Portage 650CT
 *     0xfcdd: Satellite 110x
 *     0xfcdf: Tecra 500x
 *     0xfce0: Tecra 780DVD
 *     0xfce3: Satellite 310x
 *     0xfce4: Satellite Pro 490x
 *     0xfce7: Tecra 540x
 *     0xfce8: Satellite Pro 480x
 *     0xfce9: Tecra 750DVD
 *     0xfceb: Libretto 50CT
 *     0xfced: Tecra 520x
 *     0xfcef: Satellite 220x
 */
int HciGetMachineID(int *id)
{
	int device;
	unsigned char *mem;
	unsigned char ah;
	unsigned short bx,cx;
	unsigned long edx;

	if ((device = open("/dev/mem", O_RDWR))==-1) {
		*id = 0;
		return HCI_FAILURE;
	}

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xff000);
	if (mem==(unsigned char *)-1) {
		*id = 0;
		close(device);
		return HCI_FAILURE;
	}

	/* get the old style machine identification number */

	*id = (0x100*((int) mem[0xffe]))+((int) mem[0xffa]);
	munmap(mem, 0x1000);
	close(device);

	/* do we have a SCTTable machine identication number on our hands */

	if (*id==0xfc2f) {

		/* start by getting a pointer into the BIOS */

		asm ("pushl %%eax\n\t" \
			"pushl %%ebx\n\t" \
			"pushl %%ecx\n\t" \
			"pushl %%edx\n\t" \
			"movw $0xc000,%%ax\n\t" \
			"movw $0x0000,%%bx\n\t" \
			"movw $0x0000,%%cx\n\t" \
			"inb $0xb2,%%al\n\t" \
			"movw %%bx,%0\n\t" \
			"movb %%ah,%1\n\t" \
			"popl %%edx\n\t" \
			"popl %%ecx\n\t" \
			"popl %%ebx\n\t" \
			"popl %%eax\n" \
			:"=m" (bx), "=m" (ah) \
			: \
			: "memory" );

		/* At this point in the Toshiba routines under MS Windows
		   the bx register holds 0xe6f5. However my code is producing
		   a different value! For the time being I will just fudge the
		   value. This has been verified on a Satellite Pro 430CDT,
		   Tecra 750CDT, Tecra 780DVD and Satellite 310CDT. */

		bx = 0xe6f5;

		/* now twiddle with our pointer a bit */

		edx = 0x000f0000+bx;
		if (HciGetIDPointer(edx, &cx)!=0x00) {
			*id = 0;
			return HCI_FAILURE;
		}

		edx = 0x000f0009+bx+cx;
		if (HciGetIDPointer(edx, &cx)!=0x00) {
			*id = 0;
			return HCI_FAILURE;
		}

		edx = 0x000f000a+cx;
		if (HciGetIDPointer(edx, &cx)!=0x00) {
			*id = 0;
			return HCI_FAILURE;
		}

		/* now construct our machine identification number */

		*id = ((cx & 0xff)<<8)+((cx & 0xff00)>>8);
	}

	return HCI_SUCCESS;
}


/*
 * Return the LCD Panel type
 *
 */
int HciGetLCDPanelType(unsigned short mode, unsigned short *status)
{
	unsigned short ax,bx,cx;
	unsigned char fl;

	bx = mode;
	cx = *status;
	
	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"pushl %%edx\n\t" \
		"movw $0xfefe,%%ax\n\t" \
		"movw $0x0011,%%bx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movw %%ax,%0\n\t" \
		"movw %%bx,%1\n\t" \
		"movw %%cx,%2\n\t" \
		"lahf\n\t" \
		"movb %%ah,%3\n\t" \
		"popl %%edx\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=m" (ax), "=m" (bx), "=m" (cx), "=m" (fl) \
		:"m" (bx), "m" (cx) \
		: "memory" );

	*status = cx;

	return (int) (fl & 0x01);
}


/*
 * Return the status of the Fn key
 */
int HciFnStatus(void)
{
        unsigned char al;

	asm ("pushl %%eax\n\t" \
                "movw $0x008e,%%ax\n\t" \
		"cli\n\t" \
                "outb %%al,$0xe4\n\t" \
                "inb $0xe5,%%al\n\t" \
                "sti\n\t" \
                "movb %%al,%0\n\t" \
		"popl %%eax\n" \
                :"=m" (al) : : "memory" );

        return (int) al;
}
