/*
    Copyright (C) 1998  Dennis Roddeman
    email: dennis.roddeman@feat.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

void nonlocal_set( void )

{
  long int i=0, jn=0, inod=0, jnod=0, kn=0, knod=0, ldum=0, 
    length=0, length_node_node=0, max_node=0, nnonlocal=0, ready=0, 
    swit=0, idum[1], *node_node=NULL, *node_nonlocal=NULL;
  double x=0., normal_distribution=0., distance=0., 
    options_nonlocal=0., total_weight=0., 
    ddum[1], icoord[MDIM], kcoord[MDIM], work[MDIM], 
    *node_nonlocal_weight=NULL;

  if ( materi_plasti_f_nonlocal ) {
    swit = set_swit(-1,-1,"nonlocal_set");
    if ( swit ) pri( "In routine NONLOCAL_SET" );

    length = db_data_length(NODE_NODE);
    node_node = get_new_int(length);
    node_nonlocal = get_new_int(DATA_ITEM_SIZE);
    node_nonlocal_weight = get_new_dbl(DATA_ITEM_SIZE);
    db_delete( NODE_NONLOCAL, VERSION_NORMAL );
    db_delete( NODE_NONLOCAL_WEIGHT, VERSION_NORMAL );
    db_max_index( NODE, max_node, VERSION_NORMAL, GET );
    db( OPTIONS_NONLOCAL, 0, idum, &options_nonlocal, ldum, 
      VERSION_NORMAL, GET );
    for ( inod=0; inod<=max_node; inod++ ) {
      if ( db_active_index( NODE, inod, VERSION_NORMAL ) ) {
          // search for neighbours of node inod
        db( NODE, inod, idum, icoord, ldum, VERSION_NORMAL, GET );
        ready=0; nnonlocal = 0;
        node_nonlocal[nnonlocal] = inod;
        node_nonlocal_weight[nnonlocal] = 1.;
        nnonlocal++;
        while ( !ready ) {
          ready = 1;
            // loop over already found neighbours jnod
          for ( jn=0; jn<nnonlocal; jn++ ) {
            jnod = node_nonlocal[jn];
              // loop over nodes knod connected to neighbours jnod
            db( NODE_NODE, jnod, node_node, ddum, length_node_node, VERSION_NORMAL, GET );
            for ( kn=0; kn<length_node_node; kn++ ) {
              knod = labs(node_node[kn]);
                // add this node knod to inod list if its distance is small enough
              db( NODE, knod, idum, kcoord, ldum, VERSION_NORMAL, GET );
              distance = array_distance( icoord, kcoord, work, ndim );
              if ( distance<=options_nonlocal && 
                   !array_member(node_nonlocal,knod,nnonlocal,ldum) ) {
                ready = 0;
                node_nonlocal[nnonlocal] = knod;
                x = 2.*distance/options_nonlocal;
                normal_distribution = (1./(sqrt(2.*PIRAD))) * exp(-x*x/(2.));
                node_nonlocal_weight[nnonlocal] = normal_distribution;
                nnonlocal++;
                if ( nnonlocal==DATA_ITEM_SIZE ) {
                  pri( "DATA_ITEM_SIZE in tochnog.h too small for nonlocal calculation." );
                  pri( "Increase it and recompile all routines." );
                  exit(TN_EXIT_STATUS);
                }
              }
            }
          }
        }
        db( NODE_NONLOCAL, inod, node_nonlocal, ddum, 
          nnonlocal, VERSION_NORMAL, PUT );
        db( NODE_NONLOCAL_WEIGHT, inod, idum, node_nonlocal_weight, 
          nnonlocal, VERSION_NORMAL, PUT );
      }
    }
      // normalize the weight factors to 1
    for ( inod=0; inod<=max_node; inod++ ) {
      if ( db_active_index( NODE, inod, VERSION_NORMAL ) ) {
        db( NODE_NONLOCAL_WEIGHT, inod, idum, node_nonlocal_weight, 
          nnonlocal, VERSION_NORMAL, GET );
        total_weight = 0.;
        for ( i=0; i<nnonlocal; i++ ) total_weight += node_nonlocal_weight[i];
        assert( total_weight!=0. );
        for ( i=0; i<nnonlocal; i++ ) node_nonlocal_weight[i] /= total_weight;
        db( NODE_NONLOCAL_WEIGHT, inod, idum, node_nonlocal_weight, 
          nnonlocal, VERSION_NORMAL, PUT );
      }
    }
    delete[] node_node;
    delete[] node_nonlocal;
    delete[] node_nonlocal_weight;
    if ( swit ) pri( "Out routine NONLOCAL_SET" );
  }

}

void nonlocal_apply( void )

{
  long int jn=0, inod=0, jnod=0, nnonlocal=0, max_node=0,
    swit=0, idum[1], *node_nonlocal=NULL;
  double ddum[1], *node_nonlocal_weight=NULL, 
    *inode_dof=NULL, *jnode_dof=NULL;

  if ( materi_plasti_f_nonlocal ) {
    swit = set_swit(-1,-1,"nonlocal_apply");
    if ( swit ) pri( "In routine NONLOCAL_APPLY" );

    node_nonlocal = get_new_int(DATA_ITEM_SIZE);
    node_nonlocal_weight = get_new_dbl(DATA_ITEM_SIZE);
    db_max_index( NODE, max_node, VERSION_NORMAL, GET );
    for ( inod=0; inod<=max_node; inod++ ) {
      if ( db_active_index( NODE, inod, VERSION_NORMAL ) ) {
        db( NODE_NONLOCAL, inod, node_nonlocal, ddum, 
          nnonlocal, VERSION_NORMAL, GET );
        db( NODE_NONLOCAL_WEIGHT, inod, idum, node_nonlocal_weight, 
          nnonlocal, VERSION_NORMAL, GET );
        inode_dof = db_dbl( NODE_DOF, inod, VERSION_NEW );
        inode_dof[fn_indx] = 0.;
        for ( jn=0; jn<nnonlocal; jn++ ) {
          jnod = node_nonlocal[jn];
          jnode_dof = db_dbl( NODE_DOF, jnod, VERSION_NEW );
          inode_dof[fn_indx] += node_nonlocal_weight[jn] * jnode_dof[f_indx];
        }
      }
    }
    delete[] node_nonlocal;
    delete[] node_nonlocal_weight;

    if ( swit ) pri( "Out routine NONLOCAL_APPLY" );
  }
}
