#include <stdio.h>
#include <errno.h>
#include "pathcompress.h"

void test_compress_path(char* in, char* exp) {
  char path[4096];
  char* out;
  out = pathcompress_compress_path(in, path);
  if ( (out == NULL)  || (strcmp(out, exp) != 0)) {
    printf("bad compress: '%s' -> '%s' expected '%s'\n", in, out, exp);
  }

  out = pathcompress_uncompress_path(exp, path);
  if ( (out == NULL)  || (strcmp(out, in) != 0)) {
    printf("bad uncompress: '%s' -> '%s' expected '%s'\n", exp, out, in);
  }
}

main()
{
  char abspath[4096];
  char compressed[4096];
  char compressed2[4096];
  char exp[4096];
  char wd[256];
  int rvl;

  getcwd(wd, sizeof(wd));

#if 1
  test_compress_path("/foo", "/foo");
  test_compress_path("foo", "foo");
  test_compress_path("{arch}", "{arch}");
  test_compress_path("{arch}/foo", "{arch}/0");
  test_compress_path("{arch}/foo/bar", "{arch}/0/1");
  test_compress_path("{arch}/foo/bar/fubaz", "{arch}/0/1/0");
  test_compress_path("{arch}/foo/bar/fubaz/{arch}", "{arch}/0/1/0/2");
  test_compress_path("{arch}/foo/bar/fubaz/{arch}/,,import.test.user@domain.com.seq", "{arch}/0/1/0/2/0");

  chdir("{arch}/0/1");
  test_compress_path(".", ".");
  test_compress_path("./", "./");
  test_compress_path("..", "..");
  test_compress_path("../", "../");
  test_compress_path("fubaz", "0");
  test_compress_path("fubaz/", "0/");
  test_compress_path("fubaz/{arch}", "0/2");
  test_compress_path("fubaz/{arch}/", "0/2/");
  test_compress_path("fubaz/{arch}/,,import.test.user@domain.com.seq","0/2/0");

  chdir("{arch}/0/1");
  pathcompress_compress_path("fubaz", abspath);
#if 0
  pathcompress_add_path("fubaz/test", abspath);
  pathcompress_compress_path("fubaz/test", abspath);
  printf("mkdir(%s)\n", abspath);
  mkdir(abspath, 0755);
  pathcompress_add_pathid("fubaz/test");
#endif
  chdir("../../..");
#endif

#if 1
  pathcompress_compress_path("{arch}/foo", abspath);
  pathcompress_add_path("{arch}/foo/test", abspath);
  sprintf(exp, "%s/{arch}/0/0", wd);
  if (strcmp(abspath, exp)!=NULL) {
    printf("bad add_path %s expected %s\n", abspath, exp);
  }
  //pathcompress_compress_path("{arch}/foo/test", abspath);
  //printf("mkdir(%s)\n", abspath);
  //mkdir(abspath, 0755);
  //pathcompress_add_pathid("{arch}/foo/test");
#endif

#if 1
#define ADD(dir) \
    /*printf("test_mkdir(%s)\n", dir);*/\
    pathcompress_add_path(dir, abspath);\
    /*printf("abspath(%s)\n", abspath);*/\
    pathcompress_compress_path(dir, compressed);\
    /*printf("compressed(%s)\n", compressed);*/\
    rvl = mkdir(compressed, 0755);\
    /*printf("mkdir(%s)=%d, errno=%d\n", compressed, rvl, errno);*/\
    pathcompress_add_pathid(dir);\
    /*printf("\n");*/
  ADD("test");
  ADD("test/foo");
  ADD("test/foo/bar");
  ADD("test/{arch}");
  ADD("test/{arch}/foo");
  ADD("test/{arch}/foo/bar");


  pathcompress_compress_path("test/{arch}/foo", compressed);
  pathcompress_add_path("test/{arch}/foo2", abspath);
  pathcompress_compress_path("test/{arch}/foo2", compressed2);
  rename(compressed, compressed2);
  pathcompress_remove_path("test/{arch}/foo");
  pathcompress_update_pathid("test/{arch}/foo2");

#endif

}
