/*	$Id: main.c,v 1.9 2006/03/19 11:34:47 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/types.h>
#include <sys/socket.h>

#include <ctype.h>
#include <err.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "dispatcher.h"
#include "context.h"
#include "client.h"
#include "tty.h"
#include "listener.h"
#include "setup.h"
#include "stdio2pty.h"

static void usage(void);

const char *pname;


int
main(int argc, char **argv, char **envp)
{
	const char *estr;
	const char *conf_file = NULL;

	if ((pname = strrchr(argv[0], '/')) == NULL)
		pname = argv[0];
	else
		pname++;

	if (strcmp(pname, "stdio2pty") == 0)
		exit(stdio2pty_main(argc, argv, envp));

	if (argc == 1)
		conf_file = TITS_DEFAULT_CONFIG_FILE;
	else
	if (argc == 2)
		conf_file = argv[1];
	else
		usage();

	if (dispatcher_init() < 0)
		err(1, "dispatcher_init()");

	if ((estr = setup_parse(conf_file)) != NULL)
		errx(1, "%s", estr);

	openlog(pname, LOG_PID, LOG_DAEMON);

	if (daemon(0, 0) < 0)
		syslog(LOG_ALERT, "Failed to become daemon!");

	dispatcher_mainloop();

	return (0);
}

static void
usage(void)
{

	fprintf(stderr, "usage: %s <config file>\n", pname);
	exit(1);
	/* NOTREACHED */
}
