%% $Id: xysource.man,v 3.27 2010/07/27 11:07:26 krisrose Exp $
%%
%% Wrapper to typeset ``Xy-pic Sources with TeXnical documentation''.
%% Copyright (c) 1991-1998	 Kristoffer H. Rose  <krisrose@tug.org>
%%
%% This file is part of the Xy-pic package for graphs and diagrams in TeX.
%% Copyright (c) 1991-1998	 Kristoffer H. Rose  <krisrose@tug.org>
%%
%% The Xy-pic package is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by the
%% Free Software Foundation; either version 2 of the License, or (at your
%% option) any later version.
%%
%% The Xy-pic package is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
%% or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU General Public License
%% for more details.
%%
%% You should have received a copy of the GNU General Public License along
%% with this package; if not, see http://www.gnu.org/licenses/.
%%

\RequirePackage{ifpdf}\ifpdf
  \documentclass[letterpaper,11pt,pdftex]{book}
\else
  \documentclass[letterpaper,11pt]{book}
\fi
\usepackage{xydoc}
\makeindex

%% FIX definitions of subsections and such for TeXnical docs...
%
\makeatletter
%
\def\OSECTION#1{\let\xyprovide=\specialxyprovide
 \def\OPREFIX{}\def\LOADAS##1{}%
 \input{#1}\runxywith@ \inputdoc!{#1}}
%
\def\DTSECTION#1{\let\xyprovide=\specialxyprovide
 \def\OPREFIX{}\def\LOADAS##1{}%
 \let\orignewdriver=\newdriver \let\origxyaddsupport=\xyaddsupport
 \def\newdriver##1{\orignewdriver{##1}\xyendinput}%
 \def\xyaddsupport##1##2{\expandafter\xyadddriversupport@\expandafter{%
    \xyoption@@}{##1}{\ignorespaces}}%
 \input{#1}%
 \let\newdriver=\orignewdriver \let\xyaddsupport=\origxyaddsupport}
%
\def\DSECTION#1{\DTSECTION{#1}\inputdoc!{#1}}
%
\makexydocactive
\def\FILESUBSECTION#1{\subsection{#1}??=[#1]\inputdoc0{#1}}
\def\FONTSUBSECTION#1#2{\subsection{#1}??=[#1]
  \fontfigure{#1#2}\inputdoc0{#1.mf}}
\makexydocother
%
\def\defaultdocmode@{\docmode@@}
%
\def\BIBLIOGRAPHY{%
 \bibliographystyle{plain}
 \bibliography{xydoc}
 \addtocontents{toc}{%
  \protect\contentsline{section}{Bibliography}{\protect\pageref{BIBLIOGRAPHY}}{}}}
%
\let\maketitle=\SAVEDmaketitle
%
\def\INDEX{%
 \let\PREINDEXtheindex=\theindex
 \def\theindex{\PREINDEXtheindex \addcontentsline{toc}{chapter}{Index}}%
 \xyinputorelse@@{\jobname.ind}{(no index yet)}%
 \let\theindex=\PREINDEXtheindex}
%
\makeatother


\begin{document}
\makexydocactive
%% Hacks to permit delayed package loading.
\def\RequirePackage#1{}
\def\AtBeginDocument#1{#1}

\title{	\Xy-pic Complete Sources with \TeX\-nical Commentary }
\author{ Kristoffer H. Rose\quad<krisrose@tug.org>\thanks{%
                IBM T.J.Watson Research Center, P.O.Box 704, Yorktown Heights, NY 10598, USA}
	\and
	 Ross Moore\quad<ross.moore@mq.edu.au>\thanks{%
		MPCE (Mathematics dept.), Macquarie University,
		North Ryde, Sydney, Australia NSW~2109.}
}
\date{\Xy-pic version \xyversion\ <\xydate>}
\maketitle
\InputIfFileExists{macros.tmp}{}{}
%
\begin{quote}
	Printed \today, from {\tt\jobname.man} version~\stripRCS$Revision: 3.27 $. 

	This report is typeset from the \Xy-pic sources, version~\xyversion\
        released \printdate{\xydate}.  It includes all of the text in the
        \Xy-pic Reference Manual~\cite{Xy-picRM}.
	
	\Xy-pic related files can be retrieved from {\tt http://xy-pic.sourceforge.net}.
\end{quote}
\vfill
\begin{quote}
	\Xy-pic Complete Sources with \TeX\-nical Commentary\\
	Copyright \copyright~1991--2010, Kristoffer H. Rose.\\
	Copyright \copyright~1993--2010, Ross Moore.

	The \Xy-pic package is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version~2 of the
	License, or (at your option) any later version.

	The \Xy-pic package is distributed in the hope that it will be
	useful, but "without any warranty"; without even the implied warranty
	of "merchantability" or "fitness for a particular purpose".  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with the \Xy-pic package; if not, see \url{http://www.gnu.org/licenses/}.
\end{quote}



\chapter*{Preface}
\pagenumbering{roman}

	In this report we present the \TeX\ and \MF\ sources of the \Xy-pic
	package with \TeX\-nical commentary.  It assumes that you are
	familiar with the use of \Xy-pic as described in the User's
	Guide~\cite{Xy-picUG} as well as with the fundamentals of
	\TeX~\cite{K84:TeXbook} and \MF~\cite{K86:MFbook}.

\paragraph*{Overview.}

	Chapter~??[Kernel] explains the \TeX\ sources of the \Xy-picture
	"kernel" drawing language.  Chapter~??[Extensions] explains the
	sources of the standard "extensions" providing extended graphic
	capabilities, and chapter~??[Features] the sources of standard
	"features" providing specialised notation for particular diagram
	types.  Chapter~??[Fonts] exposes the \MF\ sources of the standard
	fonts provided in the distribution.

	The appendices contain additional information: Appendix~A contains
	answers to all the exercises of the main text.  Appendix~B summarises
	the backwards compatibility with \Xy-pic version 2.  Appendix~C
	contains the GNU General Public License detailing the conditions of
	use of \Xy-pic, and appendix~D various support files contained in the
	distribution.  Finally a bibliography and the index.

	The report includes most of the information in the reference
	manual~\cite{Xy-picRM}.

\paragraph*{License.}

	Most of the \Xy-pic package is ??w![copyright] by the individual
	authors.  We have chosen to use the ``??w![GNU
	Copyleft]??w[copyleft]'' to make the package available without
	restriction to as many users as possible and ensure that it is
	attributed to its authors without risk of persecution.  The
	disclaimer can be found on the inside cover page; the full text of
	the license is reproduced as appendix~C.



\tableofcontents
\listoffigures



\chapter{Kernel: xy.doc}
\pagenumbering{arabic}
??:[]??=[Kernel]??:[Kernel]
\restartexercises{\thechapter.}

\def\GROUP{chapter}\def\FILE{chapter}%
\CompilePrefix{xy.doc-}
\inputdoc2{xy.doc}



\chapter{Extensions}
??:[]??=[Extensions]??:[Extensions]
\restartexercises{\thechapter.}
\def\GROUP{chapter}\def\FILE{section}%

	This chapter describes the options that provide extensions to the
	kernel, \ie, support facilities that are not obtainably using the
	kernel.  Most such features are only approximated, relying on a
	driver for the implementation.

\OSECTION{xycurve.doc}
\OSECTION{xyframe.doc}
\OSECTION{xytips.doc}
\OSECTION{xyline.doc}
\OSECTION{xyrotate.doc}
\OSECTION{xycolor.doc}
\OSECTION{xytile.doc}
\OSECTION{xyimport.doc}
\OSECTION{xymovie.doc}
\OSECTION{xyps.doc}
\OSECTION{xytpic.doc}
\OSECTION{xyemtex.doc}
\OSECTION{xynecula.doc}
\OSECTION{xypicture.doc}



\chapter{Features}
??:[]??=[Features]??:[Features]
\restartexercises{\thechapter.}

	This chapter describes the options that support facilities that can
	be obtained using the kernel and extensions yet are much easier to
	obtain using the provided special syntax.

\OSECTION{xyall.doc}
\OSECTION{xydummy.doc}
\OSECTION{xyarrow.doc}
\OSECTION{xy2cell.doc}
\OSECTION{xymatrix.doc}
\OSECTION{xygraph.doc}
\OSECTION{xypoly.doc}
\OSECTION{xyweb.doc}
\OSECTION{xyarc.doc}
\OSECTION{xyknot.doc}
\OSECTION{xysmart.doc}
%\OSECTION{xyling.doc}



\chapter{Drivers}
??:[]??=[drivers]??:[drivers]
\restartexercises{\thechapter.}
\def\GROUP{chapter}\def\FILE{section}%

	This chapter describes the driver options that support customisation
	of the \Xy-pic output to particular output devices.  The first
	section describes the actual drivers, the second a set of
	modifications specially applicable to \PS\ printing.

\section{Support for Specific Drivers}

\DSECTION{xydvidrv.doc}
\DSECTION{xydvips.doc}
\DSECTION{xydvitops.doc}
\DSECTION{xyoztex.doc}
\DSECTION{xy17oztex.doc}
\DSECTION{xytextures.doc}
\DSECTION{xy16textures.doc}
\DSECTION{xyxdvi.doc}

\DTSECTION{xypdf.tex}

	The PDF support is documented separately in the |xypdf.pdf| document,
	typeset by running \LaTeX\ on |xypdf.dtx|.


\section{Extra features with \PS\ support}

\subsection{xyps-ps.doc}\inputdoc2{xyps-ps.doc}
\subsection{xyps-c.doc}\inputdoc2{xyps-c.doc}
\subsection{xyps-f.doc}\inputdoc2{xyps-f.doc}
\subsection{xyps-l.doc}\inputdoc2{xyps-l.doc}
\subsection{xyps-r.doc}\inputdoc2{xyps-r.doc}
\subsection{xyps-t.doc}\inputdoc2{xyps-t.doc}



\chapter{Fonts}
??:[]??=[Fonts]??:[Fonts]
\restartexercises{\thechapter.}
\def\GROUP{chapter}\def\FILE{section}%

	This chapter presents the sources of the \Xy-pic standard fonts used
	by the kernel for computations and as the default way to draw lines
	and frames in the DVI output; in addition we include font tables for
	key fonts where the characters are shown in double size.

	(In the past, Y\&Y Inc.\ gracefully produced high quality PostScript
	Type1 fonts of most of these, however, these are no longer needed as
	the FontForge project and MF2PT1 script together solve the task
	automatically rather well.)

	\TODO: Rewrite the \MF\ code to |mft| format with font tables.

\section{Semidirectional font}

	These are fonts with symmetric characters in $128\times2$ directions
	created using the driver file |xyd2.mf|.  The standard repertoire
	includes only one such font: |xydash10|.

\FILESUBSECTION{xyd2.mf}
\FONTSUBSECTION{xydash10}{ scaled 2000}

\section{Directional font}

	These are fonts with characters in $128$ directions created using the
	driver file |xyd.mf|.  The standard repertoire includes several such
	fonts.

\FILESUBSECTION{xyd.mf}
\FONTSUBSECTION{xyatip10}{ scaled 2000}
\FONTSUBSECTION{xybtip10}{ scaled 2000}
\FONTSUBSECTION{xybsql10}{ scaled 2000}

\section{Special fonts}

	The kernel circle construction uses the following special font with
	1/8 circle segments at various sizes (not scaled):

\FONTSUBSECTION{xycirc10}{}

\section{Optional fonts}

	The ``tips'' extension uses the following fonts by default (we
	only show the 11 point variant).

\FILESUBSECTION{xycmat10.mf}
\FILESUBSECTION{xycmbt10.mf}
\FONTSUBSECTION{xycmat11}{ scaled 2000}
\FONTSUBSECTION{xycmbt11}{ scaled 2000}
\FILESUBSECTION{xycmat12.mf}
\FILESUBSECTION{xycmbt12.mf}

	The following fonts are made to match with the Euler math fonts
	(again we only show the 11 point variant).

\FILESUBSECTION{xyeuat10.mf}
\FILESUBSECTION{xyeubt10.mf}
\FONTSUBSECTION{xyeuat11}{ scaled 2000}
\FONTSUBSECTION{xyeubt11}{ scaled 2000}
\FILESUBSECTION{xyeuat12.mf}
\FILESUBSECTION{xyeubt12.mf}

	Finally, Jeremy Gibbons has contributed the following fonts meant to
	look nice with the Lucida family of fonts (we show the 11 point
	variant).

\FILESUBSECTION{xylu.mf}
\FILESUBSECTION{xyatri.mf}
\FILESUBSECTION{xybtri.mf}
\FILESUBSECTION{xyluat10.mf}
\FILESUBSECTION{xylubt10.mf}
\FONTSUBSECTION{xyluat11}{ scaled 2000}
\FONTSUBSECTION{xylubt11}{ scaled 2000}
\FILESUBSECTION{xyluat12.mf}
\FILESUBSECTION{xylubt12.mf}



\appendix

\chapter{Answers to all exercises}
\Answers



\chapter{Backwards Compatibility}
\def\GROUP{appendix}\def\FILE{section}%

	Backwards compatibility with \Xy-pic version~2 is ensured by the
	`v2' option and its support files. 

\OSECTION{xyv2.doc}

\section{Obsolete fonts}

	These fonts are obsolete since v2.7 but remain part of the
	distribution to make it possible to print DVI files created with
	version 2.6 and earlier versions.  We show the ``misc'' font in
	reduced size so it fits.

\FONTSUBSECTION{xyline10}{ scaled 2000}
\FONTSUBSECTION{xyqc10}{ scaled 2000}
\FONTSUBSECTION{xymisc10}{ scaled 578}




\chapter{Licenses}
\def\GROUP{appendix}\def\FILE{section}%

\input{COPYING.tex}
\input{FONTCOPYING.tex}



\chapter{Distribution support files}
\def\GROUP{appendix}\def\FILE{section}%

	This appendix presents the sources of various support files that are
	part of the \Xy-pic source distribution (except the file |COPYING|
	that contains the text reproduced in appendix~A): the files with
	`hype' for the package, the installation instructions, and the
	generation instructions (to make \Xy-pic from the sources).

\section{Hype}

	These files explain what \Xy-pic is, including as a CTAN `\LaTeXe\
	bundle' standard.

\FILESUBSECTION{CATALOG}
\FILESUBSECTION{README}
\FILESUBSECTION{TRAILER}

\section{Installation instructions}

	This file explains how \Xy-pic is downloaded and installed, \ie,
	where the various files of the distribution should reside in standard
	TDS system.

\FILESUBSECTION{INSTALL}

\section{Generation}

	These files are relevant when \Xy-pic is generated from sources on a
	un*x system.

\FILESUBSECTION{MAKE}
\catcode`\?=12\relax
\FILESUBSECTION{Makefile}
\catcode`\?=\active



\BIBLIOGRAPHY
\INDEX



\end{document}


% $Log: xysource.man,v $
% Revision 3.27  2010/07/27 11:07:26  krisrose
% Hidden xyling sections for now.
%
% Revision 3.26  2010/06/10 18:45:50  krisrose
% Reference to GPL by URL.
%
% Revision 3.25  2010/06/10 18:17:07  krisrose
% xycirc does not fit scaled.
%
% Revision 3.24  2010/06/10 17:56:32  krisrose
% Clean up font references; update Y&Y reference.
%
% Revision 3.23  2010/05/17 23:29:21  krisrose
% Experiment: generate all the Type1 fonts with METAPOST.
%
% Revision 3.22  2010/05/06 17:46:30  krisrose
% Ross Moore's e-mail address updated.
% Many obsolete files degraded to Historic.
%
% Revision 3.21  2010/05/06 03:48:05  krisrose
% Fixed missing references.
%
% Revision 3.20  2010/04/29 01:25:38  krisrose
% Makefile included in sources.  Consolidated a single INSTALL file.
%
% Revision 3.19  2010/04/26 22:01:48  krisrose
% Documentation fixes (hyperref and other things).
%
% Revision 3.18  2010/04/26 05:56:57  krisrose
% Link fixes in progress...
%
% Revision 3.17  2010/04/26 03:47:23  krisrose
% All documentation typesets with pdf option.
%
% Revision 3.16  2010/04/25 21:48:06  krisrose
% First proper integration of xypdf into Xy-pic "make dist".
%
% Revision 3.15  2010/04/21 23:26:07  krisrose
% License patch fixup for TeXnical documentation.
%
% Revision 3.14  2010/04/21 20:37:06  krisrose
% Documentation fixes.
%
% Revision 3.13  2010/04/21 18:41:02  krisrose
% Adjustments preparing for xypdf.dtx and friends!
%
% Revision 3.12  2010/04/20 20:36:43  krisrose
% Documentation updates.
%
% Revision 3.11  2010/04/17 14:45:48  krisrose
% Generate and extract Type1 fonts.
%
% Revision 3.10  2010/04/17 04:19:41  krisrose
% Integrated xylu tips by Jeremy Gibbons.
%
% Revision 3.9  2010/04/16 06:58:06  krisrose
% Version fixed by hand.
%
% Revision 3.8  2010/04/16 06:06:52  krisrose
% Preparing for a new release...
%
% Revision 3.7  1999/02/16 15:12:50  krisrose
% Interim release (Y&Y fonts now free).
%
% Revision 3.3  1996/12/19 03:31:56  krisrose
% Maintenance release
%
% Revision 3.1  1995/09/05  20:31:32  kris
% Releasing!
%
% Revision 3.0  1995/07/07  20:14:21  kris
% Major release w/new User's Guide!
%
% Revision 2.13  1995/07/04  15:11:17  kris
% Ready to release v3?
%
% Revision 2.12  1994/10/25  11:34:25  kris
% Interim release just before v3 [works with AMS-LaTeX 1.2]...
%
% Revision 2.11  1994/07/05  10:37:32  kris
% Third 3beta release [bug fixes].
% Experimental graph feature included (for ECCT-94 presentation).
%
% Revision 2.10  1994/06/15  12:55:07  kris
% Second 3beta release: bug fixes.
%
% Revision 2.9  1994/06/09  15:03:24  kris
% Release 3beta [not official yet].
%
% Revision 2.8  1994/04/08  04:30:00  kris
% Second (bug fix) 3alpha release.
%
% Revision 2.7  1994/03/08  02:06:01  kris
% Release 3alpha.
%
% NEW for version 2.7.

% Tell Emacs that this is a LaTeX document and how it is formatted:
% Local Variables:
% mode:latex
% fill-prefix:"\t"
% fill-column:77
% paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% TeX-master: t
% TeX-command-default: "LaTeX"
% End:
